/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard.dial;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.Dial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.TextDialStyle;
import com.kingdee.bos.ctrl.analysis.web.solution.AbstractVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.ScriptSQL;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.variant.TextVariant;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;

public class TextDial
implements Dial {
    private String id;
    private String value;
    private String valueParse;
    private TextDialStyle style;
    private JSON json;
    private TextVariant var;
    private String name;
    private AbstractVarProvider varProvider;
    private String linkType;
    private String linkTip;
    private String linkURI;
    private String linkReportType;
    private String isTab;

    public TextDial(String id, String value, TextDialStyle style, TextVariant var, String name, AbstractVarProvider varProvider, String linkType, String linkTip, String linkURI, String linkReportType, String isTab) {
        this.id = id;
        this.value = value;
        this.style = style;
        this.var = var;
        this.name = name;
        this.varProvider = varProvider;
        this.linkType = linkType;
        this.linkTip = linkTip;
        this.linkURI = linkURI;
        this.linkReportType = linkReportType;
        this.isTab = isTab;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return "text";
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public boolean isShowTitle() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JSON init(HttpServletRequest request) throws BIReportException {
        this.valueParse = this.value;
        this.valueParse = this.valueParse.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\\n", "<br/>");
        this.valueParse = this.var.parse(this.valueParse, request);
        try {
            this.valueParse = new ScriptSQL().transSql(this.valueParse, this.varProvider, null, null);
        }
        catch (BIReportException e) {
            this.valueParse = this.valueParse + "<br/>\u53d8\u91cf\u89e3\u6790\u51fa\u9519:" + e.getMessage();
        }
        return this.toJSON(request);
    }

    @Override
    public JSON toJSON(HttpServletRequest req) throws DashBoardException {
        if (this.json != null) {
            return this.json;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4, 1.0f);
        map.put("type", this.getType());
        map.put("id", this.getId());
        map.put("text", this.valueParse);
        map.put("style", this.style.toJSON());
        map.put("name", this.name);
        map.put("linkType", this.linkType);
        map.put("linkURI", this.linkURI);
        map.put("linkTip", this.linkTip);
        map.put("linkReportType", this.linkReportType);
        map.put("isTab", this.isTab);
        this.json = new JSONMap(map);
        return this.json;
    }

    @Override
    public String getScript() {
        return "";
    }

    @Override
    public void setScript(String script) {
    }
}

