/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.print.util;

import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.export.ExportType;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReportPage;
import com.kingdee.bos.ctrl.analysis.web.print.exception.PrintSetupException;
import com.kingdee.bos.ctrl.analysis.web.print.model.SetupModel;
import com.kingdee.bos.ctrl.analysis.web.print.util.PrintSetupFactory;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class PrintUtil {
    private static Pattern filePattern = Pattern.compile("[\\\\/:*?\"<>|]");

    public static String print(HttpServletRequest request, ReportPage page) throws BIReportException {
        SetupModel setupModel = PrintSetupFactory.createSetupModel(request);
        String exportType = request.getParameter("exportType");
        String fileName = null;
        if (!(page instanceof BIReportPage)) {
            if (page instanceof ExtReportPage) {
                String action = "";
                HashMap<String, SetupModel> params = new HashMap<String, SetupModel>();
                if (!ExportType.TYPE_PDF.equalsIgnoreCase(exportType)) {
                    throw new BIReportException("\u4e0d\u652f\u6301\u7684\u62a5\u8868\u683c\u5f0f\uff1a" + exportType);
                }
                action = "printToPDF";
                params.put("printSetup", setupModel);
                fileName = ((ExtReportPage)page).getExtReport().service(request, action, params);
                try {
                    fileName = URLEncoder.encode(fileName, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    fileName = "EXTREPORT";
                }
            } else {
                throw new PrintSetupException("\u4e0d\u652f\u6301\u7684\u62a5\u8868\u7c7b\u578b.");
            }
        }
        return request.getContextPath() + "/" + Constants.SERVLET_URL + "?" + "servletType" + "=" + "print" + "&" + "exportType" + "=" + exportType + "&" + "filename" + "=" + fileName;
    }

    public static File getTempFile(String filename) {
        File file;
        Matcher matcher = filePattern.matcher(filename);
        if (matcher.find()) {
            matcher.replaceAll("");
        }
        if (!(file = new File(System.getProperty("java.io.tmpdir"), filename)).exists()) {
            throw new RuntimeException("File '" + file.getAbsolutePath() + "' does not exist");
        }
        return file;
    }
}

