/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.AbstractVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterVerify;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BIReportVarProvider
extends AbstractVarProvider {
    private Map varMapCache = new HashMap();
    private HashMap mapVarForDebug = null;
    private boolean isDebug = true;
    private AbstractVarProvider userDefinedVarProvider = null;

    public BIReportVarProvider(Context ctx, boolean isDebug, String varConfigFilename, String varClassname, String datacenter) throws BIReportException {
        super(ctx);
        this.isDebug = isDebug;
        if (isDebug && varConfigFilename != null) {
            this.makeVarDebugMap(varConfigFilename);
        }
        super.setDatacenter(datacenter);
        this.initVarProvider(ctx, varClassname, datacenter);
    }

    public void verify(Object[] params) throws BIReportException {
        if (this.userDefinedVarProvider instanceof FilterVerify) {
            ((FilterVerify)((Object)this.userDefinedVarProvider)).verify(params);
        }
    }

    @Override
    public Object getVar(String name) throws BIReportException {
        if (!this.varMapCache.containsKey(name)) {
            if (this.isDebug && this.mapVarForDebug.containsKey(name)) {
                this.varMapCache.put(name, this.mapVarForDebug.get(name));
            } else {
                this.userDefinedVarProvider.mapMacro = this.mapMacro;
                this.varMapCache.put(name, this.userDefinedVarProvider.getVar(name));
            }
        }
        return this.varMapCache.get(name);
    }

    public void clear() {
        this.varMapCache.clear();
    }

    public void putMacroList(List macroList) {
        if (macroList == null) {
            return;
        }
        if (macroList.size() > 0) {
            for (String macro : macroList) {
                String[] tcs = macro.split("\u0001");
                if (tcs.length < 2) continue;
                String macroName = tcs[0];
                String macroValue = tcs[1];
                this.mapMacro.put(macroName, macroValue);
            }
        }
    }

    private void makeVarDebugMap(String filePathname) throws BIReportException {
        this.mapVarForDebug = new HashMap();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new BIReportException("\u53d8\u91cf\u8c03\u8bd5\u503c\u8bbe\u7f6e\u6587\u4ef6" + filePathname + "\u89e3\u6790\u51fa\u9519!", e);
        }
        File fileReport = new File(filePathname);
        if (fileReport.exists() && fileReport.length() > 0L) {
            Document doc = null;
            try {
                doc = builder.parse(new File(filePathname));
            }
            catch (Exception e) {
                throw new BIReportException("\u53d8\u91cf\u8c03\u8bd5\u503c\u8bbe\u7f6e\u6587\u4ef6" + filePathname + "\u89e3\u6790\u51fa\u9519!", e);
            }
            Element rootXML = doc.getDocumentElement();
            NodeList varList = rootXML.getElementsByTagName("Var");
            for (int index = 0; index < varList.getLength(); ++index) {
                Node nodeVar = varList.item(index);
                String varName = XmlUtil.getNodeAttribute(nodeVar, "name");
                String varType = XmlUtil.getNodeAttribute(nodeVar, "type");
                String varValueString = XmlUtil.getNodeAttribute(nodeVar, "value");
                try {
                    this.mapVarForDebug.put(varName, this.getTypedValue(varValueString, varType));
                    continue;
                }
                catch (ParseException e) {
                    throw new BIReportException("Date\u53d8\u91cf" + varName + "\u8f6c\u578b\u51fa\u9519(\u65e5\u671f\u683c\u5f0f\u4e3a:yyyy-MM-dd HH:mm:ss \u6216 yyyy-MM-dd)!", e);
                }
            }
        }
    }

    private Object getTypedValue(String valueString, String valueType) throws ParseException {
        if (valueType.equalsIgnoreCase("number")) {
            if (valueString.matches("\\d+")) {
                return Integer.valueOf(valueString);
            }
            return Double.valueOf(valueString);
        }
        if (valueType.equalsIgnoreCase("date")) {
            String strFormat = "";
            strFormat = valueString.length() > 10 ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd";
            SimpleDateFormat format = new SimpleDateFormat(strFormat);
            return format.parse(valueString);
        }
        return valueString;
    }

    private void initVarProvider(Context ctx, String varClassName, String datacenter) throws BIReportException {
        Class<?> classVar = null;
        try {
            classVar = Class.forName(varClassName);
            if (classVar != null) {
                this.userDefinedVarProvider = (AbstractVarProvider)classVar.getConstructor(Context.class).newInstance(ctx);
                this.userDefinedVarProvider.setDatacenter(datacenter);
            }
        }
        catch (Exception e) {
            throw new BIReportException("\u53d8\u91cf\u5bf9\u5e94\u7684\u7c7b" + varClassName + "\u672a\u627e\u5230\u6216\u8005\u6ca1\u6709\u5b9e\u73b0AbstractVarProvider!");
        }
    }
}

