/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.worksheet;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeEvent;
import com.kingdee.bos.ctrl.analysis.modelcore.ModelChangeListener;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.Cell;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.Result;
import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.BIWebComponentSupport;
import com.kingdee.bos.ctrl.analysis.web.WebFrameworkException;
import com.kingdee.bos.ctrl.analysis.web.export.ExportType;
import com.kingdee.bos.ctrl.analysis.web.export.ExportUtil;
import com.kingdee.bos.ctrl.analysis.web.link.DimensionLinkManager;
import com.kingdee.bos.ctrl.analysis.web.pagesetup.PageSetup;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.worksheet.CellBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.CellBuilderImpl;
import com.kingdee.bos.ctrl.analysis.web.worksheet.ColumnAxisBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.ColumnAxisBuilderImpl;
import com.kingdee.bos.ctrl.analysis.web.worksheet.CornerBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.CornerBuilderImpl;
import com.kingdee.bos.ctrl.analysis.web.worksheet.RowAxisBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.RowAxisBuilderImpl;
import com.kingdee.bos.ctrl.analysis.web.worksheet.SlicerBuilder;
import com.kingdee.bos.ctrl.analysis.web.worksheet.SlicerBuilderImpl;
import com.kingdee.bos.ctrl.analysis.web.worksheet.navi.DrillExpandPositionUI;
import com.kingdee.bos.ctrl.analysis.web.worksheet.span.Span;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WorksheetComponent
extends BIWebComponentSupport
implements ModelChangeListener {
    private static Logger logger = CommonLogger.getLogger(WorksheetComponent.class);
    CellBuilder cellBuilder;
    CornerBuilder cornerBuilder;
    SlicerBuilder slicerBuilder;
    RowAxisBuilder rowAxisBuilder;
    ColumnAxisBuilder columnAxisBuilder;
    OlapModel olapModel;
    Document document;
    Result result;
    Element rootElement;
    DrillExpandPositionUI expandUI;
    DimensionLinkManager dimLinkManager;
    String schemename;
    private HashMap mapDocument = new HashMap();
    private boolean showColumnHeader = true;

    public WorksheetComponent(String id, String caption, OlapModel olapModel, DimensionLinkManager dimLinkManager, String schemename) {
        super(id, caption);
        this.setId(id);
        this.setOlapModel(olapModel);
        this.dimLinkManager = dimLinkManager;
        this.schemename = schemename;
    }

    public boolean setOlapModel(OlapModel newOlapModel) {
        if (this.olapModel != newOlapModel) {
            if (this.olapModel != null) {
                this.olapModel.removeModelChangeListener(this);
            }
            this.setDirty(true);
            this.olapModel = newOlapModel;
            this.olapModel.addModelChangeListener(this);
            this.setCellBuilder(new CellBuilderImpl());
            this.setColumnAxisBuilder(new ColumnAxisBuilderImpl());
            this.setRowAxisBuilder(new RowAxisBuilderImpl());
            this.setSlicerBuilder(new SlicerBuilderImpl());
            this.setCornerBuilder(new CornerBuilderImpl());
            this.getColumnAxisBuilder().setHierarchyHeader(this.showColumnHeader ? 1 : 0);
            this.expandUI = new DrillExpandPositionUI();
            return true;
        }
        return false;
    }

    @Override
    public void initialize() throws WebFrameworkException {
        super.initialize();
        this.columnAxisBuilder.initialize(this);
        this.rowAxisBuilder.initialize(this);
        this.cellBuilder.initialize(this);
        this.cornerBuilder.initialize(this);
        this.slicerBuilder.initialize(this);
        this.expandUI.initialize(this);
    }

    @Override
    public void destroy() throws WebFrameworkException {
        this.expandUI.destroy();
        this.slicerBuilder.destroy();
        this.cornerBuilder.destroy();
        this.cellBuilder.destroy();
        this.rowAxisBuilder.destroy();
        this.columnAxisBuilder.destroy();
        super.destroy();
    }

    private void startBuild() {
        this.columnAxisBuilder.startBuild();
        this.rowAxisBuilder.startBuild();
        this.cellBuilder.startBuild();
        this.cornerBuilder.startBuild();
        this.slicerBuilder.startBuild();
        this.expandUI.startBuild();
    }

    private void stopBuild() {
        this.expandUI.stopBuild();
        this.slicerBuilder.stopBuild();
        this.cornerBuilder.stopBuild();
        this.cellBuilder.stopBuild();
        this.rowAxisBuilder.stopBuild();
        this.columnAxisBuilder.stopBuild();
        this.result = null;
    }

    private Document getDocument(int page) {
        return (Document)this.mapDocument.get(new Integer(page));
    }

    private void putDocument(int page, Document doc) {
        if (this.mapDocument.size() > 4) {
            this.mapDocument.clear();
        }
        this.mapDocument.put(new Integer(page), doc);
    }

    @Override
    protected void clearPaginInfo() {
        this.mapDocument.clear();
    }

    @Override
    public synchronized Document render(HttpServletRequest request) throws Exception {
        this.result = this.updateOlapModel();
        this.initPageInfo(this.olapModel.getResult().getRowAxis().getPositions().size());
        int rowStart = this.getRowStart();
        int rowEnd = this.getRowEnd();
        this.document = this.getDocument(this.currentPage);
        if (this.document == null) {
            this.document = XmlUtil.createDocument();
            Element elem = this.render2(request, rowStart, rowEnd);
            this.document.appendChild(elem);
            if (this.dimLinkManager != null) {
                this.dimLinkManager.addDimensionLink(this.document, this.schemename, this.olapModel);
            }
        }
        this.putDocument(this.currentPage, this.document);
        return this.document;
    }

    protected Result updateOlapModel() throws Exception {
        return this.olapModel.getResult();
    }

    private Element render2(HttpServletRequest request, int rowStart, int rowEnd) throws Exception {
        this.rootElement = this.document.createElement("worksheet");
        Element head = this.append("head", this.rootElement);
        Element body = this.append("body", this.rootElement);
        this.startBuild();
        this.rootElement.appendChild(this.buildSlicer());
        this.rootElement.appendChild(this.buildHierachyDOM(this.document, this.getResult().getRowAxis().getHierarchies(), "axis_row"));
        this.rootElement.appendChild(this.buildHierachyDOM(this.document, this.getResult().getColumnAxis().getHierarchies(), "axis_col"));
        this.buildColumns2Dim(head);
        this.buildRows2Dim(body, rowStart, rowEnd);
        this.stopBuild();
        return this.rootElement;
    }

    private Element buildSlicer() {
        Element slicer = this.elem("slicer");
        for (Position p : this.getResult().getSlicer().getPositions()) {
            Member[] members = p.getMembers();
            for (int i = 0; i < members.length; ++i) {
                Element e = this.slicerBuilder.build(members[i]);
                slicer.appendChild(e);
            }
        }
        return slicer;
    }

    private void buildCornerElement(Element parent, int colSpan, int rowSpan) {
        Element corner = this.cornerBuilder.build(colSpan, rowSpan);
        parent.appendChild(corner);
    }

    private void buildColumns2Dim(Element parent) {
        int i;
        Element row;
        int N;
        int colAxisCount = this.columnAxisBuilder.getRowCount();
        int rowAxisCount = this.rowAxisBuilder.getHeaderRowCount();
        int colAxisIndex = 0;
        int rowAxisIndex = 0;
        if (rowAxisCount > colAxisCount) {
            N = rowAxisCount - colAxisCount;
            row = this.append("row", parent);
            this.rowAxisBuilder.buildHeaderRow(row, rowAxisIndex++);
            this.buildCornerElement(row, this.columnAxisBuilder.getColumnCount(), N);
            for (i = 1; i < N; ++i) {
                row = this.append("row", parent);
                this.rowAxisBuilder.buildHeaderRow(row, rowAxisIndex++);
            }
            rowAxisCount -= N;
        } else if (colAxisCount > rowAxisCount) {
            N = colAxisCount - rowAxisCount;
            row = this.append("row", parent);
            this.buildCornerElement(row, this.rowAxisBuilder.getColumnCount(), N);
            this.columnAxisBuilder.buildRow(row, colAxisIndex++, false);
            for (i = 1; i < N; ++i) {
                row = this.append("row", parent);
                this.columnAxisBuilder.buildRow(row, colAxisIndex++, false);
            }
            colAxisCount -= N;
        }
        for (int i2 = 0; i2 < colAxisCount; ++i2) {
            row = this.append("row", parent);
            this.rowAxisBuilder.buildHeaderRow(row, rowAxisIndex++);
            this.columnAxisBuilder.buildRow(row, colAxisIndex++, false);
        }
    }

    private void buildRows2Dim(Element parent, int rowStart, int rowEnd) {
        for (int i = rowStart; i < rowEnd; ++i) {
            boolean even = i % 2 == 0;
            Element row = this.append("row", parent);
            row.setAttribute("rowNum", String.valueOf(i + 1));
            this.rowAxisBuilder.buildRow(row, i, i == rowStart);
            this.buildCells(row, i, even);
        }
    }

    private void buildCells(Element row, int rowIndex, boolean even) {
        int N = this.columnAxisBuilder.getColumnCount();
        for (int i = 0; i < N; ++i) {
            try {
                Cell cell = this.result.getCell(i, rowIndex);
                Element cellElem = this.cellBuilder.build(cell, even, rowIndex, i);
                row.appendChild(cellElem);
                continue;
            }
            catch (NoSuchElementException e) {
                logger.error((Object)"not enough cells", (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    public Element elem(String name) {
        return this.document.createElement(name);
    }

    public Element append(String name, Element parent) {
        Element elem = this.document.createElement(name);
        parent.appendChild(elem);
        return elem;
    }

    private void firstChild(Element child, Element parent) {
        Node before = parent.getFirstChild();
        if (before != null) {
            parent.insertBefore(child, before);
        } else {
            parent.appendChild(child);
        }
    }

    public Element insert(String name, Element parent) {
        Element elem = this.document.createElement(name);
        this.firstChild(elem, parent);
        return elem;
    }

    public Object cdata(String content, Element parent) {
        CDATASection section = this.document.createCDATASection(content);
        parent.appendChild(section);
        return section;
    }

    @Override
    public OlapModel getOlapModel() {
        return this.olapModel;
    }

    public boolean isDirty() {
        return this.document == null;
    }

    public void setDirty(boolean dirty) {
        this.document = null;
        this.mapDocument.clear();
        this.result = null;
        this.rootElement = null;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
        this.setDirty(true);
    }

    public CellBuilder getCellBuilder() {
        return this.cellBuilder;
    }

    public ColumnAxisBuilder getColumnAxisBuilder() {
        return this.columnAxisBuilder;
    }

    public CornerBuilder getCornerBuilder() {
        return this.cornerBuilder;
    }

    public RowAxisBuilder getRowAxisBuilder() {
        return this.rowAxisBuilder;
    }

    public SlicerBuilder getSlicerBuilder() {
        return this.slicerBuilder;
    }

    public void setCellBuilder(CellBuilder cellBuilder) {
        this.cellBuilder = cellBuilder;
    }

    public void setColumnAxisBuilder(ColumnAxisBuilder columnAxisBuilder) {
        this.columnAxisBuilder = columnAxisBuilder;
    }

    public void setCornerBuilder(CornerBuilder cornerBuilder) {
        this.cornerBuilder = cornerBuilder;
    }

    public void setRowAxisBuilder(RowAxisBuilder rowAxisBuilder) {
        this.rowAxisBuilder = rowAxisBuilder;
    }

    public void setSlicerBuilder(SlicerBuilder slicerBuilder) {
        this.slicerBuilder = slicerBuilder;
    }

    public void setShowColumnHeader(boolean b) {
        if (b != this.showColumnHeader) {
            this.showColumnHeader = b;
            this.getColumnAxisBuilder().setHierarchyHeader(this.showColumnHeader ? 1 : 0);
        }
    }

    public Result getResult() {
        return this.result;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public Axis getRowAxis() {
        return this.result.getRowAxis();
    }

    public Axis getColumnAxis() {
        return this.result.getColumnAxis();
    }

    public void doExpandCollapse(String id) {
        this.expandUI.doExpandCollapse(id);
    }

    public void doMemberDrill(String id) {
        this.expandUI.doMemberDrill(id);
    }

    public void doLevelDrill(String id) {
        this.expandUI.doLevelDrill(id);
    }

    public void doDrillUp(String id) {
        this.expandUI.doDrillUp(id);
    }

    public String getSpanInfo(String id) {
        return this.expandUI.getSpanInfo(id);
    }

    private void buildConer(KDSSheet sheet, int row, int col) {
        int conerColSpan = this.rowAxisBuilder.getColumnCount();
        int conerRowSpan = this.columnAxisBuilder.getRowCount() - 1;
        sheet.setCellValue(row, col, (Object)"");
        ExportUtil.addMergeWithBorder(sheet, row, col, conerRowSpan, conerColSpan);
    }

    private int buildColumnHead(KDSSheet sheet, int row, Map mapColumnWidth) {
        int conerColSpan = this.rowAxisBuilder.getColumnCount();
        for (int rowIndex = 0; rowIndex < this.columnAxisBuilder.getRowCount() - 1; ++rowIndex) {
            this.columnAxisBuilder.buildRow(sheet, rowIndex, row, conerColSpan, mapColumnWidth);
            ++row;
        }
        return row;
    }

    private int buildRowColumnHead(KDSSheet sheet, int row, Map mapColumnWidth) {
        this.rowAxisBuilder.buildHeaderRow(sheet, 0, row, 0, mapColumnWidth);
        this.columnAxisBuilder.buildRow(sheet, this.columnAxisBuilder.getRowCount() - 1, row, this.rowAxisBuilder.getColumnCount(), mapColumnWidth);
        return ++row;
    }

    private int buildRowCell(KDSSheet sheet, int row, int rowStart, int rowEnd, Map mapColumnWidth) {
        for (int rowIndex = rowStart; rowIndex <= rowEnd; ++rowIndex) {
            this.rowAxisBuilder.buildRow(sheet, rowIndex, row, 0, mapColumnWidth);
            int N = this.columnAxisBuilder.getColumnCount();
            int col = this.rowAxisBuilder.getColumnCount();
            for (int colIndex = 0; colIndex < N; ++colIndex) {
                try {
                    Cell cell = this.result.getCell(colIndex, rowIndex);
                    sheet.setCellValue(row, col, cell.getValue());
                    ExportUtil.setSheetCellBorder(sheet, row, col);
                    sheet.getCellStyleAttributes(row, col).setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    sheet.getCellStyleAttributes(row, col).setNumberFormat(cell.getFormatString());
                    int calcWidth = ExportUtil.calcWidth(sheet, cell.getFormattedValue());
                    Integer colWidth = (Integer)mapColumnWidth.get(new Integer(col));
                    if (colWidth == null || colWidth.compareTo(new Integer(calcWidth)) < 0) {
                        mapColumnWidth.put(new Integer(col), new Integer(calcWidth));
                        sheet.getColumns().setColumnWidth(col, (float)UnitConverter.px2mm((int)calcWidth));
                    }
                    ++col;
                    continue;
                }
                catch (NoSuchElementException e) {
                    logger.error((Object)"not enough cells", (Throwable)e);
                    e.printStackTrace();
                }
            }
            ++row;
        }
        return row;
    }

    @Override
    public KDSSheet export(KDSBook book, PageSetup pageSetup, String exportType, int sheetIndex, HttpServletRequest request) throws BIReportException {
        KDSSheet sheet = new KDSSheet(book, this.getCaptionForSheet(sheetIndex));
        try {
            this.result = this.updateOlapModel();
        }
        catch (Exception e) {
            return null;
        }
        this.startBuild();
        int row = 0;
        int col = 0;
        HashMap mapColWidth = new HashMap();
        if (ExportType.TYPE_PDF.equalsIgnoreCase(exportType)) {
            row = this.buildCaption(sheet, row, pageSetup.getCaption(), pageSetup.getCaptionFont());
            if (pageSetup.isShowSlicer()) {
                Result result = null;
                Member[] members = null;
                try {
                    result = this.olapModel.getResult();
                    if (result.getSlicer().getPositions().size() > 0) {
                        members = ((Position)result.getSlicer().getPositions().get(0)).getMembers();
                    }
                }
                catch (Exception e) {
                    return null;
                }
                row = this.buildSlicer(sheet, row, members);
            }
        } else if (!ExportType.TYPE_EXCEL.equalsIgnoreCase(exportType)) {
            throw new BIReportException("unsupport exportType " + exportType + "!");
        }
        this.buildConer(sheet, row, col);
        row = this.buildColumnHead(sheet, row, mapColWidth);
        row = this.buildRowColumnHead(sheet, row, mapColWidth);
        int rowStart = 0;
        Result result = null;
        try {
            result = this.olapModel.getResult();
        }
        catch (Exception e) {
            return null;
        }
        int rowEnd = result.getRowAxis().getPositions().size() - 1;
        row = this.buildRowCell(sheet, row, rowStart, rowEnd, mapColWidth);
        if (ExportType.TYPE_PDF.equalsIgnoreCase(exportType)) {
            int sheetTotalColumn = this.rowAxisBuilder.getColumnCount() + this.columnAxisBuilder.getColumnCount();
            int pageContentWidth = pageSetup.getPaperSizeWidth() - pageSetup.getPaperMaginLeft() - pageSetup.getPaperMaginRight();
            this.adjustCaptionSclier(sheet, sheetTotalColumn, pageContentWidth, pageSetup.isShowSlicer());
        }
        this.stopBuild();
        return sheet;
    }

    private String getCaptionForSheet(int sheetIndex) {
        if (this.getCaption() == null || "".equals(this.getCaption())) {
            return "Sheet" + sheetIndex + "(\u8868\u683c)";
        }
        return "Sheet" + sheetIndex + "(" + this.getCaption() + ")";
    }

    public Span getExpandSpan(String id) {
        return this.expandUI.getExpandSpan(id);
    }

    public int getRowCountIncludeHeader() {
        if (this.rowEnd == 0) {
            try {
                this.result = this.updateOlapModel();
                this.initPageInfo(this.olapModel.getResult().getRowAxis().getPositions().size());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int rowcount = this.rowEnd - this.rowStart;
        try {
            int header = OlapModelUtil.getTopAxis(this.getOlapModel()).getHierarchies().length;
            if (this.showColumnHeader) {
                header *= 2;
            }
            rowcount += header;
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        return rowcount;
    }
}

