package com.kingdee.bos.ctrl.analysis.bicomponent.style;
import java_cup.runtime.Symbol;

%%

%eofval{
  return new Symbol(sym.EOF, null);
%eofval}

//%class Flexer
%cup
%unicode


AND=[Aa][Nn][Dd]
OR=[Oo][Rr]
NOT=[Nn][Oo][Tt]
XOR=[Xx][Oo][Rr]
TRUE=[Tt][Rr][Uu][Ee]
FALSE=[Ff][Aa][Ll][Ss][Ee]
ALPHA = [a-zA-Z]
ALNUM = [a-zA-Z_0-9]
IDENT = {ALPHA}{ALNUM}*
BRACKETID = \[[^\]\n\f\r\t]*\]
INSTRING = [^\"\n\f\r\t]
INSTRING2 = [^'\n\f\r\t]
DIGIT=[0-9]
INTEGER=(-)?{DIGIT}+
EXP = ([eE](\+|\-)?{DIGIT}+)
FLOAT = ({DIGIT}+\.{DIGIT}*{EXP}?|{DIGIT}*\.{DIGIT}+{EXP}?|{DIGIT}+{EXP})
LINETEMINATOR=[\r|\n|\r\n]
INPUTCHARACTER=[^\r\n]
WHITESPACE={LINETEMINATOR}|[ \t\f]

/*Attribute*/
COLOR = [Cc][Oo][Ll][Oo][Rr]
BACKGROUND = [Bb][Aa][Cc][Kk][Gg][Rr][Oo][Uu][Nn][Dd]
FORECOLOR = [Ff][Oo][Rr][Ee][Cc][Oo][Ll][Oo][Rr]
BACKGROUNDCOLOR = [Bb][Aa][Cc][Kk][Gg][Rr][Oo][Uu][Nn][Dd][Cc][Oo][Ll][Oo][Rr]
FONTNAME = [Ff][Oo][Nn][Tt][Nn][Aa][Mm][Ee]
FONTSIZE = [Ff][Oo][Nn][Tt][Ss][Ii][Zz][Ee]
ITALIC = [Ii][Tt][Aa][Ll][Ii][Cc]
BOLD = [Bb][Oo][Ll][Dd]
UNDERLINE = [Uu][Nn][Dd][Ee][Rr][Ll][Ii][Nn][Ee]
THROUGHLINE=[Tt][Hh][Rr][Oo][Uu][Gg][Hh][Ll][Ii][Nn][Ee]
ROTATION=[Rr][Oo][Tt][Aa][Tt][Ii][Oo][Nn]

/*Color*/
RGB = [Rr][Gg][Bb]
RED = [Rr][Ee][Dd]
WHITE = [Ww][Hh][Ii][Tt][Ee]
BLACK = [Bb][Ll][Aa][Cc][Kk]
BLUE = [Bb][Ll][Uu][Ee]
GREEN = [Gg][Rr][Ee][Ee][Nn]
LIGHT_GRAY=[Ll][Ii][Gg][Hh][Tt]_[Gg][Rr][Aa][Yy]
GRAY=[Gg][Rr][Aa][Yy]
DARK_GRAY=[Dd][Aa][Rr][Kk]_[Gg][Rr][Aa][Yy]
PINK=[Pp][Ii][Nn][Kk]
ORANGE=[Oo][Rr][Aa][Nn][Gg][Ee]
YELLOW=[Yy][Ee][Ll][Ll][Oo][Ww]
MAGENTA=[Mm][Aa][Gg][Ee][Nn][Tt][Aa]
CYAN=[Cc][Yy][Aa][Nn]
HEXCOLOR = #[a-fA-F0-9]{6}

%%
	{AND} { return new Symbol(sym.AND, yytext()); }
	{OR} { return new Symbol(sym.OR, yytext()); }
	{XOR} { return new Symbol(sym.XOR, yytext()); }
	{NOT} { return new Symbol(sym.NOT, yytext()); }
	{TRUE} { return new Symbol(sym.TRUE, yytext()); }
	{FALSE} { return new Symbol(sym.FALSE, yytext()); }
	":" { return new Symbol(sym.COLON, ":"); }
	"?" { return new Symbol(sym.QUESTION, "?"); }
	";" { return new Symbol(sym.SIMICOLON, ";"); }
	"," { return new Symbol(sym.COMMA, ","); }
	"=" { return new Symbol(sym.EQ, "="); }
	"<>" { return new Symbol(sym.NE, "<>"); }
	"<=" { return new Symbol(sym.LE, "<="); }
	"<" { return new Symbol(sym.LT, "<"); }
	">=" { return new Symbol(sym.GE, ">="); }
	">" { return new Symbol(sym.GT, ">"); }
	"{" { return new Symbol(sym.LBRACE, "{"); }
	"(" { return new Symbol(sym.LPAREN, "("); }
	"}" { return new Symbol(sym.RBRACE, "}"); }
	")" { return new Symbol(sym.RPAREN, ")"); }
	"+" { return new Symbol(sym.PLUS, "+"); }
	"-" { return new Symbol(sym.MINUS, "-"); }
	"*" { return new Symbol(sym.ASTERISK, "*"); }
	"/" { return new Symbol(sym.SOLIDUS, "/"); }
	"||" { return new Symbol(sym.CONCAT, "||"); }
	"." { return new Symbol(sym.DOT, "."); }

	{COLOR} { return new Symbol(sym.COLOR,yytext()); }	
	{FORECOLOR} { return new Symbol(sym.FORECOLOR,yytext()); }	
	{BACKGROUND} { return new Symbol(sym.BACKGROUND,yytext()); }	
	{BACKGROUNDCOLOR} { return new Symbol(sym.BACKGROUNDCOLOR,yytext()); }	
	{FONTNAME} { return new Symbol(sym.FONTNAME,yytext()); }
	{FONTSIZE} { return new Symbol(sym.FONTSIZE,yytext()); }
	{BOLD} { return new Symbol(sym.BOLD,yytext()); }
	{ITALIC} { return new Symbol(sym.ITALIC,yytext()); }
	{UNDERLINE} { return new Symbol(sym.UNDERLINE,yytext()); }
	{THROUGHLINE} { return new Symbol(sym.THROUGHLINE,yytext()); }
	{ROTATION} { return new Symbol(sym.ROTATION,yytext()); }	
	{RGB} { return new Symbol(sym.RGB,yytext()); }
	{RED} { return new Symbol(sym.RED,yytext()); }
	{BLUE} { return new Symbol(sym.BLUE,yytext()); }
	{GREEN} { return new Symbol(sym.GREEN,yytext()); }		
	{WHITE} { return new Symbol(sym.WHITE,yytext()); }
	{BLACK}	{ return new Symbol(sym.BLACK,yytext()); }
	{LIGHT_GRAY}	{ return new Symbol(sym.LIGHT_GRAY,yytext()); }
	{GRAY}	{ return new Symbol(sym.GRAY,yytext()); }
	{DARK_GRAY}	{ return new Symbol(sym.DARK_GRAY,yytext()); }
	{PINK}	{ return new Symbol(sym.PINK,yytext()); }
	{ORANGE}	{ return new Symbol(sym.ORANGE,yytext()); }	
	{YELLOW}	{ return new Symbol(sym.YELLOW,yytext()); }
	{MAGENTA}	{ return new Symbol(sym.MAGENTA,yytext()); }
	{CYAN}	{ return new Symbol(sym.CYAN,yytext()); }

	{HEXCOLOR}	{ return new Symbol(sym.HEXCOLOR,yytext()); }
	
	{INTEGER} { Integer i = new Integer(yytext()); return new Symbol(sym.INTEGER, i); }
	{FLOAT} { Double d = new Double(yytext()); return new Symbol(sym.NUMBER, d); }
	{IDENT} { return new Symbol(sym.ID, yytext()); }
	{BRACKETID} { return new Symbol(sym.QUOTED_ID, yytext()); }
	"\""{INSTRING}*"\"" { return new Symbol(sym.STRING, yytext()); }
	"'"{INSTRING2}*"'" { return new Symbol(sym.STRING, yytext()); }
	{WHITESPACE} { /* ignore white space. */ }
