/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.olap.Filter;
import com.kingdee.bos.ctrl.analysis.olap.ModelFactory;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.bibench.platform.common.OlapRequestParams;
import com.kingdee.bos.ctrl.bibench.platform.common.OlapResponseParams;
import com.kingdee.bos.ctrl.bibench.platform.services.IPlatformFacade;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.Driver;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.remoting.RemoteException;
import com.kingdee.bos.olap.remoting.RemoteInvoke;

public class OlapRequestor {
    private OlapResponseParams returnParams;

    public OlapModel requestModel(OlapRequestParams params, IPlatformFacade facade, boolean remoteConnection, int caller) throws Exception, OLAPException, BOSException {
        this.returnParams = facade.etlModel(params, remoteConnection, caller);
        if (remoteConnection) {
            Connection con = Driver.openRemoteConnection((RemoteInvoke)new BIRDRemoteInvokeAdapter(facade, caller));
            this.returnParams.setConnection(con);
        }
        if (params.getMdx() != null && this.returnParams.getMdx() == null) {
            this.returnParams.setMdx(params.getMdx());
        }
        return this.makeModel(this.returnParams.getMdx(), this.returnParams.getFiltString());
    }

    public OlapModel makeModel(String mdx, String filter) throws OlapException, OLAPException {
        OlapModel model = null;
        model = mdx != null && mdx.length() > 0 ? ModelFactory.makeKDOlapModel((Connection)this.returnParams.getConnection(), (String)mdx) : ModelFactory.makeDefaultKDOlapModel((Connection)this.returnParams.getConnection());
        if (filter != null && filter.trim().length() > 0) {
            ((Filter)model.getExtension("filter")).setCondition(filter);
        }
        return model;
    }

    public OlapResponseParams getReturnParams() {
        return this.returnParams;
    }

    public void close() throws OLAPException {
        if (this.returnParams != null && this.returnParams.getConnection() != null) {
            this.returnParams.getConnection().close();
        }
    }

    class BIRDRemoteInvokeAdapter
    implements RemoteInvoke {
        private IPlatformFacade facade;
        private int caller;

        BIRDRemoteInvokeAdapter(IPlatformFacade aFacade, int aCaller) {
            this.facade = aFacade;
            this.caller = aCaller;
        }

        public Object invoke(String method, Class[] argTypes, Object[] argValues) throws RemoteException {
            try {
                return this.facade.invokeConnectionAction(method, argTypes, argValues, this.caller);
            }
            catch (Exception e) {
                throw new RemoteException((Throwable)e);
            }
        }

        public Object[] invokeBatch(String[] methods, Class[][] argTypes, Object[][] argValues) throws RemoteException {
            return null;
        }
    }
}

