/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.model.nodes;

import com.kingdee.bos.ctrl.bibench.platform.model.listener.ICatalogNodePropertyListener;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.INodeVisitor;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDNodeEnum;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RDBaseNode
implements Serializable,
Comparable {
    private transient Logger log = CommonLogger.getLogger(RDBaseNode.class);
    public static final int DESIGN_STATUS_NORMAL = 0;
    public static final int DESIGN_STATUS_NEW = 1;
    public static final int DESIGN_STATUS_MODIFIED = 2;
    public static final int DESIGN_STATUS_DEL = 3;
    public static final String PROPERTY_NODE = "node";
    private transient List propertyListenerList;
    private Map pros = new HashMap(0);
    private int designStatus = 0;
    private Collection childs = new ArrayList();
    private String id;
    private String parentID;
    private String name;
    private String orgID;
    private int type;
    private String content;
    private String orderKey;

    public String getContent() {
        return this.content;
    }

    protected void setContent(String content) {
        this.content = content;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null && this.name == null || name != null && name.equals(this.name)) {
            return;
        }
        this.name = name;
        this.firePropertyChanged("name");
    }

    public String getOrderKey() {
        return this.orderKey;
    }

    public void setOrderKey(String orderKey) {
        if (orderKey == null && this.orderKey == null || orderKey != null && orderKey.equals(this.orderKey)) {
            return;
        }
        this.orderKey = orderKey;
        this.firePropertyChanged("orderKey");
    }

    public String getOrgID() {
        return this.orgID;
    }

    public void setOrgID(String orgID) {
        this.orgID = orgID;
    }

    public String getParentID() {
        return this.parentID;
    }

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int type) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.firePropertyChanged("type");
    }

    public String toString() {
        if (this.designStatus == 0) {
            return this.name;
        }
        return "* " + this.name;
    }

    public int compareTo(Object o) {
        RDBaseNode c = (RDBaseNode)o;
        if (RDNodeEnum.isDir(this.type) && !RDNodeEnum.isDir(c.getType())) {
            return 1;
        }
        if (!RDNodeEnum.isDir(this.type) && RDNodeEnum.isDir(c.getType())) {
            return -1;
        }
        return this.orderKey.compareTo(c.orderKey);
    }

    public Iterator childIterator() {
        return this.childs.iterator();
    }

    public boolean addChild(RDBaseNode child) {
        return this.childs.add(child);
    }

    public void removeChild(RDBaseNode child) {
        this.childs.remove(child);
    }

    public RDBaseNode searchParent(RDBaseNode item) {
        if (item.getParentID() == this.id) {
            return this;
        }
        RDBaseNode p = null;
        Iterator iter = this.childs.iterator();
        while (iter.hasNext()) {
            p = ((RDBaseNode)iter.next()).searchParent(item);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public int getDesignStatus() {
        return this.designStatus;
    }

    public void setDesignStatus(int designStatus) {
        this.setDesignStatus(designStatus, true);
    }

    public void setDesignStatus(int designStatus, boolean firePropertyChangedEvent) {
        if (this.designStatus != designStatus) {
            this.designStatus = designStatus;
            if (firePropertyChangedEvent) {
                this.firePropertyChanged("designStatus", designStatus != 0);
            }
        }
    }

    public Object getProperty(Object key) {
        return this.pros.get(key);
    }

    public Object setProperty(Object key, Object value) {
        return this.pros.put(key, value);
    }

    public void clearProperties() {
        this.pros.clear();
    }

    public Iterator propertyKeyIterator() {
        return this.pros.keySet().iterator();
    }

    public RDBaseNode getLastChild() {
        Iterator iter = this.childs.iterator();
        RDBaseNode r = null;
        while (iter.hasNext()) {
            r = (RDBaseNode)iter.next();
        }
        return r;
    }

    public List getAllDeepChildren() {
        ArrayList list = new ArrayList();
        this.collecChildren(list, this);
        return list;
    }

    private void collecChildren(List list, RDBaseNode node) {
        Iterator iter = node.childs.iterator();
        RDBaseNode r = null;
        while (iter.hasNext()) {
            r = (RDBaseNode)iter.next();
            list.add(r);
            if (!RDNodeEnum.isDir(r.getType())) continue;
            this.collecChildren(list, r);
        }
    }

    public RDBaseNode copyWithoutChildren() {
        RDBaseNode item = new RDBaseNode();
        item.designStatus = this.designStatus;
        item.id = this.id;
        item.parentID = this.parentID;
        item.name = this.name;
        item.orgID = this.orgID;
        item.type = this.type;
        item.content = this.content;
        item.orderKey = this.orderKey;
        return item;
    }

    public boolean removePropertyListener(ICatalogNodePropertyListener pListener) {
        return this.propertyListenerList.remove(pListener);
    }

    public void addPropertyListener(ICatalogNodePropertyListener pListener) {
        if (this.propertyListenerList == null) {
            this.propertyListenerList = new ArrayList(2);
        }
        this.propertyListenerList.add(pListener);
    }

    public void firePropertyChanged(String proeprty) {
        this.firePropertyChanged(proeprty, true);
    }

    public void firePropertyChanged(String proeprty, boolean markModified) {
        if (markModified) {
            this.markModified();
        }
        if (this.propertyListenerList != null) {
            int n = this.propertyListenerList.size();
            for (int i = 0; i < n; ++i) {
                ((ICatalogNodePropertyListener)this.propertyListenerList.get(i)).valueChanged(proeprty, this);
            }
        }
        if ("content".equals(proeprty)) {
            try {
                this.flushContent();
            }
            catch (Exception e) {
                this.log.error((Object)"Flush content error!", (Throwable)e);
            }
        }
    }

    public boolean isModified() {
        return this.designStatus != 0;
    }

    public void markModified() {
        if (this.designStatus == 0) {
            this.designStatus = 2;
        }
    }

    public void fireContentChanged() {
        this.firePropertyChanged("content");
    }

    protected void flushContent() throws Exception {
    }

    public void accept(INodeVisitor visitor) {
        visitor.visit(this);
    }
}

