/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services;

import com.kingdee.bos.ctrl.bibench.platform.services.IModifier;
import com.kingdee.bos.ctrl.bibench.platform.services.Interceptor;
import com.kingdee.bos.ctrl.bibench.platform.services.InterceptorContext;
import com.kingdee.bos.ctrl.bibench.platform.services.InterceptorFilter;
import com.kingdee.bos.ctrl.bibench.platform.services.InterceptorFilterContext;
import java.util.ArrayList;
import java.util.List;

public class InterceptorHandler {
    private List interceptors = new ArrayList();
    private List interceptorFilters = new ArrayList();
    private IModifier modifier = null;

    public void addInterceptor(Interceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public Interceptor removeInterceptorAt(int i) {
        return (Interceptor)this.interceptors.remove(i);
    }

    public void removeAllInterceptor() {
        this.interceptors.clear();
    }

    public Interceptor getInterceptor(int i) {
        return (Interceptor)this.interceptors.get(i);
    }

    public int interceptorSize() {
        return this.interceptors.size();
    }

    public void addInterceptorFilter(InterceptorFilter interceptorFilter) {
        this.interceptorFilters.add(interceptorFilter);
    }

    public IModifier getModifier() {
        return this.modifier;
    }

    public void setModifier(IModifier aModifier) {
        this.modifier = aModifier;
    }

    public void fireBeforeNewInstance(Class aInterfaceClass) {
        if (this.checkInterceptorFilter(aInterfaceClass)) {
            int n = this.interceptors.size();
            for (int i = 0; i < n; ++i) {
                Interceptor proxyInterceptor = (Interceptor)this.interceptors.get(i);
                proxyInterceptor.beforeNewInstance(aInterfaceClass);
            }
        }
    }

    public void fireAfterNewInstance(Class aInterfaceClass, Object aProxyObject) {
        if (this.checkInterceptorFilter(aInterfaceClass)) {
            int n = this.interceptors.size();
            for (int i = 0; i < n; ++i) {
                Interceptor proxyInterceptor = (Interceptor)this.interceptors.get(i);
                proxyInterceptor.afterNewInstance(aInterfaceClass, aProxyObject);
            }
        }
    }

    private boolean checkInterceptorFilter(Class aClass) {
        InterceptorFilterContext filterContext = new InterceptorFilterContext(aClass);
        return this.checkInterceptorFilter(filterContext);
    }

    public boolean fireBeforeMethodInvocation(InterceptorContext aInterceptorContext) {
        boolean b = false;
        if (this.checkInterceptorFilter(aInterceptorContext)) {
            int n = this.interceptors.size();
            for (int i = 0; i < n; ++i) {
                Interceptor proxyInterceptor = (Interceptor)this.interceptors.get(i);
                proxyInterceptor.beforeMethodInvocation(aInterceptorContext);
                if (!aInterceptorContext.isInterruptInvocation()) continue;
                b = true;
            }
        }
        return b;
    }

    public void fireAfterMethodInvocation(InterceptorContext aInterceptorContext) {
        if (this.checkInterceptorFilter(aInterceptorContext)) {
            int n = this.interceptors.size();
            for (int i = 0; i < n; ++i) {
                Interceptor proxyInterceptor = (Interceptor)this.interceptors.get(i);
                proxyInterceptor.afterMethodInvocation(aInterceptorContext);
            }
        }
    }

    public void fireOnError(Throwable aThrowable) {
        if (this.checkInterceptorFilter(aThrowable)) {
            int n = this.interceptors.size();
            for (int i = 0; i < n; ++i) {
                Interceptor proxyInterceptor = (Interceptor)this.interceptors.get(i);
                proxyInterceptor.onError(aThrowable);
            }
        }
    }

    public InterceptorContext fireBeforeModifyInvocation(InterceptorContext aInterceptorContext) {
        InterceptorContext ret = aInterceptorContext;
        if (this.modifier != null && this.checkInterceptorFilter(aInterceptorContext)) {
            ret = this.modifier.modifyBeforeInvocation(ret);
        }
        return ret;
    }

    public InterceptorContext fireAfterModifyInvocation(InterceptorContext aInterceptorContext) {
        InterceptorContext ret = aInterceptorContext;
        if (this.modifier != null && this.checkInterceptorFilter(aInterceptorContext)) {
            ret = this.modifier.modifyAfterInvocation(ret);
        }
        return ret;
    }

    private boolean checkInterceptorFilter(InterceptorContext aContext) {
        InterceptorFilterContext filterContext = new InterceptorFilterContext();
        filterContext.setArgs(aContext.getArgs());
        filterContext.setMethod(aContext.getMethod());
        return this.checkInterceptorFilter(filterContext);
    }

    private boolean checkInterceptorFilter(InterceptorFilterContext aFilterContext) {
        for (int i = 0; i < this.interceptorFilters.size(); ++i) {
            InterceptorFilter filter = (InterceptorFilter)this.interceptorFilters.get(i);
            if (filter.accept(aFilterContext)) continue;
            return false;
        }
        return true;
    }

    private boolean checkInterceptorFilter(Throwable aThrowable) {
        InterceptorFilterContext filterContext = new InterceptorFilterContext(aThrowable);
        return this.checkInterceptorFilter(filterContext);
    }
}

