/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services;

import com.kingdee.bos.ctrl.bibench.platform.common.XMLConfig;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceItemMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class ServiceConfig
extends XMLConfig {
    public static final int MAX_SERVICE_THREAD = 20;

    public ServiceConfig(InputStream is) throws JDOMException, IOException {
        super(is);
    }

    public int getMaxServiceThread() {
        String s = this.getValue("services/service-thread/max");
        int max = 0;
        if (s != null && s.matches("\\d+")) {
            max = Integer.parseInt(s);
        }
        return max < 1 ? 20 : max;
    }

    public String getDefaultImplementLocatorClass() {
        return this.getValue("services/default-implement-locator");
    }

    public String getExecutorClass() {
        return this.getValue("services/executor");
    }

    public String getStaticProxyClass() {
        return this.getValue("services/static-proxy");
    }

    public String getDynamicProxyClass() {
        return this.getValue("services/dynamic-proxy");
    }

    public String getServiceServerClass() {
        return this.getValue("services/server");
    }

    public String getServiceManagerClass() {
        return this.getValue("services/manager");
    }

    public List getServiceFilterClasses() {
        ArrayList<String> list = new ArrayList<String>();
        String[] ss = this.getValues("services/filters/filter");
        if (ss != null) {
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].length() <= 0) continue;
                list.add(ss[i]);
            }
        }
        return list;
    }

    public List getServiceInterceptorClasses() {
        ArrayList<String> list = new ArrayList<String>();
        String[] ss = this.getValues("services/interceptors/interceptor");
        if (ss != null) {
            for (int i = 0; i < ss.length; ++i) {
                if (ss[i].length() <= 0) continue;
                list.add(ss[i]);
            }
        }
        return list;
    }

    public List getServiceItemMapList() {
        Element[] es = this.getNodes("services/service");
        ArrayList<ServiceItemMap> list = new ArrayList<ServiceItemMap>();
        if (es != null && es.length > 0) {
            for (int i = 0; i < es.length; ++i) {
                Element e = es[i];
                ServiceItemMap item = new ServiceItemMap();
                item.setImplementsClassName(e.getAttributeValue("implement"));
                item.setInterfaceClassName(e.getAttributeValue("interface"));
                list.add(item);
            }
        }
        return list;
    }
}

