/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services.impl;

import com.kingdee.bos.ctrl.bibench.platform.services.Executor;
import com.kingdee.bos.ctrl.bibench.platform.services.ExecutorDecorator;
import com.kingdee.bos.ctrl.bibench.platform.services.IServiceManager;
import com.kingdee.bos.ctrl.bibench.platform.services.Interceptor;
import com.kingdee.bos.ctrl.bibench.platform.services.InterceptorFilter;
import com.kingdee.bos.ctrl.bibench.platform.services.InterceptorHandler;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceConfig;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceContext;
import com.kingdee.bos.ctrl.bibench.platform.services.proxy.DynamicProxy;
import com.kingdee.bos.ctrl.bibench.platform.services.proxy.DynamicProxyFactory;
import com.kingdee.bos.ctrl.bibench.platform.services.proxy.Proxy;
import com.kingdee.bos.ctrl.bibench.platform.services.proxy.ProxyDecorator;
import com.kingdee.bos.ctrl.bibench.platform.services.proxy.StaticLocalObjectProxy;
import com.kingdee.bos.ctrl.bibench.platform.services.proxy.StaticProxy;
import com.kingdee.bos.ctrl.bibench.platform.services.proxy.StaticProxyDecorator;
import com.kingdee.bos.ctrl.bibench.platform.services.util.Util;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ServiceManager
implements IServiceManager {
    private Logger log = CommonLogger.getLogger((String)ServiceManager.class.getName());
    private ServiceContext ctx = null;
    private InterceptorHandler interceptorHandler = new InterceptorHandler();
    private Map proxyDecoratorMap = new HashMap();

    @Override
    public void setServiceContext(ServiceContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public ServiceContext getServiceContext() {
        return this.ctx;
    }

    @Override
    public void addInterceptor(Interceptor interceptor) {
        this.interceptorHandler.addInterceptor(interceptor);
    }

    @Override
    public int getInterceptorSize() {
        return this.interceptorHandler.interceptorSize();
    }

    @Override
    public Interceptor removeInterceptorAt(int pos) {
        Interceptor inter = this.interceptorHandler.removeInterceptorAt(pos);
        this.removeDynamicProxyForHandle();
        return inter;
    }

    public void removeAllInterceptor() {
        this.interceptorHandler.removeAllInterceptor();
        this.removeDynamicProxyForHandle();
    }

    @Override
    public Interceptor getInterceptorAt(int pos) {
        return this.interceptorHandler.getInterceptor(pos);
    }

    @Override
    public Object createService(Class serviceInterface) {
        if (serviceInterface == null) {
            throw new IllegalArgumentException("The service interface can not be null!");
        }
        ProxyDecorator pd = (ProxyDecorator)this.proxyDecoratorMap.get(serviceInterface);
        if (pd == null) {
            pd = this.createProxyDecorator();
            this.proxyDecoratorMap.put(serviceInterface, pd);
            if (this.interceptorHandler.interceptorSize() > 0) {
                this.addDynamicProxyForHandle(pd);
            }
        }
        return pd.newInstance(serviceInterface);
    }

    private StaticProxy createStaticProxy(StaticProxy staticProxyObject) {
        StaticProxyDecorator pd = new StaticProxyDecorator(staticProxyObject);
        pd.setContext(this.ctx);
        return pd;
    }

    private Executor createExecutor(Executor executor) {
        ExecutorDecorator ed = new ExecutorDecorator(executor);
        ed.setServiceContext(this.ctx);
        return ed;
    }

    private ProxyDecorator createProxyDecorator() {
        DynamicProxy dyProxy;
        StaticProxy staticProxy = null;
        Executor executor = null;
        ServiceConfig config = this.ctx.getServiceConfig();
        try {
            Object obj;
            String s = Util.trim(config.getDynamicProxyClass());
            if (!Util.isEmpty(s)) {
                obj = Util.createObject(s);
                if (obj instanceof StaticProxy) {
                    staticProxy = this.createStaticProxy((StaticProxy)obj);
                } else {
                    this.log.info((Object)("Static-proxy is empty, use " + StaticLocalObjectProxy.class + " for default."));
                }
            }
            if (!Util.isEmpty(s = Util.trim(config.getExecutorClass()))) {
                obj = Util.createObject(s);
                if (obj instanceof Executor) {
                    executor = this.createExecutor((Executor)obj);
                } else {
                    this.log.info((Object)"Executor is empty!");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DynamicProxy proxy = dyProxy = DynamicProxyFactory.createDynamicProxy(config.getDynamicProxyClass(), this.ctx);
        if (proxy == null) {
            proxy = DynamicProxyFactory.getDefaultDynamicProxy();
        }
        proxy.setContext(this.ctx);
        proxy.setInterceptorHandler(this.interceptorHandler);
        proxy.setExecutor(executor);
        if (staticProxy == null) {
            staticProxy = new StaticLocalObjectProxy(this.ctx);
        }
        proxy.setStaticProxy(staticProxy);
        ProxyDecorator pd = new ProxyDecorator(proxy, this.interceptorHandler);
        return pd;
    }

    private void addDynamicProxyForHandle(ProxyDecorator pd) {
        Proxy proxy = pd.getProxy();
        if (proxy instanceof StaticProxy) {
            DynamicProxy dyProxy = DynamicProxyFactory.getDefaultDynamicProxy();
            dyProxy.setStaticProxy((StaticProxy)proxy);
            dyProxy.setContext(this.ctx);
            dyProxy.setInterceptorHandler(this.interceptorHandler);
            pd.setProxy(dyProxy);
        }
    }

    private void removeDynamicProxyForHandle() {
        if (this.getInterceptorSize() > 0) {
            return;
        }
        for (ProxyDecorator pd : this.proxyDecoratorMap.values()) {
            DynamicProxy dyProxy;
            StaticProxy staticProxy;
            Proxy proxy;
            if (pd == null || !((proxy = pd.getProxy()) instanceof DynamicProxy) || (staticProxy = (dyProxy = (DynamicProxy)proxy).getStaticProxy()) == null) continue;
            pd.setProxy(staticProxy);
        }
    }

    @Override
    public void addInterceptorFilter(InterceptorFilter interceptorFilter) {
        this.interceptorHandler.addInterceptorFilter(interceptorFilter);
    }
}

