/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services.standalone.server;

import com.kingdee.bos.ctrl.bibench.platform.services.IDataSource;
import com.kingdee.bos.ctrl.bibench.platform.services.IServiceManager;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceContext;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceLauncher;
import com.kingdee.bos.ctrl.bibench.platform.services.impl.IMiniServer;
import com.kingdee.bos.ctrl.bibench.platform.services.standalone.server.MiniServiceController;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class MiniServerShell
extends Thread {
    private Logger log = CommonLogger.getLogger((String)MiniServerShell.class.getName());
    private int port;
    private ServiceLauncher serviceLauncher = null;
    private MiniServiceController tc = null;
    private IDataSource con;

    public MiniServerShell(int port, ServiceContext context, IDataSource con) throws Exception {
        this.port = port;
        this.con = con;
        this.serviceLauncher = new ServiceLauncher(context);
    }

    public IServiceManager getServiceManager() {
        return this.serviceLauncher.getServiceManager();
    }

    public ServiceContext getServiceContext() {
        return this.serviceLauncher.getServiceContext();
    }

    public IMiniServer getMiniServer() {
        return this.serviceLauncher.getMiniServer();
    }

    public MiniServiceController getMiniServiceController() {
        return this.tc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ServerSocket ss = null;
        Socket s = null;
        try {
            this.log.info((Object)"MiniServer starting...");
            this.serviceLauncher.start();
            IServiceManager serviceManager = this.serviceLauncher.getServiceManager();
            IMiniServer miniServer = this.serviceLauncher.getMiniServer();
            this.tc = new MiniServiceController(serviceManager, miniServer, this.con);
            int max = this.serviceLauncher.getServiceContext().getServiceConfig().getMaxServiceThread();
            this.tc.init(max);
            ss = new ServerSocket(this.port);
            this.log.info((Object)("MiniServer startup & listening at port:" + this.port));
            while ((s = ss.accept()) != null) {
                this.tc.dispatchWork(s);
            }
        }
        catch (Exception e) {
            try {
                this.log.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{s, ss});
                this.doStop();
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{s, ss});
            this.doStop();
        }
        CloseUtil.close((Closeable[])new Closeable[]{s, ss});
        this.doStop();
    }

    private void doStop() {
        this.log.info((Object)"Shutdown MiniServer...");
        if (this.tc != null) {
            this.tc.destroy();
        }
        this.serviceLauncher.stop();
    }

    public void terminal() {
        this.doStop();
        super.stop();
    }
}

