/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.filter;

import com.kingdee.bos.ctrl.bibench.platform.model.nodes.report.BaseReport;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterItemCollection;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterUI;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.FaceUtil;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;

public class FilterDialog
extends KDDialog {
    private BaseReport br;
    private PaltformWorkBenchContext ctx;
    private FilterUI panel;
    private FilterItemCollection fc;
    private boolean hasInitPosition = false;

    public FilterDialog(BaseReport br, PaltformWorkBenchContext ctx) {
        this(br, ctx, (Frame)((Object)ctx.getFrame()));
    }

    public FilterDialog(BaseReport br, PaltformWorkBenchContext ctx, Frame parent) {
        super(parent, true);
        this.ctx = ctx;
        this.br = br;
        this.setSize(400, 300);
        Container p = this.getContentPane();
        p.setLayout(new BorderLayout());
        KDPanel btnPanel = new KDPanel((LayoutManager)new FlowLayout(2, 5, 5));
        p.add((Component)btnPanel, "South");
        this.setDefaultCloseOperation(2);
    }

    private void setUI(FilterUI p) {
        if (this.panel != null) {
            this.getContentPane().remove((Component)((Object)this.panel));
        }
        this.panel = p;
        this.getContentPane().add((Component)((Object)p), "Center");
        this.panel.setDialog(this);
    }

    public FilterItemCollection showQueryDialog() throws Exception {
        if (this.fc == null) {
            this.fc = FilterItemCollection.fromScript(this.br.getFilterScript());
        }
        if (this.fc.size() > 0) {
            FilterUI panel = new FilterUI(this.fc, this.ctx);
            this.setUI(panel);
            this.setTitle(this.br.getName() + " - \u6761\u4ef6\u67e5\u8be2");
            this.pack();
            if (!this.hasInitPosition) {
                FaceUtil.center((Window)((Object)this));
                this.hasInitPosition = true;
            }
            this.setVisible(true);
            FilterItemCollection cc = panel.getFilters();
            if (cc == null) {
                return null;
            }
            this.fc = cc;
        }
        return this.fc;
    }

    public boolean isFilterEnabled() {
        if (this.fc == null) {
            try {
                this.fc = FilterItemCollection.fromScript(this.br.getFilterScript());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.fc != null && this.fc.size() > 0;
    }

    public static void preview(FilterItemCollection fc, String title, PaltformWorkBenchContext ctx) throws Exception {
        BaseReport ba = new BaseReport();
        ba.setName(title);
        ba.setFilterScript(fc.toScript());
        FilterDialog dlg = new FilterDialog(ba, ctx);
        dlg.showQueryDialog();
    }
}

