/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.filter;

import com.kingdee.bos.ctrl.bibench.platform.services.util.Util;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.dsfields.BindField;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.AbstractFilterType;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.visitor.FilterSQLVisitor;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FilterItemCollection {
    private static final String ITEM_DIV = "\u0001";
    private List itemList = new ArrayList();

    public void addFilterItem(AbstractFilterType item) {
        this.itemList.add(item);
    }

    public void removeFilterItem(AbstractFilterType item) {
        this.itemList.remove(item);
    }

    public int size() {
        return this.itemList.size();
    }

    public AbstractFilterType get(int i) {
        return (AbstractFilterType)this.itemList.get(i);
    }

    public boolean check(Component parent) {
        HashSet<String> set = new HashSet<String>();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            String name = this.get(i).getName();
            if (Util.isEmpty(name)) {
                MsgBox.warn("\u7b5b\u9009\u6761\u4ef6\u68c0\u6d4b", "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", parent);
                return false;
            }
            if (set.contains(name)) {
                MsgBox.warn("\u7b5b\u9009\u6761\u4ef6\u68c0\u6d4b", "\"" + name + "\"--\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff01", parent);
                return false;
            }
            set.add(name);
        }
        return true;
    }

    public String toScript() {
        StringBuffer s = new StringBuffer();
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            s.append(this.get(i).toScript());
            if (i == n - 1) continue;
            s.append(ITEM_DIV);
        }
        return s.toString();
    }

    public String getAppliedFilterSQL(String name, String sql) {
        ArrayList<String> conditionList = new ArrayList<String>();
        FilterSQLVisitor sqlVisitor = new FilterSQLVisitor();
        for (int i = 0; i < this.itemList.size(); ++i) {
            AbstractFilterType item = (AbstractFilterType)this.itemList.get(i);
            if (item.getValue() == null) continue;
            BindField[] bf = BindField.parseFrom(item.getBindField());
            for (int j = 0; j < bf.length; ++j) {
                if (!name.equals(bf[j].getDs())) continue;
                String condition = bf[j].getField() + item.getLogic();
                condition = condition + item.accept(sqlVisitor, null);
                conditionList.add(condition);
            }
        }
        if (conditionList.size() > 0) {
            StringBuffer s = new StringBuffer();
            s.append("select * from (\n").append(sql).append("\n) A where ");
            int n = conditionList.size();
            for (int i = 0; i < n; ++i) {
                s.append(conditionList.get(i));
                if (i >= n - 1) continue;
                s.append(" and ");
            }
            return s.toString();
        }
        return sql;
    }

    public Map toVarMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < this.itemList.size(); ++i) {
            AbstractFilterType f = (AbstractFilterType)this.itemList.get(i);
            map.put(f.getName(), f.getValue());
        }
        return map;
    }

    public static FilterItemCollection fromScript(String script) throws Exception {
        FilterItemCollection fc = new FilterItemCollection();
        if (script != null && script.length() > 0) {
            String[] s = script.split(ITEM_DIV);
            for (int i = 0; i < s.length; ++i) {
                fc.addFilterItem(AbstractFilterType.fromScript(s[i]));
            }
        }
        return fc;
    }
}

