/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.filter;

import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.ListCollection;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.ListItem;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.AbstractFilterType;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.FilterInteger;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.type.FilterString;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.FaceUtil;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class ListPanel
extends KDPanel {
    private KDWorkButton btnEdit = new KDWorkButton("...");
    private KDTextField txtValue = new KDTextField("");
    private EditDialog dlg = null;
    private ListCollection lc;

    public ListPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.txtValue, "Center");
        this.add((Component)this.btnEdit, "East");
        this.txtValue.setEditable(false);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPanel.this.showEditorDialog();
            }
        });
    }

    private void showEditorDialog() {
        if (this.dlg == null) {
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)this));
            this.dlg = w instanceof Frame ? new EditDialog((Frame)w) : (w instanceof Dialog ? new EditDialog((Dialog)w) : new EditDialog());
        }
        this.dlg.setList(this.lc);
        this.dlg.show(true);
    }

    public Object getValue() {
        return this.lc;
    }

    public void setValue(Object value) {
        this.lc = (ListCollection)value;
        this.txtValue.setText(value == null ? "" : String.valueOf(value));
    }

    class EditDialog
    extends KDDialog {
        private KDRadioButton rbInteger;
        private KDRadioButton rbString;
        private KDTable tbl;
        private KDButton btnOK;
        private KDButton btnCanel;
        private KDWorkButton btnAdd;
        private KDWorkButton btnDel;
        private boolean modified;

        public EditDialog(Frame f) {
            super(f, true);
            this.rbInteger = new KDRadioButton(new FilterInteger().getTypeName());
            this.rbString = new KDRadioButton(new FilterString().getTypeName());
            this.tbl = new KDTable(3, 1, 3);
            this.btnOK = new KDButton("\u786e\u5b9a");
            this.btnCanel = new KDButton("\u53d6\u6d88");
            this.btnAdd = new KDWorkButton(" + ");
            this.btnDel = new KDWorkButton(" - ");
            this.modified = false;
            this.initUI();
        }

        public EditDialog(Dialog f) {
            super(f, true);
            this.rbInteger = new KDRadioButton(new FilterInteger().getTypeName());
            this.rbString = new KDRadioButton(new FilterString().getTypeName());
            this.tbl = new KDTable(3, 1, 3);
            this.btnOK = new KDButton("\u786e\u5b9a");
            this.btnCanel = new KDButton("\u53d6\u6d88");
            this.btnAdd = new KDWorkButton(" + ");
            this.btnDel = new KDWorkButton(" - ");
            this.modified = false;
            this.initUI();
        }

        public EditDialog() {
            this.rbInteger = new KDRadioButton(new FilterInteger().getTypeName());
            this.rbString = new KDRadioButton(new FilterString().getTypeName());
            this.tbl = new KDTable(3, 1, 3);
            this.btnOK = new KDButton("\u786e\u5b9a");
            this.btnCanel = new KDButton("\u53d6\u6d88");
            this.btnAdd = new KDWorkButton(" + ");
            this.btnDel = new KDWorkButton(" - ");
            this.modified = false;
            this.initUI();
        }

        private void initUI() {
            this.setTitle("\u521d\u59cb\u503c-\u5217\u8868");
            this.getContentPane().setLayout(new BorderLayout());
            ButtonGroup bg = new ButtonGroup();
            bg.add((AbstractButton)this.rbInteger);
            bg.add((AbstractButton)this.rbString);
            KDPanel pn = new KDPanel((LayoutManager)new FlowLayout(3, 5, 5));
            pn.add((Component)this.rbString);
            pn.add((Component)this.rbInteger);
            this.getContentPane().add((Component)pn, "North");
            KDContainer c = FaceUtil.createContainer("\u679a\u4e3e\u503c", (Component)this.tbl);
            this.getContentPane().add((Component)c, "Center");
            IRow row = this.tbl.getHeadRow(0);
            row.getCell(0).setValue((Object)"\u503c");
            row.getCell(1).setValue((Object)"\u6807\u7b7e");
            row.getCell(2).setValue((Object)"\u7f3a\u7701");
            this.tbl.getColumn(2).setEditor((ICellEditor)new EditorFactory.BooleanEditor());
            this.tbl.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editValueChanged(KDTEditEvent e) {
                    if (e.getColIndex() == 2 && ((Boolean)e.getValue()).booleanValue()) {
                        int cur = e.getRowIndex();
                        for (int i = 0; i < EditDialog.this.tbl.getRowCount(); ++i) {
                            if (i == cur) continue;
                            EditDialog.this.tbl.getCell(i, 2).setValue((Object)Boolean.FALSE);
                        }
                    }
                    EditDialog.this.modified = true;
                }
            });
            pn = new KDPanel();
            this.getContentPane().add((Component)pn, "South");
            pn.add((Component)this.btnOK);
            pn.add((Component)this.btnCanel);
            this.btnOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.ok();
                }
            });
            this.btnCanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.cancel();
                }
            });
            c.addButton((JButton)this.btnAdd);
            c.addButton((JButton)this.btnDel);
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.addRow();
                }
            });
            this.btnDel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditDialog.this.removeRow();
                }
            });
            this.setSize(400, 300);
            FaceUtil.center((Window)((Object)this));
        }

        private void setList(ListCollection lc) {
            if (lc.getType() instanceof FilterInteger) {
                this.rbInteger.setSelected(true);
            } else {
                this.rbString.setSelected(true);
            }
            int size = lc.size();
            this.tbl.removeRows();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    IRow r = this.tbl.addRow();
                    ListItem item = lc.get(i);
                    r.getCell(0).setValue(item.getValue());
                    r.getCell(1).setValue((Object)item.getLabel());
                    r.getCell(2).setValue((Object)item.isSelected());
                }
            } else {
                this.tbl.addRow().getCell(2).setValue((Object)Boolean.FALSE);
                this.tbl.addRow().getCell(2).setValue((Object)Boolean.FALSE);
                this.tbl.addRow().getCell(2).setValue((Object)Boolean.FALSE);
            }
        }

        private ListCollection getList() {
            ListCollection lc = new ListCollection();
            if (this.rbString.isSelected()) {
                lc.setType(new FilterString());
            } else {
                lc.setType(new FilterInteger());
            }
            int n = this.tbl.getRowCount();
            for (int i = 0; i < n; ++i) {
                ListItem item = new ListItem(this.tbl.getCell(i, 0).getValue(), (String)this.tbl.getCell(i, 1).getValue());
                item.setSelected((Boolean)this.tbl.getCell(i, 2).getValue());
                lc.add(item);
            }
            return lc;
        }

        private void ok() {
            if (this.modified) {
                ListItem item;
                int i;
                ListCollection lc = this.getList();
                AbstractFilterType type = lc.getType();
                for (i = 0; i < lc.size(); ++i) {
                    item = lc.get(i);
                    if (item.valueIsEmpty()) {
                        this.showWarn(i, 0, "\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002");
                        return;
                    }
                    if (!item.labelIsEmpty()) continue;
                    this.showWarn(i, 1, "\u6807\u7b7e\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002");
                    return;
                }
                if (type instanceof FilterInteger) {
                    for (i = 0; i < lc.size(); ++i) {
                        item = lc.get(i);
                        if (((String)item.getValue()).matches("\\d+")) continue;
                        this.showWarn(i, 0, "\u503c\u5e94\u4e3a\u6574\u6570\u3002");
                        return;
                    }
                }
                ListPanel.this.firePropertyChange("valueChanged", ListPanel.this.lc, lc);
                ListPanel.this.lc = lc;
                this.modified = false;
            }
            this.close();
        }

        private void showWarn(int r, int c, String msg) {
            this.tbl.getSelectManager().select(r, c);
            MsgBox.warn("\u5217\u8868", "\u884c" + (r + 1) + msg, (Component)((Object)this));
            this.tbl.scrollToVisible(r, c);
            this.tbl.requestFocus();
        }

        private void cancel() {
            this.close();
        }

        private void close() {
            this.hide();
        }

        private void addRow() {
            this.tbl.addRow();
            this.tbl.scrollToVisible(this.tbl.getRowCount() - 1, 0);
        }

        private void removeRow() {
            KDTSelectBlock b = this.tbl.getSelectManager().get();
            if (b != null) {
                int i = b.getTop();
                this.tbl.removeRow(i);
            }
        }
    }
}

