/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.datasource;

import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsEtlNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.XDataSource;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.datasource.DSAbstractInnerFrame;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.datasource.DSSqlBuilder;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.objtree.EnvVarTreeHelper;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.common.ui.editor.DefaultEditorStyleModel;
import com.kingdee.bos.ctrl.common.ui.editor.StyledEditor;
import com.kingdee.bos.ctrl.common.ui.editor.styled.MiniScriptEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DSETLInnerFrame
extends DSAbstractInnerFrame {
    private KDPanel namePanel = new KDPanel();
    private KDTextField txtName;
    private RDdsEtlNode etlItem;

    public DSETLInnerFrame(RDBaseNode item) {
        super(item);
        DefaultEditorStyleModel s = (DefaultEditorStyleModel)this.editor.getStyleModel();
        s.addStyle(new String[]{"result"}, s.createSimpleAttributeSet(Color.BLUE));
        this.etlItem = (RDdsEtlNode)item;
        this.initUI();
    }

    private void initUI() {
        this.namePanel.setLayout((LayoutManager)new BorderLayout());
        this.namePanel.add((Component)new KDLabel(" ETL\u63cf\u8ff0: "), (Object)"West");
        this.txtName = new KDTextField();
        this.namePanel.add((Component)this.txtName, (Object)"Center");
        this.namePanel.add((Component)new KDPanel(), (Object)"South");
    }

    @Override
    protected Component getPropertyPartView() {
        return EnvVarTreeHelper.createETLEnvTreeComponent("\u73af\u5883\u53d8\u91cf&ETL\u5bf9\u8c61", this.ctx.getUserEnv());
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setEditable(true);
        XDataSource xc = this.etlItem.getDataSourceConfig();
        this.txtName.setText(xc.getName());
        this.editor.setText(xc.getSql());
        this.editor.setCaretPosition(0);
        this.setFieldMap(xc.getFields());
        this.txtName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DSETLInnerFrame.this.doUpdateName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DSETLInnerFrame.this.doUpdateName();
            }
        });
        this.editor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DSETLInnerFrame.this.doUpdateSQL();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DSETLInnerFrame.this.doUpdateSQL();
            }
        });
        this.tblMap.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editValueChanged(KDTEditEvent e) {
                DSETLInnerFrame.this.doUpdateFieldMap();
            }
        });
    }

    Component getNameEditor() {
        return this.namePanel;
    }

    private void doUpdateName() {
        XDataSource xc = this.etlItem.getDataSourceConfig();
        xc.setName(this.txtName.getText());
        this.etlItem.fireContentChanged();
    }

    private void doUpdateSQL() {
        XDataSource xc = this.etlItem.getDataSourceConfig();
        xc.setSql(this.editor.getText());
        this.etlItem.fireContentChanged();
    }

    @Override
    protected void doUpdateFieldMap() {
        XDataSource xc = this.etlItem.getDataSourceConfig();
        xc.removeFieldMaps();
        xc.addFields(this.getFieldMap());
        this.etlItem.fireContentChanged();
    }

    @Override
    protected void onNewRowMap() {
        super.onNewRowMap();
        this.doUpdateFieldMap();
    }

    @Override
    protected void onDelRowMap() {
        super.onDelRowMap();
        this.doUpdateFieldMap();
    }

    @Override
    public void save() {
        if (this.fieldMapModified()) {
            this.doUpdateFieldMap();
        }
        super.save();
    }

    @Override
    protected String getSql() {
        String sql = this.editor.getText().trim();
        try {
            return DSSqlBuilder.getETLSql(sql, "result", this.ctx.getUserID() + this.hashCode(), this.ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
            MsgBox.error("\u6267\u884c\u5f02\u5e38", e.getMessage(), (Component)((Object)this));
            return null;
        }
    }

    @Override
    public boolean close(boolean forceClose) {
        if (super.close(forceClose)) {
            this.ctx.getPlatformFacade().releaseETLResource(this.ctx.getUserID() + this.hashCode());
            return true;
        }
        return false;
    }

    @Override
    public StyledEditor createDSEditor() {
        return MiniScriptEditor.newInstanceSupportVarScript();
    }
}

