/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.desktop;

import com.kingdee.bos.ctrl.analysis.resource.Resources;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDNodeEnum;
import com.kingdee.bos.ctrl.bibench.platform.ui.desktop.ICatalogItemPopMenuActionListener;
import com.kingdee.bos.ctrl.bibench.platform.ui.icon.IconResource;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.IconUtil;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;

public class RDNodeItemMenu {
    private KDMenu menuCreate;
    private KDMenu menuTopCreate;
    KDMenuItem menuOpen;
    KDMenuItem menuSave;
    KDMenuItem menuDel;
    KDMenuItem menuReload;
    private ICatalogItemPopMenuActionListener pmListener;
    private List menuList = new ArrayList();
    private boolean withTopLevelCreate = false;

    public RDNodeItemMenu(ICatalogItemPopMenuActionListener l, boolean withTopLevelCreate) {
        this.pmListener = l;
        this.withTopLevelCreate = withTopLevelCreate;
        this.initUI();
    }

    public KDPopupMenu getPopupMenu(RDBaseNode item) {
        int i;
        int type = item == null ? -1 : item.getType();
        int[] vs = RDNodeItemMenu.getCreateNewItemValues(type);
        int n = vs.length;
        if (n == 0) {
            this.menuCreate.setVisible(false);
        } else {
            this.menuCreate.setVisible(true);
            this.menuCreate.removeAll();
            for (i = 0; i < n; ++i) {
                KDMenuItem km = new KDMenuItem(RDNodeEnum.getRDCatalogItemEnum(vs[i]).getName());
                km.setIcon(IconUtil.getNormalItemIcon(vs[i]));
                this.menuCreate.add((JMenuItem)km);
                km.addActionListener((ActionListener)new MyCreateAction(item, vs[i]));
            }
        }
        if (item == null && this.withTopLevelCreate) {
            this.menuCreate.setVisible(false);
        }
        if (item == null) {
            this.menuOpen.setVisible(false);
            this.menuSave.setVisible(false);
            this.menuDel.setVisible(false);
            this.menuReload.setVisible(false);
        } else {
            boolean isDir = RDNodeEnum.isDir(item.getType());
            this.menuOpen.setVisible(!isDir);
            this.menuSave.setVisible(true);
            this.menuSave.setEnabled(item.isModified());
            this.menuDel.setVisible(true);
            this.menuReload.setVisible(true);
            this.menuReload.setEnabled(item.getDesignStatus() != 1);
        }
        KDPopupMenu pm = new KDPopupMenu();
        int m = this.menuList.size();
        for (i = 0; i < m; ++i) {
            pm.add((JMenuItem)this.menuList.get(i));
        }
        return pm;
    }

    private void initUI() {
        if (this.withTopLevelCreate) {
            this.menuTopCreate = new KDMenu("\u6839\u76ee\u5f55\u65b0\u5efa");
            this.menuTopCreate.setIcon(Resources.getIcon((String)"icon/tbtn_new.gif"));
            this.menuList.add(this.menuTopCreate);
            int[] vs = RDNodeItemMenu.getCreateNewItemValues(-1);
            for (int i = 0; i < vs.length; ++i) {
                KDMenuItem km = new KDMenuItem(RDNodeEnum.getRDCatalogItemEnum(vs[i]).getName());
                km.setIcon(IconUtil.getNormalItemIcon(vs[i]));
                this.menuTopCreate.add((JMenuItem)km);
                km.addActionListener((ActionListener)new MyCreateAction(null, vs[i]));
            }
        }
        this.menuCreate = new KDMenu("\u65b0\u5efa");
        this.menuCreate.setIcon(Resources.getIcon((String)"icon/tbtn_new.gif"));
        this.menuList.add(this.menuCreate);
        this.menuOpen = new KDMenuItem("\u6253\u5f00");
        this.menuOpen.setIcon(Resources.getIcon((String)"icon/tbtn_open.gif"));
        this.menuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDNodeItemMenu.this.pmListener.onOpenCatalogItem();
            }
        });
        this.menuList.add(this.menuOpen);
        this.menuSave = new KDMenuItem("\u4fdd\u5b58");
        this.menuSave.setIcon(Resources.getIcon((String)"icon/tbtn_save.gif"));
        this.menuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDNodeItemMenu.this.pmListener.onSaveCatalogItem();
            }
        });
        this.menuList.add(this.menuSave);
        this.menuDel = new KDMenuItem("\u5220\u9664");
        this.menuDel.setIcon(IconResource.getIcon("tree_delete.gif"));
        this.menuDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDNodeItemMenu.this.pmListener.onDeleteCatalogItem();
            }
        });
        this.menuList.add(this.menuDel);
        this.menuReload = new KDMenuItem("\u91cd\u65b0\u52a0\u8f7d");
        this.menuReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDNodeItemMenu.this.pmListener.onReloadCatalogItem();
            }
        });
        this.menuList.add(this.menuReload);
    }

    public static int[] getCreateNewItemValues(int type) {
        switch (type) {
            case -1: {
                return new int[]{1, 2};
            }
            case 1: {
                return new int[]{1, 4, 11, 12, 13, 14};
            }
            case 2: {
                return new int[]{1, 2, 3};
            }
            case 3: {
                return new int[]{3, 21, 22};
            }
            case 4: {
                return new int[]{20};
            }
            case 11: {
                return new int[0];
            }
            case 12: {
                return new int[0];
            }
            case 13: {
                return new int[0];
            }
            case 14: {
                return new int[0];
            }
            case 20: {
                return new int[0];
            }
            case 21: {
                return new int[0];
            }
            case 22: {
                return new int[0];
            }
        }
        return new int[0];
    }

    class MyCreateAction
    implements ActionListener {
        private RDBaseNode item;
        private int type;

        public MyCreateAction(RDBaseNode item, int type) {
            this.item = item;
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RDNodeItemMenu.this.pmListener.onCreateCatalogItem(this.item, this.type);
        }
    }
}

