/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.chart.panel;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.print.extend.KDImagePrinter;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDOptionPane;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.chart.Chart;
import com.kingdee.bos.ctrl.swing.chart.ChartCategory;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.panel.ChartPropertyEditPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanelConstants;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.FastScatterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.ui.ExtensionFileFilter;
import org.jfree.util.Log;

public class ChartPanel
extends KDPanel
implements ChartPanelConstants,
ChartChangeListener,
ChartProgressListener,
ActionListener,
MouseListener,
MouseMotionListener,
Printable,
Serializable {
    public static final long serialVersionUID = 1001001001L;
    private Chart chart;
    private JFreeChart interChart;
    private List chartMouseListeners;
    private boolean useBuffer;
    private boolean refreshBuffer;
    private Image chartBuffer;
    private int chartBufferHeight;
    private int chartBufferWidth;
    private int minimumDrawWidth;
    private int minimumDrawHeight;
    private int maximumDrawWidth;
    private int maximumDrawHeight;
    private KDPopupMenu popup;
    private ChartRenderingInfo info;
    private Point2D anchor;
    private double scaleX;
    private double scaleY;
    private transient Rectangle2D zoomRectangle = null;
    private Point2D zoomPoint = null;
    private boolean fillZoomRectangle = false;
    private boolean horizontalZoom = false;
    private boolean verticalZoom = false;
    private int zoomTriggerDistance;
    private boolean horizontalAxisTrace = false;
    private boolean verticalAxisTrace = false;
    private KDMenuItem zoomInBothMenuItem;
    private KDMenuItem zoomInHorizontalMenuItem;
    private KDMenuItem zoomInVerticalMenuItem;
    private KDMenuItem zoomOutBothMenuItem;
    private KDMenuItem zoomOutHorizontalMenuItem;
    private KDMenuItem zoomOutVerticalMenuItem;
    private KDMenuItem autoRangeBothMenuItem;
    private KDMenuItem autoRangeHorizontalMenuItem;
    private KDMenuItem autoRangeVerticalMenuItem;
    private transient Line2D verticalTraceLine;
    private transient Line2D horizontalTraceLine;
    private boolean enforceFileExtensions;
    private boolean ownToolTipDelaysActive;
    private int originalToolTipInitialDelay;
    private int originalToolTipReshowDelay;
    private int originalToolTipDismissDelay;
    private int ownToolTipInitialDelay;
    private int ownToolTipReshowDelay;
    private int ownToolTipDismissDelay;
    private double zoomInFactor = 0.5;
    private double zoomOutFactor = 2.0;
    private transient Rectangle2D available = new Rectangle2D.Double();
    private transient Rectangle2D chartArea = new Rectangle2D.Double();

    public ChartPanel(Chart chart, int popupMenuType) {
        this(chart, 680, 420, 300, 200, 800, 600, false, true, true, true, true, true, true, popupMenuType);
    }

    public ChartPanel(Chart chart, boolean useBuffer, int popupMenuType) {
        this(chart, 680, 420, 300, 200, 800, 600, useBuffer, true, true, true, true, true, true, popupMenuType);
    }

    public ChartPanel(Chart chart, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips, boolean change, int popupMenuType) {
        this(chart, 680, 420, 300, 200, 800, 600, false, properties, save, print, zoom, tooltips, change, popupMenuType);
    }

    public ChartPanel(Chart chart, int width, int height, int minimumDrawWidth, int minimumDrawHeight, int maximumDrawWidth, int maximumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips, boolean change, int popupMenuType) {
        this.chart = chart;
        this.interChart = chart.getDelegate();
        this.chartMouseListeners = new ArrayList();
        if (chart.getDelegate() != null) {
            chart.getDelegate().addChangeListener((ChartChangeListener)this);
        }
        this.info = new ChartRenderingInfo();
        this.setPreferredSize(new Dimension(width, height));
        this.useBuffer = useBuffer;
        this.refreshBuffer = false;
        this.minimumDrawWidth = minimumDrawWidth;
        this.minimumDrawHeight = minimumDrawHeight;
        this.maximumDrawWidth = maximumDrawWidth;
        this.maximumDrawHeight = maximumDrawHeight;
        this.popup = null;
        if (properties || save || print || zoom || change) {
            this.popup = this.createPopupMenu(properties, save, print, zoom, change, popupMenuType);
        }
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setDisplayToolTips(tooltips);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.enforceFileExtensions = true;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        this.ownToolTipInitialDelay = ttm.getInitialDelay();
        this.ownToolTipDismissDelay = ttm.getDismissDelay();
        this.ownToolTipReshowDelay = ttm.getReshowDelay();
    }

    public JFreeChart getChart() {
        return this.interChart;
    }

    public void setChart(JFreeChart chart) {
        if (this.interChart != null) {
            this.interChart.removeChangeListener((ChartChangeListener)this);
            this.interChart.removeProgressListener((ChartProgressListener)this);
        }
        this.interChart = chart;
        if (chart != null) {
            this.interChart.addChangeListener((ChartChangeListener)this);
            this.interChart.addProgressListener((ChartProgressListener)this);
            Plot plot = chart.getPlot();
            ValueAxis horizontalAxis = this.getHorizontalValueAxis(plot);
            this.horizontalZoom = this.horizontalZoom && horizontalAxis != null;
            ValueAxis verticalAxis = this.getVerticalValueAxis(plot);
            this.verticalZoom = this.verticalZoom && verticalAxis != null;
        } else {
            this.horizontalZoom = false;
            this.verticalZoom = false;
        }
        if (this.useBuffer) {
            this.refreshBuffer = true;
        }
        this.repaint();
    }

    public int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    public void setMinimumDrawWidth(int width) {
        this.minimumDrawWidth = width;
    }

    public int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    public void setMaximumDrawWidth(int width) {
        this.maximumDrawWidth = width;
    }

    public void setMinimumDrawHeight(int height) {
        this.minimumDrawHeight = height;
    }

    public int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    public int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    public void setMaximumDrawHeight(int height) {
        this.maximumDrawHeight = height;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public KDPopupMenu getPopupMenu() {
        return this.popup;
    }

    public void setPopupMenu(KDPopupMenu popup) {
        this.popup = popup;
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.info;
    }

    public void setMouseZoomable(boolean flag) {
        this.setMouseZoomable(flag, true);
    }

    public void setMouseZoomable(boolean flag, boolean fillRectangle) {
        this.setHorizontalZoom(flag);
        this.setVerticalZoom(flag);
        this.setFillZoomRectangle(fillRectangle);
    }

    public void setHorizontalZoom(boolean flag) {
        Plot plot = this.interChart.getPlot();
        ValueAxis axis = this.getHorizontalValueAxis(plot);
        this.horizontalZoom = flag && axis != null;
    }

    public void setFillZoomRectangle(boolean flag) {
        this.fillZoomRectangle = flag;
    }

    public void setVerticalZoom(boolean flag) {
        Plot plot = this.interChart.getPlot();
        ValueAxis axis = this.getVerticalValueAxis(plot);
        this.verticalZoom = flag && axis != null;
    }

    public int getZoomTriggerDistance() {
        return this.zoomTriggerDistance;
    }

    public void setZoomTriggerDistance(int distance) {
        this.zoomTriggerDistance = distance;
    }

    public void setHorizontalAxisTrace(boolean flag) {
        this.horizontalAxisTrace = flag;
    }

    public void setVerticalAxisTrace(boolean flag) {
        this.verticalAxisTrace = flag;
    }

    public boolean isEnforceFileExtensions() {
        return this.enforceFileExtensions;
    }

    public void setEnforceFileExtensions(boolean enforce) {
        this.enforceFileExtensions = enforce;
    }

    public void setDisplayToolTips(boolean flag) {
        if (flag) {
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        } else {
            ToolTipManager.sharedInstance().unregisterComponent((JComponent)((Object)this));
        }
    }

    public String getToolTipText(MouseEvent e) {
        EntityCollection entities;
        String result = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity entity = entities.getEntity((double)((int)((double)(e.getX() - insets.left) / this.scaleX)), (double)((int)((double)(e.getY() - insets.top) / this.scaleY)));
            if (entity != null) {
                result = entity.getToolTipText();
            }
        }
        return result;
    }

    public Point translateJava2DToScreen(Point2D java2DPoint) {
        Insets insets = this.getInsets();
        int x = (int)(java2DPoint.getX() * this.scaleX + (double)insets.left);
        int y = (int)(java2DPoint.getY() * this.scaleY + (double)insets.top);
        return new Point(x, y);
    }

    public Point2D translateScreenToJava2D(Point screenPoint) {
        Insets insets = this.getInsets();
        double x = (screenPoint.getX() - (double)insets.left) / this.scaleX;
        double y = (screenPoint.getY() - (double)insets.top) / this.scaleY;
        return new Point2D.Double(x, y);
    }

    public ChartEntity getEntityForPoint(int viewX, int viewY) {
        ChartEntity result = null;
        if (this.info != null) {
            Insets insets = this.getInsets();
            double x = (double)(viewX - insets.left) / this.scaleX;
            double y = (double)(viewY - insets.top) / this.scaleY;
            EntityCollection entities = this.info.getEntityCollection();
            result = entities != null ? entities.getEntity(x, y) : null;
        }
        return result;
    }

    public void setRefreshBuffer(boolean flag) {
        this.refreshBuffer = flag;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.interChart == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        this.available.setRect(insets.left, insets.top, size.getWidth() - (double)insets.left - (double)insets.right, size.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean scale = false;
        double drawWidth = this.available.getWidth();
        double drawHeight = this.available.getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (drawWidth < (double)this.minimumDrawWidth) {
            this.scaleX = drawWidth / (double)this.minimumDrawWidth;
            drawWidth = this.minimumDrawWidth;
            scale = true;
        } else if (drawWidth > (double)this.maximumDrawWidth) {
            this.scaleX = drawWidth / (double)this.maximumDrawWidth;
            drawWidth = this.maximumDrawWidth;
            scale = true;
        }
        if (drawHeight < (double)this.minimumDrawHeight) {
            this.scaleY = drawHeight / (double)this.minimumDrawHeight;
            drawHeight = this.minimumDrawHeight;
            scale = true;
        } else if (drawHeight > (double)this.maximumDrawHeight) {
            this.scaleY = drawHeight / (double)this.maximumDrawHeight;
            drawHeight = this.maximumDrawHeight;
            scale = true;
        }
        this.chartArea.setRect(0.0, 0.0, drawWidth, drawHeight);
        if (this.useBuffer) {
            if (this.chartBuffer == null || (double)this.chartBufferWidth != this.available.getWidth() || (double)this.chartBufferHeight != this.available.getHeight()) {
                this.chartBufferWidth = (int)this.available.getWidth();
                this.chartBufferHeight = (int)this.available.getHeight();
                this.chartBuffer = this.createImage(this.chartBufferWidth, this.chartBufferHeight);
                this.refreshBuffer = true;
            }
            if (this.refreshBuffer) {
                Rectangle2D.Double bufferArea = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
                Graphics2D bufferG2 = (Graphics2D)this.chartBuffer.getGraphics();
                if (scale) {
                    AffineTransform saved = bufferG2.getTransform();
                    AffineTransform st = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                    bufferG2.transform(st);
                    this.interChart.draw(bufferG2, this.chartArea, this.anchor, this.info);
                    bufferG2.setTransform(saved);
                } else {
                    this.interChart.draw(bufferG2, (Rectangle2D)bufferArea, this.anchor, this.info);
                }
                this.refreshBuffer = false;
            }
            g2.drawImage(this.chartBuffer, insets.left, insets.right, (ImageObserver)((Object)this));
        } else {
            AffineTransform saved = g2.getTransform();
            g2.translate(insets.left, insets.top);
            if (scale) {
                AffineTransform st = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                g2.transform(st);
            }
            this.interChart.draw(g2, this.chartArea, this.anchor, this.info);
            g2.setTransform(saved);
        }
        this.anchor = null;
        this.verticalTraceLine = null;
        this.horizontalTraceLine = null;
    }

    public void chartChanged(ChartChangeEvent event) {
        this.refreshBuffer = true;
        this.repaint();
    }

    public void chartProgress(ChartProgressEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("PROPERTIES")) {
            this.attemptEditChartProperties();
        } else if (command.equals("SAVE")) {
            try {
                this.doSaveAs();
            }
            catch (IOException iOException) {}
        } else if (command.equals("PRINT")) {
            this.createChartPrintJob();
        } else if (command.equals("ZOOM_IN_BOTH")) {
            this.zoomInBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals("ZOOM_IN_HORIZONTAL")) {
            this.zoomInHorizontal(this.zoomPoint.getX());
        } else if (command.equals("ZOOM_IN_VERTICAL")) {
            this.zoomInVertical(this.zoomPoint.getY());
        } else if (command.equals("ZOOM_OUT_BOTH")) {
            this.zoomOutBoth(this.zoomPoint.getX(), this.zoomPoint.getY());
        } else if (command.equals("ZOOM_HORIZONTAL_BOTH")) {
            this.zoomOutHorizontal(this.zoomPoint.getX());
        } else if (command.equals("ZOOM_VERTICAL_BOTH")) {
            this.zoomOutVertical(this.zoomPoint.getY());
        } else if (command.equals("AUTO_RANGE_BOTH")) {
            this.autoRangeBoth();
        } else if (command.equals("AUTO_RANGE_HORIZONTAL")) {
            this.autoRangeHorizontal();
        } else if (command.equals("AUTO_RANGE_VERTICAL")) {
            this.autoRangeVertical();
        } else if (command.equals(ChartType.CT_PIE.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_PIE);
            this.chart.setChartType(ChartType.CT_PIE);
        } else if (command.equals(ChartType.CT_PIEEXPLODED.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_PIEEXPLODED);
            this.chart.setChartType(ChartType.CT_PIEEXPLODED);
        } else if (command.equals(ChartType.CT_PIE3D.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_PIE3D);
            this.chart.setChartType(ChartType.CT_PIE3D);
        } else if (command.equals(ChartType.CT_MULTIPIE.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_MULTIPIE);
            this.chart.setChartType(ChartType.CT_MULTIPIE);
        } else if (command.equals(ChartType.CT_COLUMNCLUSTERED.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_COLUMNCLUSTERED);
            this.chart.setChartType(ChartType.CT_COLUMNCLUSTERED);
        } else if (command.equals(ChartType.CT_COLUMNSTACKED.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_COLUMNSTACKED);
            this.chart.setChartType(ChartType.CT_COLUMNSTACKED);
        } else if (command.equals(ChartType.CT_COLUMNCLUSTERED3D.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_COLUMNCLUSTERED3D);
            this.chart.setChartType(ChartType.CT_COLUMNCLUSTERED3D);
        } else if (command.equals(ChartType.CT_COLUMNSTACKED3D.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_COLUMNSTACKED3D);
            this.chart.setChartType(ChartType.CT_COLUMNSTACKED3D);
        } else if (command.equals(ChartType.CT_BARCLUSTERED.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_BARCLUSTERED);
            this.chart.setChartType(ChartType.CT_BARCLUSTERED);
        } else if (command.equals(ChartType.CT_BARSTACKED.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_BARSTACKED);
            this.chart.setChartType(ChartType.CT_BARSTACKED);
        } else if (command.equals(ChartType.CT_BARCLUSTERED3D.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_BARCLUSTERED3D);
            this.chart.setChartType(ChartType.CT_BARCLUSTERED3D);
        } else if (command.equals(ChartType.CT_BARSTACKED3D.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_BARSTACKED3D);
            this.chart.setChartType(ChartType.CT_BARSTACKED3D);
        } else if (command.equals(ChartType.CT_WATERFALL.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_WATERFALL);
            this.chart.setChartType(ChartType.CT_WATERFALL);
        } else if (command.equals(ChartType.CT_LINE.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_LINE);
            this.chart.setChartType(ChartType.CT_LINE);
        } else if (command.equals(ChartType.CT_LINEMARKERS.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_LINEMARKERS);
            this.chart.setChartType(ChartType.CT_LINEMARKERS);
        } else if (command.equals(ChartType.CT_LINEMARKERSSTACKED.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_LINEMARKERSSTACKED);
            this.chart.setChartType(ChartType.CT_LINEMARKERSSTACKED);
        } else if (command.equals(ChartType.CT_LINESTACKED.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_LINESTACKED);
            this.chart.setChartType(ChartType.CT_LINESTACKED);
        } else if (command.equals(ChartType.CT_XYSCATTER.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_XYSCATTER);
            this.chart.setChartType(ChartType.CT_XYSCATTER);
        } else if (command.equals(ChartType.CT_XYSCATTERLINES.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_XYSCATTERLINES);
            this.chart.setChartType(ChartType.CT_XYSCATTERLINES);
        } else if (command.equals(ChartType.CT_XYSCATTERLINESNOMARKERS.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_XYSCATTERLINESNOMARKERS);
            this.chart.setChartType(ChartType.CT_XYSCATTERLINESNOMARKERS);
        } else if (command.equals(ChartType.CT_AREA.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_AREA);
            this.chart.setChartType(ChartType.CT_AREA);
        } else if (command.equals(ChartType.CT_AREASTACKED.getName())) {
            this.chart.fireDataChange(this.chart.getChartType(), ChartType.CT_AREASTACKED);
            this.chart.setChartType(ChartType.CT_AREASTACKED);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (!this.ownToolTipDelaysActive) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            this.originalToolTipInitialDelay = ttm.getInitialDelay();
            ttm.setInitialDelay(this.ownToolTipInitialDelay);
            this.originalToolTipReshowDelay = ttm.getReshowDelay();
            ttm.setReshowDelay(this.ownToolTipReshowDelay);
            this.originalToolTipDismissDelay = ttm.getDismissDelay();
            ttm.setDismissDelay(this.ownToolTipDismissDelay);
            this.ownToolTipDelaysActive = true;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.ownToolTipDelaysActive) {
            ToolTipManager ttm = ToolTipManager.sharedInstance();
            ttm.setInitialDelay(this.originalToolTipInitialDelay);
            ttm.setReshowDelay(this.originalToolTipReshowDelay);
            ttm.setDismissDelay(this.originalToolTipDismissDelay);
            this.ownToolTipDelaysActive = false;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.zoomRectangle == null) {
            Rectangle2D scaledDataArea = this.getScaledDataArea();
            double minX = scaledDataArea.getMinX();
            double minY = scaledDataArea.getMinY();
            double maxX = scaledDataArea.getMaxX();
            double maxY = scaledDataArea.getMaxY();
            double x = e.getX();
            double y = e.getY();
            x = Math.max(minX, Math.min(x, maxX));
            y = Math.max(minY, Math.min(y, maxY));
            this.zoomPoint = new Point2D.Double(x, y);
            if (e.isPopupTrigger() && this.popup != null) {
                this.displayPopupMenu(e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.zoomRectangle != null) {
            boolean zoomTrigger2;
            boolean zoomTrigger1 = this.horizontalZoom && Math.abs((double)e.getX() - this.zoomPoint.getX()) >= (double)this.zoomTriggerDistance;
            boolean bl = zoomTrigger2 = this.verticalZoom && Math.abs((double)e.getY() - this.zoomPoint.getY()) >= (double)this.zoomTriggerDistance;
            if (zoomTrigger1 || zoomTrigger2) {
                if (this.horizontalZoom && (double)e.getX() < this.zoomPoint.getX() || this.verticalZoom && (double)e.getY() < this.zoomPoint.getY()) {
                    this.autoRangeBoth();
                } else {
                    double h;
                    double w;
                    double y;
                    double x;
                    Rectangle2D scaledDataArea = this.getScaledDataArea();
                    if (!this.verticalZoom) {
                        x = this.zoomPoint.getX();
                        y = scaledDataArea.getMinY();
                        w = Math.min(this.zoomRectangle.getWidth(), scaledDataArea.getMaxX() - this.zoomPoint.getX());
                        h = scaledDataArea.getHeight();
                    } else if (!this.horizontalZoom) {
                        x = scaledDataArea.getMinX();
                        y = this.zoomPoint.getY();
                        w = scaledDataArea.getWidth();
                        h = Math.min(this.zoomRectangle.getHeight(), scaledDataArea.getMaxY() - this.zoomPoint.getY());
                    } else {
                        x = this.zoomPoint.getX();
                        y = this.zoomPoint.getY();
                        w = Math.min(this.zoomRectangle.getWidth(), scaledDataArea.getMaxX() - this.zoomPoint.getX());
                        h = Math.min(this.zoomRectangle.getHeight(), scaledDataArea.getMaxY() - this.zoomPoint.getY());
                    }
                    Rectangle2D.Double zoomArea = new Rectangle2D.Double(x, y, w, h);
                    Log.debug((Object)("zoomArea = " + zoomArea));
                    this.zoom(zoomArea);
                }
                this.zoomPoint = null;
                this.zoomRectangle = null;
            } else {
                Graphics2D g2 = (Graphics2D)this.getGraphics();
                g2.setXORMode(Color.gray);
                if (this.fillZoomRectangle) {
                    g2.fill(this.zoomRectangle);
                } else {
                    g2.draw(this.zoomRectangle);
                }
                g2.dispose();
                this.zoomRectangle = null;
            }
        } else if (e.isPopupTrigger() && this.popup != null) {
            this.displayPopupMenu(e.getX(), e.getY());
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        EntityCollection entities;
        Insets insets = this.getInsets();
        int x = (int)((double)(event.getX() - insets.left) / this.scaleX);
        int y = (int)((double)(event.getY() - insets.top) / this.scaleY);
        this.anchor = new Point2D.Double(x, y);
        this.interChart.setTitle(this.interChart.getTitle());
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        ChartEntity entity = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            entity = entities.getEntity((double)x, (double)y);
        }
        ChartMouseEvent chartEvent = new ChartMouseEvent(this.getChart(), event, entity);
        for (ChartMouseListener listener : this.chartMouseListeners) {
            listener.chartMouseClicked(chartEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        EntityCollection entities;
        if (this.horizontalAxisTrace) {
            this.drawHorizontalAxisTrace(e.getX());
        }
        if (this.verticalAxisTrace) {
            this.drawVerticalAxisTrace(e.getY());
        }
        if (this.chartMouseListeners.isEmpty()) {
            return;
        }
        Insets insets = this.getInsets();
        int x = (int)((double)(e.getX() - insets.left) / this.scaleX);
        int y = (int)((double)(e.getY() - insets.top) / this.scaleY);
        ChartEntity entity = null;
        if (this.info != null && (entities = this.info.getEntityCollection()) != null) {
            entity = entities.getEntity((double)x, (double)y);
        }
        ChartMouseEvent event = new ChartMouseEvent(this.getChart(), e, entity);
        for (ChartMouseListener listener : this.chartMouseListeners) {
            listener.chartMouseMoved(event);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        g2.setXORMode(Color.gray);
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                g2.fill(this.zoomRectangle);
            } else {
                g2.draw(this.zoomRectangle);
            }
        }
        Rectangle2D scaledDataArea = this.getScaledDataArea();
        if (this.horizontalZoom && this.verticalZoom) {
            double xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            double ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), xmax - this.zoomPoint.getX(), ymax - this.zoomPoint.getY());
        } else if (this.horizontalZoom) {
            double xmax = Math.min((double)e.getX(), scaledDataArea.getMaxX());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), scaledDataArea.getMinY(), xmax - this.zoomPoint.getX(), scaledDataArea.getHeight());
        } else if (this.verticalZoom) {
            double ymax = Math.min((double)e.getY(), scaledDataArea.getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(scaledDataArea.getMinX(), this.zoomPoint.getY(), scaledDataArea.getWidth(), ymax - this.zoomPoint.getY());
        }
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                g2.fill(this.zoomRectangle);
            } else {
                g2.draw(this.zoomRectangle);
            }
        }
        g2.dispose();
    }

    public void zoomInBoth(double x, double y) {
        this.zoomInHorizontal(x);
        this.zoomInVertical(y);
    }

    private ValueAxis getHorizontalValueAxis(Plot plot) {
        CategoryPlot cp;
        if (plot == null) {
            return null;
        }
        ValueAxis axis = null;
        if (plot instanceof CategoryPlot && (cp = (CategoryPlot)plot).getOrientation() == PlotOrientation.HORIZONTAL) {
            axis = cp.getRangeAxis();
        }
        if (plot instanceof XYPlot) {
            XYPlot xyp = (XYPlot)plot;
            if (xyp.getOrientation() == PlotOrientation.HORIZONTAL) {
                axis = xyp.getRangeAxis();
            } else if (xyp.getOrientation() == PlotOrientation.VERTICAL) {
                axis = xyp.getDomainAxis();
            }
        }
        if (plot instanceof FastScatterPlot) {
            FastScatterPlot fsp = (FastScatterPlot)plot;
            axis = fsp.getDomainAxis();
        }
        return axis;
    }

    private ValueAxis getVerticalValueAxis(Plot plot) {
        CategoryPlot cp;
        if (plot == null) {
            return null;
        }
        ValueAxis axis = null;
        if (plot instanceof CategoryPlot && (cp = (CategoryPlot)plot).getOrientation() == PlotOrientation.VERTICAL) {
            axis = cp.getRangeAxis();
        }
        if (plot instanceof XYPlot) {
            XYPlot xyp = (XYPlot)plot;
            if (xyp.getOrientation() == PlotOrientation.HORIZONTAL) {
                axis = xyp.getDomainAxis();
            } else if (xyp.getOrientation() == PlotOrientation.VERTICAL) {
                axis = xyp.getRangeAxis();
            }
        }
        if (plot instanceof FastScatterPlot) {
            FastScatterPlot fsp = (FastScatterPlot)plot;
            axis = fsp.getRangeAxis();
        }
        return axis;
    }

    public void zoomInHorizontal(double x) {
        Plot p = this.interChart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)p;
            plot.zoomHorizontalAxes(this.zoomInFactor);
        }
    }

    public void zoomInVertical(double y) {
        Plot p = this.interChart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)p;
            plot.zoomVerticalAxes(this.zoomInFactor);
        }
    }

    public void zoomOutBoth(double x, double y) {
        this.zoomOutHorizontal(x);
        this.zoomOutVertical(y);
    }

    public void zoomOutHorizontal(double x) {
        Plot p = this.interChart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)p;
            plot.zoomHorizontalAxes(this.zoomOutFactor);
        }
    }

    public void zoomOutVertical(double y) {
        Plot p = this.interChart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)p;
            plot.zoomVerticalAxes(this.zoomOutFactor);
        }
    }

    public void zoom(Rectangle2D selection) {
        double hLower = 0.0;
        double hUpper = 0.0;
        double vLower = 0.0;
        double vUpper = 0.0;
        if (selection.getHeight() > 0.0 && selection.getWidth() > 0.0) {
            Rectangle2D scaledDataArea = this.getScaledDataArea();
            hLower = (selection.getMinX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            hUpper = (selection.getMaxX() - scaledDataArea.getMinX()) / scaledDataArea.getWidth();
            vLower = (scaledDataArea.getMaxY() - selection.getMaxY()) / scaledDataArea.getHeight();
            vUpper = (scaledDataArea.getMaxY() - selection.getMinY()) / scaledDataArea.getHeight();
            Plot p = this.interChart.getPlot();
            if (p instanceof ValueAxisPlot) {
                ValueAxisPlot plot = (ValueAxisPlot)p;
                plot.zoomHorizontalAxes(hLower, hUpper);
                plot.zoomVerticalAxes(vLower, vUpper);
            }
        }
    }

    public void autoRangeBoth() {
        this.autoRangeHorizontal();
        this.autoRangeVertical();
    }

    public void autoRangeHorizontal() {
        Plot p = this.interChart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)p;
            plot.zoomHorizontalAxes(0.0);
        }
    }

    public void autoRangeVertical() {
        Plot p = this.interChart.getPlot();
        if (p instanceof ValueAxisPlot) {
            ValueAxisPlot plot = (ValueAxisPlot)p;
            plot.zoomVerticalAxes(0.0);
        }
    }

    public Rectangle2D getScaledDataArea() {
        Rectangle2D dataArea = this.info.getPlotInfo().getDataArea();
        Insets insets = this.getInsets();
        double x = dataArea.getX() * this.scaleX + (double)insets.left;
        double y = dataArea.getY() * this.scaleY + (double)insets.top;
        double w = dataArea.getWidth() * this.scaleX;
        double h = dataArea.getHeight() * this.scaleY;
        return new Rectangle2D.Double(x, y, w, h);
    }

    public int getInitialDelay() {
        return this.ownToolTipInitialDelay;
    }

    public int getReshowDelay() {
        return this.ownToolTipReshowDelay;
    }

    public int getDismissDelay() {
        return this.ownToolTipDismissDelay;
    }

    public void setInitialDelay(int delay) {
        this.ownToolTipInitialDelay = delay;
    }

    public void setReshowDelay(int delay) {
        this.ownToolTipReshowDelay = delay;
    }

    public void setDismissDelay(int delay) {
        this.ownToolTipDismissDelay = delay;
    }

    public double getZoomInFactor() {
        return this.zoomInFactor;
    }

    public void setZoomInFactor(double factor) {
        this.zoomInFactor = factor;
    }

    public double getZoomOutFactor() {
        return this.zoomOutFactor;
    }

    public void setZoomOutFactor(double factor) {
        this.zoomOutFactor = factor;
    }

    private void drawHorizontalAxisTrace(int x) {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        Rectangle2D dataArea = this.getScaledDataArea();
        g2.setXORMode(Color.orange);
        if ((int)dataArea.getMinX() < x && x < (int)dataArea.getMaxX()) {
            if (this.verticalTraceLine != null) {
                g2.draw(this.verticalTraceLine);
                this.verticalTraceLine.setLine(x, (int)dataArea.getMinY(), x, (int)dataArea.getMaxY());
            } else {
                this.verticalTraceLine = new Line2D.Float(x, (int)dataArea.getMinY(), x, (int)dataArea.getMaxY());
            }
            g2.draw(this.verticalTraceLine);
        }
    }

    private void drawVerticalAxisTrace(int y) {
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        Rectangle2D dataArea = this.getScaledDataArea();
        g2.setXORMode(Color.orange);
        if ((int)dataArea.getMinY() < y && y < (int)dataArea.getMaxY()) {
            if (this.horizontalTraceLine != null) {
                g2.draw(this.horizontalTraceLine);
                this.horizontalTraceLine.setLine((int)dataArea.getMinX(), y, (int)dataArea.getMaxX(), y);
            } else {
                this.horizontalTraceLine = new Line2D.Float((int)dataArea.getMinX(), y, (int)dataArea.getMaxX(), y);
            }
            g2.draw(this.horizontalTraceLine);
        }
    }

    private void attemptEditChartProperties() {
        ChartPropertyEditPanel panel = new ChartPropertyEditPanel(this.interChart);
        int result = KDOptionPane.showConfirmDialog((Component)((Object)this), (Object)panel, (String)LanguageManager.getLangMessage((String)"Chart_Properties", ChartPanel.class, (String)"Chart Properties"), (int)2, (int)-1);
        if (result == 0) {
            panel.updateChartProperties(this.interChart);
        }
    }

    public void doSaveAs() throws IOException {
        KDFileChooser fileChooser = new KDFileChooser();
        ExtensionFileFilter filter = new ExtensionFileFilter(LanguageManager.getLangMessage((String)"PNG_Image_Files", ChartPanel.class, (String)"PNG Image Files"), ".png");
        fileChooser.addChoosableFileFilter((FileFilter)filter);
        fileChooser.addChoosableFileFilter((FileFilter)new ExtensionFileFilter("All files", ""));
        int option = fileChooser.showSaveDialog((Component)((Object)this));
        if (option == 0) {
            String filename = fileChooser.getSelectedFile().getPath();
            if (this.isEnforceFileExtensions() && !filename.endsWith(".png")) {
                filename = filename + ".png";
            }
            ChartUtilities.saveChartAsPNG((File)new File(filename), (JFreeChart)this.interChart, (int)this.getWidth(), (int)this.getHeight());
        }
    }

    public void createChartPrintJob() {
        KDImagePrinter imageManager = new KDImagePrinter();
        BufferedImage img = this.interChart.createBufferedImage(this.getWidth(), this.getHeight());
        Image[] imgs = new Image[]{img};
        imageManager.setData(imgs);
        imageManager.setParent((Component)this.chart.getParent());
        imageManager.printPreview();
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        double w = pf.getImageableWidth();
        double h = pf.getImageableHeight();
        this.interChart.draw(g2, (Rectangle2D)new Rectangle2D.Double(x, y, w, h), this.anchor, null);
        return 0;
    }

    public void addChartMouseListener(ChartMouseListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.chartMouseListeners.add(listener);
    }

    public void removeChartMouseListener(ChartMouseListener listener) {
        this.chartMouseListeners.remove(listener);
    }

    protected KDPopupMenu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom, boolean change, int popupMenuType) {
        KDPopupMenu result = new KDPopupMenu("Chart:");
        boolean separator = false;
        if (properties) {
            KDMenuItem propertiesItem = new KDMenuItem(LanguageManager.getLangMessage((String)"Properties...", ChartPanel.class, (String)"Properties..."));
            propertiesItem.setActionCommand("PROPERTIES");
            propertiesItem.addActionListener((ActionListener)this);
            result.add((JMenuItem)propertiesItem);
            separator = true;
        }
        if (save) {
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            KDMenuItem saveItem = new KDMenuItem(LanguageManager.getLangMessage((String)"Save_as...", ChartPanel.class, (String)"Save As..."));
            saveItem.setActionCommand("SAVE");
            saveItem.addActionListener((ActionListener)this);
            result.add((JMenuItem)saveItem);
            separator = true;
        }
        if (print) {
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            KDMenuItem printItem = new KDMenuItem(LanguageManager.getLangMessage((String)"Print...", ChartPanel.class, (String)"Print..."));
            printItem.setActionCommand("PRINT");
            printItem.addActionListener((ActionListener)this);
            result.add((JMenuItem)printItem);
            separator = true;
        }
        if (zoom) {
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            KDMenu zoomInMenu = new KDMenu(LanguageManager.getLangMessage((String)"Zoom_In", ChartPanel.class, (String)"Zoom In"));
            this.zoomInBothMenuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"All_Axes", ChartPanel.class, (String)"All Axes"));
            this.zoomInBothMenuItem.setActionCommand("ZOOM_IN_BOTH");
            this.zoomInBothMenuItem.addActionListener((ActionListener)this);
            zoomInMenu.add((JMenuItem)this.zoomInBothMenuItem);
            zoomInMenu.addSeparator();
            this.zoomInHorizontalMenuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"Horizontal_Axis", ChartPanel.class, (String)"Horizontal Axis"));
            this.zoomInHorizontalMenuItem.setActionCommand("ZOOM_IN_HORIZONTAL");
            this.zoomInHorizontalMenuItem.addActionListener((ActionListener)this);
            zoomInMenu.add((JMenuItem)this.zoomInHorizontalMenuItem);
            this.zoomInVerticalMenuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"Vertical_Axis", ChartPanel.class, (String)"Vertical Axis"));
            this.zoomInVerticalMenuItem.setActionCommand("ZOOM_IN_VERTICAL");
            this.zoomInVerticalMenuItem.addActionListener((ActionListener)this);
            zoomInMenu.add((JMenuItem)this.zoomInVerticalMenuItem);
            result.add((JMenuItem)zoomInMenu);
            KDMenu zoomOutMenu = new KDMenu(LanguageManager.getLangMessage((String)"Zoom_Out", ChartPanel.class, (String)"Zoom Out"));
            this.zoomOutBothMenuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"All_Axes", ChartPanel.class, (String)"All Axes"));
            this.zoomOutBothMenuItem.setActionCommand("ZOOM_OUT_BOTH");
            this.zoomOutBothMenuItem.addActionListener((ActionListener)this);
            zoomOutMenu.add((JMenuItem)this.zoomOutBothMenuItem);
            zoomOutMenu.addSeparator();
            this.zoomOutHorizontalMenuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"Horizontal_Axis", ChartPanel.class, (String)"Horizontal Axis"));
            this.zoomOutHorizontalMenuItem.setActionCommand("ZOOM_HORIZONTAL_BOTH");
            this.zoomOutHorizontalMenuItem.addActionListener((ActionListener)this);
            zoomOutMenu.add((JMenuItem)this.zoomOutHorizontalMenuItem);
            this.zoomOutVerticalMenuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"Vertical_Axis", ChartPanel.class, (String)"Vertical Axis"));
            this.zoomOutVerticalMenuItem.setActionCommand("ZOOM_VERTICAL_BOTH");
            this.zoomOutVerticalMenuItem.addActionListener((ActionListener)this);
            zoomOutMenu.add((JMenuItem)this.zoomOutVerticalMenuItem);
            result.add((JMenuItem)zoomOutMenu);
            KDMenu autoRangeMenu = new KDMenu(LanguageManager.getLangMessage((String)"Auto_Range", ChartPanel.class, (String)"Auto Range"));
            this.autoRangeBothMenuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"All_Axes", ChartPanel.class, (String)"All Axes"));
            this.autoRangeBothMenuItem.setActionCommand("AUTO_RANGE_BOTH");
            this.autoRangeBothMenuItem.addActionListener((ActionListener)this);
            autoRangeMenu.add((JMenuItem)this.autoRangeBothMenuItem);
            autoRangeMenu.addSeparator();
            this.autoRangeHorizontalMenuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"Horizontal_Axis", ChartPanel.class, (String)"Horizontal Axis"));
            this.autoRangeHorizontalMenuItem.setActionCommand("AUTO_RANGE_HORIZONTAL");
            this.autoRangeHorizontalMenuItem.addActionListener((ActionListener)this);
            autoRangeMenu.add((JMenuItem)this.autoRangeHorizontalMenuItem);
            this.autoRangeVerticalMenuItem = new KDMenuItem(LanguageManager.getLangMessage((String)"Vertical_Axis", ChartPanel.class, (String)"Vertical Axis"));
            this.autoRangeVerticalMenuItem.setActionCommand("AUTO_RANGE_VERTICAL");
            this.autoRangeVerticalMenuItem.addActionListener((ActionListener)this);
            autoRangeMenu.add((JMenuItem)this.autoRangeVerticalMenuItem);
            result.addSeparator();
            result.add((JMenuItem)autoRangeMenu);
            separator = true;
        }
        if (change) {
            if (separator) {
                result.addSeparator();
                separator = false;
            }
            KDMenu changeTypeMenu = new KDMenu(LanguageManager.getLangMessage((String)"Change_Type", ChartPanel.class, (String)"Change Type"));
            List chartTypeList = null;
            Iterator iterator = null;
            ChartType chartType = this.chart.getChartType();
            ChartType newChartType2 = null;
            KDMenuItem chartTypeMenuItem = null;
            if (popupMenuType == 1) {
                if (chartType.getChartCategory() == ChartCategory.PIECHART) {
                    chartTypeList = ChartCategory.PIECHART.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                } else if (chartType.getChartCategory() == ChartCategory.GANTTCHART) {
                    changeTypeMenu.setEnabled(false);
                } else {
                    chartTypeList = ChartCategory.MULTIPIECHART.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                    chartTypeList = ChartCategory.BARCHART.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType || newChartType2 == ChartType.CT_WATERFALL) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                    chartTypeList = ChartCategory.LINECHART.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                    chartTypeList = ChartCategory.SCATTERPLOT.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                    chartTypeList = ChartCategory.AREACHART.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                }
            } else if (popupMenuType == 2) {
                if (chartType.getChartCategory() == ChartCategory.GANTTCHART) {
                    changeTypeMenu.setEnabled(false);
                } else {
                    chartTypeList = ChartCategory.PIECHART.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                    chartTypeList = ChartCategory.BARCHART.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                    chartTypeList = ChartCategory.LINECHART.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                    chartTypeList = ChartCategory.SCATTERPLOT.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                    chartTypeList = ChartCategory.AREACHART.getChartTypes();
                    for (ChartType newChartType2 : chartTypeList) {
                        if (newChartType2 == chartType) continue;
                        chartTypeMenuItem = new KDMenuItem(newChartType2.getAlias());
                        chartTypeMenuItem.setActionCommand(newChartType2.getName());
                        chartTypeMenuItem.addActionListener((ActionListener)this);
                        changeTypeMenu.add((JMenuItem)chartTypeMenuItem);
                    }
                }
            }
            result.add((JMenuItem)changeTypeMenu);
        }
        return result;
    }

    protected void displayPopupMenu(int x, int y) {
        if (this.popup != null) {
            boolean isVertical;
            Plot plot = this.interChart.getPlot();
            ValueAxis horizontalAxis = this.getHorizontalValueAxis(plot);
            boolean isHorizontal = horizontalAxis != null;
            ValueAxis verticalAxis = this.getVerticalValueAxis(plot);
            boolean bl = isVertical = verticalAxis != null;
            if (this.zoomInHorizontalMenuItem != null) {
                this.zoomInHorizontalMenuItem.setEnabled(isHorizontal);
            }
            if (this.zoomOutHorizontalMenuItem != null) {
                this.zoomOutHorizontalMenuItem.setEnabled(isHorizontal);
            }
            if (this.autoRangeHorizontalMenuItem != null) {
                this.autoRangeHorizontalMenuItem.setEnabled(isHorizontal);
            }
            if (this.zoomInVerticalMenuItem != null) {
                this.zoomInVerticalMenuItem.setEnabled(isVertical);
            }
            if (this.zoomOutVerticalMenuItem != null) {
                this.zoomOutVerticalMenuItem.setEnabled(isVertical);
            }
            if (this.autoRangeVerticalMenuItem != null) {
                this.autoRangeVerticalMenuItem.setEnabled(isVertical);
            }
            if (this.zoomInBothMenuItem != null) {
                this.zoomInBothMenuItem.setEnabled(isHorizontal & isVertical);
            }
            if (this.zoomOutBothMenuItem != null) {
                this.zoomOutBothMenuItem.setEnabled(isHorizontal & isVertical);
            }
            if (this.autoRangeBothMenuItem != null) {
                this.autoRangeBothMenuItem.setEnabled(isHorizontal & isVertical);
            }
            this.popup.show((Component)((Object)this), x, y);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.available = new Rectangle2D.Double();
        this.chartArea = new Rectangle2D.Double();
    }
}

