/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common;

import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FilterTreeModel
extends DefaultTreeModel {
    private TreeModel treeModel;
    private ArrayList lastPath = new ArrayList();
    private Object lastParent;
    private RefTreeNode lastRefParent;

    public FilterTreeModel(TreeModel treeModel) {
        super(new RefTreeNode((TreeNode)treeModel.getRoot()));
        this.treeModel = treeModel;
    }

    @Override
    public Object getRoot() {
        return ((RefTreeNode)super.getRoot()).getTreeNode();
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.treeModel.isLeaf(node);
    }

    private static int getRefChildIndex(RefTreeNode tnRef, TreeNode tnChild) {
        int z = tnRef.getChildCount();
        for (int i = 0; i < z; ++i) {
            RefTreeNode tnRefChild = (RefTreeNode)tnRef.getChildAt(i);
            if (tnChild != tnRefChild.getTreeNode()) continue;
            return i;
        }
        return -1;
    }

    private static RefTreeNode getRefChild(RefTreeNode tnRef, TreeNode tnChild) {
        return (RefTreeNode)tnRef.getChildAt(FilterTreeModel.getRefChildIndex(tnRef, tnChild));
    }

    private RefTreeNode getRefParent(Object parent) {
        if (parent == this.lastParent) {
            return this.lastRefParent;
        }
        TreeNode tn = (TreeNode)parent;
        int i = 0;
        while (tn != null) {
            this.lastPath.set(i, parent);
            tn = tn.getParent();
            ++i;
        }
        RefTreeNode tnRef = (RefTreeNode)super.getRoot();
        --i;
        while (i >= 0) {
            tn = (TreeNode)this.lastPath.get(i);
            tnRef = FilterTreeModel.getRefChild(tnRef, tn);
            --i;
        }
        return tnRef;
    }

    @Override
    public int getChildCount(Object parent) {
        RefTreeNode refParent = this.getRefParent(parent);
        return super.getChildCount(refParent);
    }

    @Override
    public Object getChild(Object parent, int index) {
        RefTreeNode refParent = this.getRefParent(parent);
        return super.getChild(refParent, index);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        RefTreeNode refParent = this.getRefParent(parent);
        return FilterTreeModel.getRefChildIndex(refParent, (TreeNode)child);
    }

    public static void main(String[] args) {
    }

    private static class RefTreeNode
    extends DefaultMutableTreeNode {
        private TreeNode treeNode;

        RefTreeNode(TreeNode tn) {
            this.treeNode = tn;
        }

        public final TreeNode getTreeNode() {
            return this.treeNode;
        }

        public final void setTreeNode(TreeNode treeNode) {
            this.treeNode = treeNode;
        }
    }
}

