/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.hyperlink;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.util.ArrayList;

public class HyperLinkHandler {
    public static final String PREFIX_FILE = "";
    public static final String PREFIX_BOOK = "#";
    public static final String PREFIX_URI = "uri:";
    public static final String PREFIX_MAIL = "mailto:";
    public static final String PREFIX_USER = "user:";
    public static final String FUSIONCHART_HYPERLINK = "FusionChart_Graph_Link:";
    public static final String PREFIX_RPTINNER = "rptInner:";
    public static final String PREFIX_FSCHART = "fsChart:";
    public static final String PREFIX_FSCHART_INNER = "fsChartInner:";
    public static final String SEPARATOR = ";";
    private ArrayList _prefixs = new ArrayList();
    private ArrayList _execs = new ArrayList();

    public HyperLinkHandler() {
        this._prefixs.add(PREFIX_FILE);
        this._execs.add(null);
    }

    public void setExec(String prefix, IHyperLinkExec exec) {
        this._prefixs.add(prefix);
        this._execs.add(exec);
    }

    public void setDefaultExec(IHyperLinkExec exec) {
        this._execs.set(0, exec);
    }

    public String getPrefix(HyperLink link) {
        String linkTo = link.getLinkTo();
        int size = this._prefixs.size();
        for (int i = 1; i < size; ++i) {
            String prefix = (String)this._prefixs.get(i);
            if (!linkTo.startsWith(prefix)) continue;
            return prefix;
        }
        return (String)this._prefixs.get(0);
    }

    public void execute(HyperLink link) {
        String prefix;
        String linkTo = link.getLinkTo();
        String[] arrLinkTo = linkTo.split(SEPARATOR);
        int size = this._prefixs.size();
        boolean isExec = false;
        for (int i = 1; i < size; ++i) {
            prefix = (String)this._prefixs.get(i);
            for (int j = 0; j < arrLinkTo.length; ++j) {
                IHyperLinkExec exec;
                String target = arrLinkTo[j];
                if (StringUtil.isEmptyString((String)target) || !target.startsWith(prefix) || (exec = (IHyperLinkExec)this._execs.get(i)) == null) continue;
                exec.execute(target.substring(prefix.length()));
                isExec = true;
            }
        }
        if (isExec) {
            return;
        }
        IHyperLinkExec exec = (IHyperLinkExec)this._execs.get(0);
        prefix = (String)this._prefixs.get(0);
        if (exec != null) {
            exec.execute(linkTo.substring(prefix.length()));
        }
    }

    public IHyperLinkExec getLinkExec(String prefix) {
        if (StringUtil.isEmptyString((String)prefix)) {
            return null;
        }
        int size = this._prefixs.size();
        for (int i = 1; i < size; ++i) {
            String pre = (String)this._prefixs.get(i);
            if (StringUtil.isEmptyString((String)pre) || !pre.equals(prefix)) continue;
            return (IHyperLinkExec)this._execs.get(i);
        }
        return null;
    }
}

