/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.resource.ResourceManager;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListView
extends KDPanel {
    public static String BUTTON_MOVE_UP = "Up";
    public static String BUTTON_MOVE_DOWN = "Down";
    private KDList list;
    private KDPanel titlePane;
    private KDLabel labTitle;
    private KDWorkButton btnUp;
    private KDWorkButton btnDown;
    private HashMap mapExtBtn;
    private boolean enableMoveItem = true;

    public ListView() {
        this.setOpaque(false);
        this.init();
        this.installListener();
    }

    public void setEnableMoveItem(boolean enable) {
        this.btnDown.setEnabled(enable);
        this.btnUp.setEnabled(enable);
        this.enableMoveItem = enable;
        this.btnDown.setVisible(enable);
        this.btnUp.setVisible(enable);
    }

    public boolean isEnableMoveItem() {
        return this.enableMoveItem;
    }

    private void init() {
        this.list = new KDList();
        this.titlePane = new KDPanel();
        this.labTitle = new KDLabel();
        this.btnUp = new KDWorkButton((Icon)Resource.ICON_MOVE_TOP);
        this.btnDown = new KDWorkButton((Icon)Resource.ICON_MOVE_DOWN);
        this.btnUp.setToolTipText(ResourceManager.getMLS("moveUp", "\u4e0a\u79fb"));
        this.btnDown.setToolTipText(ResourceManager.getMLS("moveDown", "\u4e0b\u79fb"));
        this.btnUp.setMinimumSize(new Dimension(26, 19));
        this.btnDown.setMinimumSize(new Dimension(26, 19));
        this.titlePane.setOpaque(false);
        this.titlePane.add((Component)this.labTitle);
        this.titlePane.add((Component)this.btnUp);
        this.resetTitlePaneLayout(this.btnDown);
        TableLayout tl = TableLayout.split((int)2, (int)1);
        tl.rowStyle(0).setHeight(19);
        tl.rowStyle(0).setMarginBottom(1);
        tl.rowStyle(1).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)this.titlePane, tl.cell(0));
        this.add((Component)new KDScrollPane((Component)this.list), tl.cell(1));
        this.syncBtn();
    }

    private void installListener() {
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListView.this.syncBtn();
            }
        });
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = ListView.this.list.getSelectedIndex();
                if (!ListView.this.onBeforeUp(idx)) {
                    return;
                }
                Object o = ListView.this.list.getSelectedValue();
                ListView.this.list.removeElementAt(idx);
                ListView.this.list.insertElement(o, idx - 1);
                ListView.this.list.setSelectedIndex(idx - 1);
                ListView.this.fireItemChangedEvent((Object)ListView.this);
            }
        });
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int idx = ListView.this.list.getSelectedIndex();
                if (!ListView.this.onBeforeDown(idx)) {
                    return;
                }
                Object o = ListView.this.list.getSelectedValue();
                ListView.this.list.removeElementAt(idx);
                ListView.this.list.insertElement(o, idx + 1);
                ListView.this.list.setSelectedIndex(idx + 1);
                ListView.this.fireItemChangedEvent((Object)ListView.this);
            }
        });
    }

    protected boolean onBeforeUp(int selectedIndex) {
        return selectedIndex > 0;
    }

    protected boolean onBeforeDown(int selectedIndex) {
        return selectedIndex < this.getList().getElementCount() - 1;
    }

    public void syncBtn() {
        if (!this.isEnableMoveItem()) {
            return;
        }
        if (this.list.getSelectedIndex() < 0 || this.list.getSelectedIndices().length > 1) {
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
            return;
        }
        if (this.list.getSelectedIndex() == 0) {
            this.btnUp.setEnabled(false);
        } else {
            this.btnUp.setEnabled(true);
        }
        if (this.list.getSelectedIndex() == this.list.getElementCount() - 1) {
            this.btnDown.setEnabled(false);
        } else {
            this.btnDown.setEnabled(true);
        }
    }

    private HashMap getMapExtBtn() {
        if (this.mapExtBtn == null) {
            this.mapExtBtn = new HashMap();
        }
        return this.mapExtBtn;
    }

    public KDWorkButton getButton(String key) {
        if (key == BUTTON_MOVE_UP) {
            return this.btnUp;
        }
        if (key == BUTTON_MOVE_DOWN) {
            return this.btnDown;
        }
        KDWorkButton btn = (KDWorkButton)this.getMapExtBtn().get(key);
        if (btn == null) {
            return new KDWorkButton();
        }
        return btn;
    }

    public void addButton(Action action, String key) {
        this.addButton(new KDWorkButton(action), key);
    }

    public void addButton(KDWorkButton newBtn, String key) {
        this.getMapExtBtn().put(key, newBtn);
        newBtn.setMinimumSize(new Dimension(26, 19));
        this.resetTitlePaneLayout(newBtn);
    }

    private void resetTitlePaneLayout(KDWorkButton newBtn) {
        Component[] comps = this.titlePane.getComponents();
        int c = this.titlePane.getComponentCount();
        this.titlePane.removeAll();
        TableLayout tl = TableLayout.splitCol((int)(c + 1));
        this.titlePane.setLayout((LayoutManager)tl);
        for (int i = 0; i < c; ++i) {
            tl.colStyle(i).setWidth(26);
            tl.colStyle(i).setMarginRight(3);
            this.titlePane.add(comps[i], (Object)tl.cell(i));
        }
        this.titlePane.add((Component)newBtn, (Object)tl.cell(c));
        tl.colStyle(0).setPriX(1);
        tl.colStyle(c).setMarginRight(2);
    }

    public KDList getList() {
        return this.list;
    }

    public void setTitle(String text) {
        this.labTitle.setText(text);
    }

    public String getTitle() {
        return this.labTitle.getText();
    }

    public void addItemChangedListener(ItemChangedListener l) {
        this.listenerList.add(ItemChangedListener.class, l);
    }

    public void removeItemChangedListener(ItemChangedListener l) {
        this.listenerList.remove(ItemChangedListener.class, l);
    }

    protected void fireItemChangedEvent(Object source) {
        Object[] listeners = this.listenerList.getListenerList();
        ItemChangedEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ItemChangedListener.class) continue;
            if (evt == null) {
                evt = new ItemChangedEvent(source);
            }
            ((ItemChangedListener)listeners[i + 1]).itemChanged(evt);
        }
    }

    public static class ItemChangedEvent
    extends EventObject {
        public ItemChangedEvent(Object source) {
            super(source);
        }
    }

    public static interface ItemChangedListener
    extends EventListener {
        public void itemChanged(ItemChangedEvent var1);
    }
}

