/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.swing.KDFrame;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

public abstract class TypicalFrame
extends KDFrame {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int CENTER = 4;
    public static final int TOP = 256;
    public static final int BOTTOM = 512;
    public static final int MIDDLE = 1024;
    protected boolean isAddControls = false;
    protected Action keyAction = new AbstractAction(){
        private static final long serialVersionUID = 3306681485053982327L;

        @Override
        public void actionPerformed(ActionEvent e) {
            char keyCode = e.getActionCommand().charAt(0);
            switch (keyCode) {
                case '\n': {
                    TypicalFrame.this.onOk();
                    break;
                }
                case '\u001b': {
                    TypicalFrame.this.onCancel();
                    break;
                }
                default: {
                    TypicalFrame.this.todoKeyAction(keyCode);
                }
            }
        }
    };
    protected ActionListener actionListner = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            TypicalFrame.this.todoActionPerformed(e);
        }
    };
    private int windowAlign = 1028;
    private int buttonAlign = 512;

    public TypicalFrame() {
        this.init();
    }

    protected void init() {
        this.setSize(640, 480);
        this.setDefaultCloseOperation(2);
        this.todoInit();
    }

    private void addControls() {
        TableLayout layout = TableLayout.split((int)1, (int)1);
        Container cp = super.getContentPane();
        cp.setLayout((LayoutManager)layout);
        this.registKeyAction(10, 0);
        this.registKeyAction(27, 0);
        this.todoAddControls(cp, layout.cell(0));
    }

    protected void registKeyAction(int keyCode, int modifiers) {
        JRootPane rootPane = this.getRootPane();
        rootPane.getActionMap().put(this.keyAction, this.keyAction);
        rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(keyCode, modifiers), this.keyAction);
    }

    protected abstract void todoInit();

    protected abstract void todoAddControls(Container var1, Cell var2);

    protected void todoActionPerformed(ActionEvent e) {
    }

    protected void todoKeyAction(int keyCode) {
    }

    protected void onOk() {
        this.dispose();
    }

    protected void onCancel() {
        this.dispose();
    }

    public int getButtonAlign() {
        return this.buttonAlign;
    }

    public void setButtonAlign(int barAlign) {
        this.buttonAlign = barAlign;
    }

    public int getWindowAlign() {
        return this.windowAlign;
    }

    public void setWindowAlign(int windowAlign) {
        this.windowAlign = windowAlign;
    }

    private void makeAlignBounds() {
        Rectangle rc = new Rectangle(this.getBounds());
        Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
        int x = 0;
        int y = 0;
        int width = sz.width;
        int height = sz.height;
        if ((this.windowAlign & 4) == 4) {
            rc.x = x + (width - rc.width) / 2;
            if (rc.x < 0) {
                rc.x = 0;
            }
        }
        if ((this.windowAlign & 0x400) == 1024) {
            rc.y = y + (height - rc.height) / 2;
            if (rc.y < 0) {
                rc.y = 0;
            }
        }
        this.setBounds(rc);
    }

    public void showFrame() {
        if (!this.isAddControls) {
            this.addControls();
            this.isAddControls = true;
        }
        this.makeAlignBounds();
        super.show();
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        TypicalFrame frm = new TypicalFrame(){
            private static final long serialVersionUID = -6601729775423224586L;

            @Override
            protected void todoInit() {
            }

            @Override
            protected void todoAddControls(Container parent, Cell thisCell) {
            }

            @Override
            protected void todoActionPerformed(ActionEvent e) {
            }

            @Override
            protected void todoKeyAction(int keyCode) {
            }
        };
        frm.setSize(500, 200);
        frm.showFrame();
    }
}

