/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.bosmetaselector;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

abstract class AbstractBosMetaSelector {
    private KDTreeView _treeView;

    AbstractBosMetaSelector() {
    }

    public KDPromptSelector createF7Selector(JComponent parentCtrl) {
        return new F7Selector(parentCtrl, this);
    }

    public MetaDataBriefInfo show(JComponent owner) {
        KDTree tree = this.getTreeView().getTree();
        CustomDialog dialog = this.createDialog(owner);
        this.initDialog(dialog);
        if (dialog.showDialog()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)tree.getSelectionPath().getLastPathComponent();
            MetaDataBriefInfo data = (MetaDataBriefInfo)node.getUserObject();
            return data;
        }
        return null;
    }

    protected KDTreeView getTreeView() {
        if (this._treeView == null) {
            this.createTreeView();
        }
        return this._treeView;
    }

    protected void createTreeView() {
        KDTree tree = new KDTree((ITreeNode)this.createTreeRoot(), false);
        tree.getSelectionModel().setSelectionMode(1);
        this._treeView = new KDTreeView(tree, false);
        this._treeView.setMinimumSize(new Dimension(100, 120));
    }

    protected abstract DefaultKingdeeTreeNode createTreeRoot();

    protected abstract void initDialog(TypicalDialog var1);

    protected abstract Object wrapperReturnValueForF7(MetaDataBriefInfo var1);

    private CustomDialog createDialog(Component parentCtrl) {
        Window owner = SwingUtilities.getWindowAncestor(parentCtrl);
        if (owner instanceof Dialog) {
            return new CustomDialog((Dialog)owner);
        }
        if (owner instanceof Frame) {
            return new CustomDialog((Frame)owner);
        }
        return new CustomDialog();
    }

    private static class F7Selector
    implements KDPromptSelector {
        private JComponent parentCtrl;
        private AbstractBosMetaSelector sourceSelector;
        private MetaDataBriefInfo returnValue;

        public F7Selector(JComponent owner, AbstractBosMetaSelector sourceSelector) {
            this.parentCtrl = owner;
            this.sourceSelector = sourceSelector;
        }

        public void show() {
            this.returnValue = this.sourceSelector.show(this.parentCtrl);
        }

        public boolean isCanceled() {
            return this.returnValue == null;
        }

        public Object getData() {
            return this.sourceSelector.wrapperReturnValueForF7(this.returnValue);
        }
    }

    private class CustomDialog
    extends TypicalDialog {
        public CustomDialog() {
        }

        public CustomDialog(Dialog owner) {
            super(owner);
        }

        public CustomDialog(Frame owner) {
            super(owner);
        }

        @Override
        protected void todoInit() {
            this.setSize(320, 460);
            this.btnOk.setEnabled(false);
        }

        @Override
        protected void todoAddControls(Container parent, Cell thisCell) {
            parent.add((Component)AbstractBosMetaSelector.this._treeView, thisCell);
            AbstractBosMetaSelector.this._treeView.getTree().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath path = e.getNewLeadSelectionPath();
                    if (path != null) {
                        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                        CustomDialog.this.btnOk.setEnabled(node.isLeaf());
                    } else {
                        CustomDialog.this.btnOk.setEnabled(false);
                    }
                }
            });
        }

        @Override
        public boolean verify() {
            return super.verify();
        }
    }
}

