/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.console;

import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.ui.console.AbstractConsoleAction;
import com.kingdee.bos.ctrl.common.ui.console.ConsolePane;
import com.kingdee.bos.ctrl.common.ui.console.IActionBuildExtEvent;
import com.kingdee.bos.ctrl.common.ui.console.content.IBranchContent;
import com.kingdee.bos.ctrl.common.ui.console.content.IConsoleContent;
import com.kingdee.bos.ctrl.common.ui.console.content.ILeafContent;
import com.kingdee.bos.ctrl.common.ui.console.menuelement.CMenu;
import com.kingdee.bos.ctrl.common.ui.console.menuelement.CMenuItem;
import com.kingdee.bos.ctrl.common.ui.console.menuelement.CSeparator;
import com.kingdee.bos.ctrl.common.ui.console.menuelement.CWorkButton;
import com.kingdee.bos.ctrl.common.ui.console.menuelement.IMenuElement;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class ConsoleConfigReader {
    private static final Logger log = LogUtil.getLogger(ConsoleConfigReader.class);
    private ConsolePane console = new ConsolePane();
    private String iconPackage;
    private HashMap mapAssNodes;
    private HashMap mapMenuNode;
    private IActionBuildExtEvent actionBuildExtEvent;

    public void biuld(Element docRoot) {
        Element treeRoot = docRoot.getChild("TreeRoot");
        this.mapAssNodes = this.cacheNodes(docRoot.getChild("Associate"), "Node");
        this.bindAssociate(this.console.getSystemContent(), docRoot.getChild("Associate").getChild("Common"));
        this.iconPackage = treeRoot.getAttributeValue("iconpackage");
        boolean isShow = "true".equalsIgnoreCase(treeRoot.getAttributeValue("isshow"));
        this.console.setRootNodeShow(isShow);
        this.addBranch(null, treeRoot);
        this.console.validateConsoleTree();
    }

    private HashMap cacheNodes(Element parentNode, String childTag) {
        HashMap<String, Element> map = new HashMap<String, Element>();
        if (parentNode != null) {
            List ass = parentNode.getChildren(childTag);
            for (Element node : ass) {
                map.put(node.getAttributeValue("id"), node);
            }
        }
        return map;
    }

    private void addBranch(DefaultKingdeeTreeNode parent, Element branchNode) {
        String text = branchNode.getAttributeValue("text");
        String icon = branchNode.getAttributeValue("icon");
        String assId = branchNode.getAttributeValue("associate");
        IBranchContent bc = this.console.createBranchContentInstance();
        this.bindAssociate(bc, (Element)this.mapAssNodes.get(assId));
        DefaultKingdeeTreeNode treeNode = parent == null ? this.console.setRootNode(bc, text, this.getIcon(icon)) : this.console.addBranch(parent, bc, text, this.getIcon(icon));
        List lstChild = branchNode.getChildren();
        for (Element node : lstChild) {
            if ("Branch".equalsIgnoreCase(node.getName())) {
                this.addBranch(treeNode, node);
                continue;
            }
            if (!"Leaf".equalsIgnoreCase(node.getName())) continue;
            this.addFunction(treeNode, node);
        }
    }

    private void addFunction(DefaultKingdeeTreeNode parent, Element functionNode) {
        String text = functionNode.getAttributeValue("text");
        String icon = functionNode.getAttributeValue("icon");
        String assId = functionNode.getAttributeValue("associate");
        String funcClass = functionNode.getAttributeValue("classname");
        ILeafContent func = (ILeafContent)this.createClassByName(funcClass);
        DefaultKingdeeTreeNode treeNode = this.console.addLeaf(parent, func, text, this.getIcon(icon));
        this.bindAssociate((ILeafContent)treeNode.getUserObject(), (Element)this.mapAssNodes.get(assId));
    }

    private void bindAssociate(IConsoleContent obj, Element assNode) {
        if (assNode == null) {
            return;
        }
        HashMap mapAction = this.cacheNodes(assNode.getChild("Actions"), "Action");
        obj.setMenuBarList(this.createMenuList(assNode.getChild("Menus"), mapAction, obj));
        obj.setToolBarList(this.createToolbarList(assNode.getChild("Toolbar"), mapAction, obj));
        obj.setPopMenuList(this.createPopMenuList(assNode.getChild("PopMenu"), mapAction, obj));
    }

    private List createMenuList(Element menusNode, HashMap mapAction, IConsoleContent content) {
        ArrayList<CMenu> list = new ArrayList<CMenu>();
        if (menusNode != null) {
            this.mapMenuNode = this.cacheNodes(menusNode, "Menu");
            List lstMenuNodes = menusNode.getChildren("Menu");
            Iterator it = lstMenuNodes.iterator();
            while (it.hasNext()) {
                list.add(this.createMenu((Element)it.next(), mapAction, content));
            }
        }
        return list;
    }

    private List createToolbarList(Element toolbarNode, HashMap mapAction, IConsoleContent content) {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (toolbarNode != null) {
            List lstChild = toolbarNode.getChildren();
            Iterator it = lstChild.iterator();
            while (it.hasNext()) {
                JComponent item = this.createItem((Element)it.next(), toolbarNode, mapAction, content);
                if (item == null) continue;
                list.add(item);
            }
        }
        return list;
    }

    private List createPopMenuList(Element popNode, HashMap mapAction, IConsoleContent content) {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        if (popNode != null) {
            Element node = null;
            String sync = popNode.getAttributeValue("syncmenu");
            if (!StringUtil.isEmptyString((String)sync)) {
                node = (Element)this.mapMenuNode.get(sync);
            }
            if (node == null) {
                node = popNode;
            }
            List lstChild = node.getChildren();
            Iterator it = lstChild.iterator();
            while (it.hasNext()) {
                JComponent item = this.createItem((Element)it.next(), node, mapAction, content);
                if (item == null) continue;
                list.add(item);
            }
        }
        return list;
    }

    private CMenu createMenu(Element menuNode, HashMap mapAction, IConsoleContent content) {
        CMenu menu = new CMenu();
        menu.setText(menuNode.getAttributeValue("text"));
        menu.setMnemonic(this.getMnemonicChar(menuNode.getAttributeValue("mnemonic")));
        menu.setInsertIndex(this.getInt(menuNode.getAttributeValue("index")));
        List lstChild = menuNode.getChildren();
        Iterator it = lstChild.iterator();
        while (it.hasNext()) {
            JComponent item = this.createItem((Element)it.next(), menuNode, mapAction, content);
            if (item == null) continue;
            menu.add(item);
        }
        return menu;
    }

    private JComponent createItem(Element itemNode, Element parentNode, HashMap mapAction, IConsoleContent content) {
        IMenuElement item = null;
        int idx = this.getInt(itemNode.getAttributeValue("index"));
        if ("Separator".equalsIgnoreCase(itemNode.getName())) {
            item = "Toolbar".equalsIgnoreCase(parentNode.getName()) ? new CSeparator(1) : new CSeparator(0);
            item.setInsertIndex(idx);
            return item;
        }
        String actionId = itemNode.getAttributeValue("action");
        String text = null;
        AbstractAction action = null;
        String mnStr = null;
        Element actionNode = (Element)mapAction.get(actionId);
        if (actionNode != null) {
            text = actionNode.getAttributeValue("text");
            mnStr = actionNode.getAttributeValue("mnemonic");
            String classname = actionNode.getAttributeValue("classname");
            Object actionObj = this.createClassByName(classname);
            if (actionObj instanceof AbstractConsoleAction) {
                action = (AbstractConsoleAction)actionObj;
                action.setUI(content);
                if (this.actionBuildExtEvent != null) {
                    this.actionBuildExtEvent.doExt((AbstractConsoleAction)action);
                }
            } else if (actionObj instanceof AbstractAction) {
                action = (AbstractAction)actionObj;
            }
        }
        if (action == null) {
            String parentText;
            StringBuffer sb = new StringBuffer("\u914d\u7f6e\u6587\u4ef6\u4e2d\u6ca1\u6709\u5b9a\u4e49Action: ");
            sb.append(actionId);
            sb.append("\uff0c\u6216\u521b\u5efa\u4e0d\u5230\u5b9e\u4f8b\u3002");
            sb.append("\u6765\u81ea\u8282\u70b9:");
            sb.append(parentNode.getName());
            String parentId = parentNode.getAttributeValue("id");
            if (parentId != null) {
                sb.append(" id=");
                sb.append(parentId);
            }
            if ((parentText = parentNode.getAttributeValue("text")) != null) {
                sb.append(" text=");
                sb.append(parentText);
            }
            log.error((Object)sb.toString());
            return null;
        }
        if ("MenuItem".equalsIgnoreCase(itemNode.getName())) {
            item = new CMenuItem(action);
            if (!StringUtil.isEmptyString((String)text)) {
                ((CMenuItem)item).setText(text);
            }
            ((CMenuItem)item).setMnemonic(this.getMnemonicChar(mnStr));
            ((CMenuItem)item).setInsertIndex(idx);
        } else if ("Button".equalsIgnoreCase(itemNode.getName())) {
            item = new CWorkButton(action);
            ((CWorkButton)item).setToolTipText(text);
            ((CWorkButton)item).setInsertIndex(idx);
        } else if ("Menu".equalsIgnoreCase(itemNode.getName())) {
            item = this.createMenu(itemNode, mapAction, content);
        }
        return item;
    }

    private int getInt(String str) {
        if (!StringUtil.isEmptyString((String)str)) {
            return Integer.parseInt(str);
        }
        return 0;
    }

    private char getMnemonicChar(String mnStr) {
        if (mnStr != null) {
            return mnStr.length() > 0 ? mnStr.charAt(0) : (char)' ';
        }
        return ' ';
    }

    private Object createClassByName(String className) {
        if (StringUtil.isEmptyString((String)className)) {
            return null;
        }
        try {
            return Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private ImageIcon getIcon(String name) {
        if (StringUtil.isEmptyString((String)name)) {
            return null;
        }
        return ResourceManager.getIcon(this.iconPackage, name);
    }

    public ConsolePane getConsole() {
        return this.console;
    }

    public void setActionBuildExtEvent(IActionBuildExtEvent ext) {
        this.actionBuildExtEvent = ext;
    }
}

