/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.editor.styled;

import com.kingdee.bos.ctrl.common.ui.editor.DefaultEditorStyleModel;
import com.kingdee.bos.ctrl.common.ui.editor.EditorStyleModel;
import com.kingdee.bos.ctrl.common.ui.editor.Lexer;
import com.kingdee.bos.ctrl.common.ui.editor.MatchedToken;
import com.kingdee.bos.ctrl.common.ui.editor.StyledEditor;
import java.awt.Color;

public class HTMLStyledEditor
extends StyledEditor {
    public HTMLStyledEditor() {
        this(new HTMLStyledModel());
    }

    public HTMLStyledEditor(EditorStyleModel cs) {
        super(cs);
    }

    static class HTMLStyledModel
    extends DefaultEditorStyleModel {
        public HTMLStyledModel() {
            this.initStyle();
        }

        @Override
        public void beforeRun(Lexer lex) {
            lex.setSpecialChar("<>/\"'=");
        }

        private void initStyle() {
            this.addStyle(new MatchedToken(){

                @Override
                public boolean match(String token) {
                    return token.matches("'.*'") || token.matches("\".*\"");
                }
            }, this.createSimpleAttributeSet(new Color(0xFF00FF)));
            String keys = "!DOCTYPE,A,ABBR,ACRONYM,ADDRESS,APPLET,AREA,B,BASE,BASEFONT,BGSOUND,BDO,BIG,BLINK,BLOCKQUOTE,BODY,BR,BUTTON,CAPTION,CENTER,CITE,CODE,COL,COLGROUP,COMMENT,DD,DEL,DFN,DIR,DIV,DL,DT,EM,EMBED,FIELDSET,FONT,FORM,FRAME,FRAMESET,H,H1,H2,H3,H4,H5,H6,HEAD,HR,HTA:APPLICATION,HTML,I,IFRAME,IMG,INPUT,INS,ISINDEX,jsp:declaration,jsp:directive,jsp:expression,jsp:fallback,jsp:forward,jsp:getProperty,jsp:include,jsp:param,jsp:params,jsp:plugin,jsp:root,jsp:scriptlet,jsp:setProperty,jsp:useBean,KBD,LABEL,LEGEND,LI,LINK,LISTING,MAP,MARQUEE,MENU,META,MULTICOL,NEXTID,NOBR,NOFRAMES,NOSCRIPT,OBJECT,OL,OPTGROUP,OPTION,P,PARAM,PLAINTEXT,PRE,Q,S,SAMP,SCRIPT,SELECT,SERVER,SMALL,SOUND,SPACER,SPAN,STRIKE,STRONG,STYLE,SUB,SUP,TABLE,TBODY,TD,TEXTAREA,TEXTFLOW,TFOOT,TH,THEAD,TITLE,TR,TT,U,UL,VAR,WBR,XMP";
            this.addStyle(keys.split(","), this.createSimpleAttributeSet(Color.BLUE));
            keys = "abbr,accept-charset,accept,accesskey,action,align,alink,alt,applicationname,archive,autoFlush,axis,background,behavior,bgcolor,bgproperties,border,bordercolor,bordercolordark,bordercolorlight,borderstyle,buffer,caption,cellpadding,cellspacing,char,charoff,charset,checked,cite,class,classid,clear,code,codebase,codetype,color,cols,colspan,compact,content,contentType,coords,data,datetime,declare,defer,dir,direction,disabled,dynsrc,encoding,enctype,errorPage,extends,face,file,flush,for,frame,frameborder,framespacing,gutter,headers,height,href,hreflang,hspace,http-equiv,icon,id,import,info,isErrorPage,ismap,isThreadSafe,label,language,leftmargin,link,longdesc,loop,lowsrc,marginheight,marginwidth,maximizebutton,maxlength,media,method,methods,minimizebutton,multiple,name,nohref,noresize,noshade,nowrap,object,onabort,onblur,onchange,onclick,ondblclick,onerror,onfocus,onkeydown,onkeypress,onkeyup,onload,onmousedown,onmousemove,onmouseout,onmouseover,onmouseup,onreset,onselect,onsubmit,onunload,page,param,profile,prompt,property,readonly,rel,rev,rows,rowspan,rules,runat,scheme,scope,scrollamount,scrolldelay,scrolling,selected,session,shape,showintaskbar,singleinstance,size,span,src,standby,start,style,summary,sysmenu,tabindex,target,text,title,topmargin,type,urn,usemap,valign,value,valuetype,version,vlink,vrml,vspace,width,windowstate,wrap,xmlns:jsp";
            this.addStyle(keys.split(","), this.createSimpleAttributeSet(Color.RED));
            keys = "&aacute;,&agrave;,&acirc;,&amp;,&atilde;,&aring;,&auml;,&aelig;,&ccedil;,&copy;,&eacute;,&egrave;,&ecirc;,&euml;,&iacute;,&igrave;,&icirc;,&iuml;,&eth;,&gt;,&lt;,&nbsp;,&ntilde;,&oacute;,&ograve;,&ocirc;,&otilde;,&ouml;,&oslash;,&quot;,&reg;,&szlig;,&uacute;,&ugrave;,&ucirc;,&uuml;,&yacute;,&thorn;,&trade;,&yuml;";
            this.addStyle(keys.split(","), this.createSimpleAttributeSet(new Color(39372)));
            this.addStyle("<,>,/".split(","), this.createSimpleAttributeSet(Color.BLUE));
            keys = "~`!@#$%^&*()-=_+[]{};':\",./<>?\\|";
            this.addStyle(keys.split(""), this.createSimpleAttributeSet(Color.GRAY));
        }
    }
}

