/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render.splitrectangle;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TableSplitRectInfo;
import com.kingdee.bos.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jdom2.Content;
import org.jdom2.Element;

public class TableSplitRectInfoXml {
    public static final String DIAGONALHEADER = "DiagonalHeader";
    static final String DH_COL = "Col";
    static final String DH_ROW2 = "Row2";
    static final String DH_COL2 = "Col2";
    static final String ROWOFFERS = "RowOffers";
    static final String COLOFFERS = "ColOffers";
    static final String XOFFERS = "xOffers";
    static final String YOFFERS = "yOffers";
    static final String TRIANGLE = "Triangle";
    static final String LEAN = "Lean";
    static final String ZOOM = "Zoom";
    static final String DRAWBACK = "DrawBack";
    static final String POSITION = "Position";
    static final String LINESTYLE = "LineStyle";
    static final String WEIGHT = "Weight";
    static final String ROW = "Row";
    static final String STYLEID = "StyleID";
    static final String INDEX = "Index";
    static final String Data_String = "String";
    static final String TRUEVALUE = "True";
    static final String FALSEVALUE = "False";

    public static AbstractTableSplitRectInfo fromXml(Element dhe, Map styles) {
        Integer position = Integer.valueOf(dhe.getAttributeValue(POSITION));
        int row = Integer.parseInt(dhe.getAttributeValue(ROW));
        int col = Integer.parseInt(dhe.getAttributeValue(DH_COL));
        int row2 = Integer.parseInt(dhe.getAttributeValue(DH_ROW2));
        int col2 = Integer.parseInt(dhe.getAttributeValue(DH_COL2));
        int[] rowOffers = new int[]{};
        int[] colOffers = new int[]{};
        if (dhe.getAttributeValue(ROWOFFERS) != null) {
            rowOffers = TableSplitRectInfoXml.arrayToInt(dhe.getAttributeValue(ROWOFFERS));
        }
        if (dhe.getAttributeValue(COLOFFERS) != null) {
            colOffers = TableSplitRectInfoXml.arrayToInt(dhe.getAttributeValue(COLOFFERS));
        }
        TableSplitRectInfo info = new TableSplitRectInfo(row, col, row2, col2, position, rowOffers, colOffers);
        double[] xOffers = new double[]{};
        double[] yOffers = new double[]{};
        if (dhe.getAttributeValue(XOFFERS) != null) {
            xOffers = TableSplitRectInfoXml.arrayToDouble(dhe.getAttributeValue(XOFFERS));
        }
        if (dhe.getAttributeValue(YOFFERS) != null) {
            yOffers = TableSplitRectInfoXml.arrayToDouble(dhe.getAttributeValue(YOFFERS));
        }
        info.setXSplitOffs(xOffers);
        info.setYSplitOffs(yOffers);
        List children = dhe.getChildren(TRIANGLE);
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element triangle = (Element)children.get(i);
            TableSplitRectInfoXml.fromTriangle(info, triangle, styles);
        }
        return info;
    }

    private static double[] arrayToDouble(String attributeValue) {
        StringTokenizer strToken = new StringTokenizer(attributeValue, ",");
        double[] arrayInts = new double[strToken.countTokens()];
        int i = 0;
        while (strToken.hasMoreTokens()) {
            arrayInts[i] = Double.parseDouble(strToken.nextToken());
            ++i;
        }
        return arrayInts;
    }

    private static int[] arrayToInt(String attributeValue) {
        StringTokenizer strToken = new StringTokenizer(attributeValue, ",");
        int[] arrayInts = new int[strToken.countTokens()];
        int i = 0;
        while (strToken.hasMoreTokens()) {
            arrayInts[i] = Integer.parseInt(strToken.nextToken());
            ++i;
        }
        return arrayInts;
    }

    public static Element toXml(AbstractTableSplitRectInfo dh, List styles) {
        double[] yOffs;
        double[] xOffs;
        int[] colOffs;
        Element dhe = new Element(DIAGONALHEADER);
        dhe.setAttribute(POSITION, dh.getPosition().toString());
        dhe.setAttribute(ROW, String.valueOf(dh.getRow()));
        dhe.setAttribute(DH_COL, String.valueOf(dh.getCol()));
        dhe.setAttribute(DH_ROW2, String.valueOf(dh.getRow2()));
        dhe.setAttribute(DH_COL2, String.valueOf(dh.getCol2()));
        int[] rowOffs = dh.getRowOffs();
        if (rowOffs != null && rowOffs.length > 0) {
            dhe.setAttribute(ROWOFFERS, StringUtil.array2String((int[])rowOffs, (String)","));
        }
        if ((colOffs = dh.getColOffs()) != null && colOffs.length > 0) {
            dhe.setAttribute(COLOFFERS, StringUtil.array2String((int[])colOffs, (String)","));
        }
        if ((xOffs = dh.getXSplitOffs()) != null && xOffs.length > 0) {
            dhe.setAttribute(XOFFERS, StringUtil.array2String((double[])xOffs, (String)","));
        }
        if ((yOffs = dh.getYSplitOffs()) != null && yOffs.length > 0) {
            dhe.setAttribute(YOFFERS, StringUtil.array2String((double[])yOffs, (String)","));
        }
        int size = dh.size();
        for (int i = 0; i < size; ++i) {
            TableSplitRectInfoXml.buildTraingleInfoElement(dh, i, dhe, styles);
        }
        return dhe;
    }

    private static void fromTriangle(TableSplitRectInfo info, Element triangle, Map styles) {
        int index = Integer.parseInt(triangle.getAttributeValue(INDEX));
        TriangleInfo tri = info.getTriangleInfo(index);
        String styleID = triangle.getAttributeValue(STYLEID);
        if (styleID != null) {
            tri.setStyle((Style)styles.get(styleID));
        }
        tri.setText(triangle.getAttributeValue(Data_String));
        tri.setLean(triangle.getAttributeValue(LEAN).equals(TRUEVALUE));
        tri.setAutoZoom(triangle.getAttributeValue(ZOOM).equals(TRUEVALUE));
        tri.setDrawBackground(triangle.getAttributeValue(DRAWBACK).equals(TRUEVALUE));
    }

    private static void buildTraingleInfoElement(AbstractTableSplitRectInfo dh, int index, Element pElement, List styles) {
        Element te = new Element(TRIANGLE, pElement.getNamespace());
        TriangleInfo ti = dh.getTriangleInfo(index);
        Style ssa = ti.getStyle();
        if (ssa != null && !ssa.isEmpty()) {
            te.setAttribute(STYLEID, "" + ssa.getUID());
            styles.add(ssa);
        }
        te.setAttribute(INDEX, String.valueOf(index));
        te.setAttribute(Data_String, ti.getText());
        te.setAttribute(LEAN, ti.isLean() ? TRUEVALUE : FALSEVALUE);
        te.setAttribute(ZOOM, ti.isAutoZoom() ? TRUEVALUE : FALSEVALUE);
        te.setAttribute(DRAWBACK, ti.isDrawBackground() ? TRUEVALUE : FALSEVALUE);
        pElement.addContent((Content)te);
    }
}

