/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.webmine;

import com.kingdee.bos.ctrl.res.tool.webmine.HTMLStyledEditor;
import com.kingdee.bos.ctrl.res.tool.webmine.PageConnector;
import com.kingdee.bos.ctrl.res.tool.webmine.VarPatternUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;

public class PatternGatherFrame
extends JFrame {
    JTextField jtUrl = new JTextField();
    JButton jbUrl = new JButton("Get");
    JButton jbPattern = new JButton("Pattern");
    JButton jbFilt = new JButton("Filt");
    HTMLStyledEditor jtSrc = new HTMLStyledEditor();
    HTMLStyledEditor jtUserPattern = new HTMLStyledEditor();
    HTMLStyledEditor jtOutPattern = new HTMLStyledEditor();
    HTMLStyledEditor jtOut = new HTMLStyledEditor();

    public PatternGatherFrame() {
        this.initUI();
        this.onLoad();
        this.setBounds(100, 100, 800, 600);
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void initUI() {
        this.setTitle("Gather");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jp = new JPanel();
        jp.add(new JLabel("URL:"));
        this.jtUrl.setPreferredSize(new Dimension(400, 26));
        jp.add(this.jtUrl);
        jp.add(this.jbUrl);
        this.getContentPane().add((Component)jp, "North");
        JSplitPane jsp = new JSplitPane(1);
        jsp.setDividerLocation(400);
        jsp.add((Component)new JScrollPane((Component)((Object)this.jtSrc)), "left");
        jsp.add((Component)new JScrollPane((Component)((Object)this.jtUserPattern)), "right");
        JSplitPane jsp2 = new JSplitPane(1);
        jsp2.setDividerLocation(400);
        jsp2.add((Component)new JScrollPane((Component)((Object)this.jtOutPattern)), "left");
        jsp2.add((Component)new JScrollPane((Component)((Object)this.jtOut)), "right");
        JSplitPane rootJsp = new JSplitPane(0);
        rootJsp.setDividerLocation(300);
        rootJsp.add((Component)jsp, "top");
        jp = new JPanel();
        jp.setLayout(new BorderLayout());
        rootJsp.add((Component)jp, "bottom");
        jp.add((Component)this.jbPattern, "North");
        jp.add((Component)this.jbFilt, "South");
        jp.add((Component)jsp2, "Center");
        this.getContentPane().add((Component)rootJsp, "Center");
        this.jbUrl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternGatherFrame.this.requestURLContent(PatternGatherFrame.this.jtUrl.getText().trim());
            }
        });
        this.jbFilt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternGatherFrame.this.filtContent(PatternGatherFrame.this.jtUserPattern.getText());
            }
        });
        this.jbPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternGatherFrame.this.patternContent(PatternGatherFrame.this.jtSrc.getText(), PatternGatherFrame.this.jtUserPattern.getText());
            }
        });
    }

    private void onLoad() {
        this.jtUrl.setText("http://www.google.cn/search?hl=zh-CN&newwindow=1&q=nop+%E6%B1%87%E7%BC%96&btnG=%E6%90%9C%E7%B4%A2&meta=lr%3Dlang_zh-CN%7Clang_zh-TW");
    }

    private void requestURLContent(String url) {
        try {
            StringBuffer sb = PageConnector.open(url);
            this.jtSrc.setText(sb.toString());
            this.jtUserPattern.setText(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void filtContent(String content) {
    }

    private void patternContent(String content, String userPattern) {
        VarPatternUtil vp = new VarPatternUtil(userPattern);
        String pp = vp.transPattern();
        this.jtOutPattern.setText(pp);
        this.jtOutPattern.setCaretPosition(0);
        List valueList = vp.applyPattern(content);
        StringBuffer sb = new StringBuffer();
        int n = valueList.size();
        for (int i = 0; i < n; ++i) {
            sb.append(vp.getVarNameList().get(i)).append("=").append(valueList.get(i)).append("\r\n");
        }
        this.jtOut.setText(sb.toString());
        this.jtOut.setCaretPosition(0);
    }

    public static void main(String[] args) {
        new PatternGatherFrame();
    }
}

