/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.res.tool.webmine.zip;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MaxMatch {
    private int nextMatchedPos(char[] chs, char ch, int from) {
        for (int i = from; i < chs.length; ++i) {
            if (chs[i] != ch) continue;
            return i;
        }
        return -1;
    }

    private boolean isMatch(char[] chs, int from, char[] matched) {
        int m = matched.length;
        int n = 0;
        int i = from;
        for (int k = 0; i < chs.length && k < m; ++i, ++k) {
            if (chs[i] != matched[k]) {
                return false;
            }
            ++n;
        }
        return m == n;
    }

    private char[] matchMaxChars(char[] chs1, int from1, char[] chs2, int from2) {
        char ch;
        StringBuffer s = new StringBuffer();
        int i = from1;
        for (int j = from2; i < chs1.length && j < chs2.length && (ch = chs1[i]) == chs2[j]; ++i, ++j) {
            s.append(ch);
        }
        return s.toString().toCharArray();
    }

    private void doMatch(String s1, String s2, int from, Stat s, int minMatchLen) {
        char[] chs1 = s1.toCharArray();
        char[] chs2 = s2.toCharArray();
        int len1 = chs1.length;
        int len2 = chs2.length;
        for (int jj = 0; jj < len2 - minMatchLen; ++jj) {
            for (int i = from; i < len1 - from - minMatchLen; ++i) {
                char ch1 = chs1[i];
                int k = this.nextMatchedPos(chs2, ch1, jj);
                if (k == -1) continue;
                char[] matched = this.matchMaxChars(chs1, i, chs2, k);
                for (int mi = minMatchLen; mi <= matched.length; ++mi) {
                    int kk = k;
                    char[] matchedBuf = new char[mi];
                    System.arraycopy(matched, 0, matchedBuf, 0, mi);
                    int matchedLen = matchedBuf.length;
                    do {
                        s.gatherToken(s1, i, s2, kk, matchedBuf);
                        kk += matchedLen;
                        kk = this.nextMatchedPos(chs2, ch1, kk);
                        if (mi != matched.length) continue;
                        k = kk;
                    } while (kk != -1 && this.isMatch(chs2, kk, matchedBuf));
                }
            }
        }
    }

    private Stat match(String s1, String s2, int minMatchLen) {
        int i;
        Stat s = new Stat();
        int n = s1.length() - minMatchLen;
        for (i = 0; i < n; ++i) {
            this.doMatch(s1, s2, i, s, minMatchLen);
        }
        n = s2.length() - minMatchLen;
        for (i = 0; i < n; ++i) {
            this.doMatch(s2, s1, i, s, minMatchLen);
        }
        return s;
    }

    public static void main(String[] args) throws Exception {
        String s1 = "aab2bcacaa";
        String s2 = "aabbcc";
        s1 = "A trace of length L is a sequence of L match points.";
        s2 = "The sequence of match points visited in traversing.";
        s1 = "http://www.sinzy.net/blog/CategoryList.asp?ID=8&CateID=89";
        s2 = "http://www.chinabi.net/blog/more.asp?name=duzhaoyi2000&id=389";
        MaxMatch mm = new MaxMatch();
        Stat s = mm.match(s1, s2, 1);
        s.dump();
    }

    class Stat {
        Map map = new TreeMap();

        Stat() {
        }

        public List getMaxLengthList() {
            ArrayList<String> list = new ArrayList<String>();
            int maxLen = -1;
            for (String key : this.map.keySet()) {
                maxLen = key.length() > maxLen ? key.length() : maxLen;
            }
            if (maxLen != -1) {
                for (String key : this.map.keySet()) {
                    if (key.length() != maxLen) continue;
                    list.add(key);
                }
            }
            return list;
        }

        public void dump() {
            Item item;
            int maxLen = -1;
            for (String key : this.map.keySet()) {
                maxLen = key.length() > maxLen ? key.length() : maxLen;
                item = (Item)this.map.get(key);
                System.out.println("\u5173\u952e\u5b57[" + key.length() + "]\uff1a" + key + "\t\u5339\u914d\u6b21\u6570=" + item.matchCount);
            }
            if (maxLen == -1) {
                System.out.println("\u65e0\u5339\u914d,\u8bf7\u914d\u7f6e\u5339\u914d\u957f\u5ea6.");
            } else {
                System.out.println("----------------------------------");
                for (String key : this.map.keySet()) {
                    if (key.length() != maxLen) continue;
                    item = (Item)this.map.get(key);
                    System.out.println("\u6700\u5927\u5339\u914d[" + key.length() + "]=" + key + "\t\u5339\u914d\u6b21\u6570=" + item.matchCount);
                }
            }
        }

        public void gatherToken(String s1, int from1, String s2, int from2, char[] matched) {
            String key = new String(matched);
            Item item = (Item)this.map.get(key);
            if (item == null) {
                item = new Item();
                this.map.put(key, item);
            }
            item.addPos(s1, s2, from1, from2);
        }

        class Item {
            int matchCount = 0;
            List pos = new ArrayList();

            Item() {
            }

            void addPos(String s1, String s2, int from1, int from2) {
                Pos p = new Pos(s1, from1, s2, from2);
                if (!this.pos.contains(p)) {
                    ++this.matchCount;
                    this.pos.add(p);
                }
            }
        }

        class Pos {
            String s1;
            String s2;
            int from1;
            int from2;

            Pos(String s1, int from1, String s2, int from2) {
                this.s1 = s1;
                this.s2 = s2;
                this.from1 = from1;
                this.from2 = from2;
            }

            public boolean equals(Object obj) {
                Pos p = (Pos)obj;
                return p.from1 == this.from1 && p.from2 == this.from2 && p.s1.equals(this.s1) && p.s2.equals(this.s2);
            }
        }
    }
}

