/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.connection.ui;

import com.kingdee.bos.ctrl.bizshare.ConnectException;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.framework.connection.BosConnection;
import com.kingdee.bos.ctrl.data.framework.connection.ui.UiResource;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.KDPasswordField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BosConnPanel
extends JPanel
implements ActionListener {
    private KDTextField txtServerUrl = new KDTextField("tcp://localhost");
    private KDTextField txtSolution = new KDTextField("kdrsbos");
    private KDTextField txtAis = new KDTextField("kdrsbos");
    private KDTextField txtUser = new KDTextField("user");
    private KDPasswordField psw = new KDPasswordField("password");
    private KDButton btnTestConn = new KDButton(UiResource.getString("res_2"));
    private KDComboBox cbxLocale = new KDComboBox();
    public static final Locale[] locales = new Locale[]{Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE};

    private int fromLocale(Locale locale) {
        for (int i = 0; i < locales.length; ++i) {
            if (!locales[i].equals(locale)) continue;
            return i;
        }
        return 0;
    }

    private Locale toLocale(int index) {
        if (index >= 0 && index < locales.length) {
            return locales[index];
        }
        assert (false);
        return Locale.ENGLISH;
    }

    public BosConnPanel() {
        for (int i = 0; i < locales.length; ++i) {
            this.cbxLocale.insertItemAt((Object)locales[i].getDisplayName(), i);
        }
        this.cbxLocale.setSelectedIndex(this.fromLocale(Locale.getDefault()));
        TableLayout layout = TableLayout.splitRow((int)8);
        this.setLayout((LayoutManager)layout);
        layout.defaultStyle().setMarginBottom(3);
        layout.rowStyle(7).setPriY(1);
        layout.cell(6).style().setAlignmentX((short)2);
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.txtServerUrl, (String)UiResource.getString("res_3"), (int)80), layout.cell(0));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.txtSolution, (String)UiResource.getString("res_4"), (int)80), layout.cell(1));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.txtAis, (String)UiResource.getString("res_5"), (int)80), layout.cell(2));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.txtUser, (String)UiResource.getString("res_6"), (int)80), layout.cell(3));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.psw, (String)UiResource.getString("res_7"), (int)80), layout.cell(4));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.cbxLocale, (String)UiResource.getString("res_8"), (int)80), layout.cell(5));
        this.add((Component)this.btnTestConn, layout.cell(6));
        this.btnTestConn.addActionListener((ActionListener)this);
    }

    public void setBOSConnection(BosConnection conn) {
        this.setServerUrl(conn.getServiceUrl());
        this.setSolution(conn.getSolution());
        this.setAis(conn.getAis());
        this.setUser(conn.getUser());
        this.setPassword(conn.getPassword());
        this.setLocale(conn.getLocale());
    }

    public BosConnection makeBOSConnection() {
        return new BosConnection(this.getServerUrl(), this.getSolution(), this.getAis(), this.getUser(), this.getPassword(), this.getLocale());
    }

    public String getServerUrl() {
        return this.txtServerUrl.getText();
    }

    public void setServerUrl(String serverUrl) {
        this.txtServerUrl.setText(serverUrl);
    }

    public String getSolution() {
        return this.txtSolution.getText();
    }

    public void setSolution(String solution) {
        this.txtSolution.setText(solution);
    }

    public String getAis() {
        return this.txtAis.getText();
    }

    public void setAis(String ais) {
        this.txtAis.setText(ais);
    }

    public void setUser(String user) {
        this.txtUser.setText(user);
    }

    public String getUser() {
        return this.txtUser.getText();
    }

    public String getPassword() {
        return String.valueOf(this.psw.getPassword());
    }

    public void setPassword(String pswText) {
        this.psw.setText(pswText);
    }

    @Override
    public void setLocale(Locale locale) {
        this.cbxLocale.setSelectedIndex(this.fromLocale(locale));
    }

    @Override
    public Locale getLocale() {
        return this.toLocale(this.cbxLocale.getSelectedIndex());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnTestConn) {
            try {
                this.testBOSConn();
                WindowUtil.msgboxInfo((Object)UiResource.getString("res_9"), (String)UiResource.getString("res_10"), (Component)this);
            }
            catch (ConnectException ex) {
                WindowUtil.showException((String)UiResource.getString("res_11"), (Throwable)ex, (String)UiResource.getString("res_10"), (Component)this);
            }
        }
    }

    public void testBOSConn() throws ConnectException {
        BosConnection conn = this.makeBOSConnection();
        conn.open();
        conn.close();
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        KDFrame frm = new KDFrame();
        frm.setDefaultCloseOperation(3);
        frm.setTitle(UiResource.getString("res_12"));
        frm.setSize(400, 220);
        frm.getContentPane().add(new BosConnPanel());
        frm.show();
    }
}

