/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.common;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.MultiLangUI;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.types.rows.OutputColumn;
import com.kingdee.bos.ctrl.data.wizard.common.CommonResource;
import com.kingdee.bos.ctrl.data.wizard.common.FieldEditorDialog;
import com.kingdee.bos.ctrl.data.wizard.process.TablePanel;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;

public class ColumnsEditor
extends TablePanel {
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;

    public ColumnsEditor() {
        this.initTable();
        this.table.getColumn(0).setWidth(200);
        this.table.getColumn(1).setWidth(100);
        this.initListeners();
    }

    private void initTable() {
        this.table.getSelectManager().setSelectMode(10);
        KDComboBox typeEditor = new KDComboBox();
        for (int i = 0; i < DataType.ALL_TYPES.length; ++i) {
            typeEditor.addItem((Object)DataType.ALL_TYPES[i]);
        }
        KDMultiLangBox mlb = MultiLangUI.newKDMultiLangBox();
        mlb.putClientProperty((Object)"All_Modal", (Object)Boolean.TRUE);
        this.table.addColumns(2);
        this.table.getColumn(0).setWidth(180);
        IColumn col = this.table.getColumn(1);
        col.setWidth(100);
        col.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)typeEditor));
        IRow row = this.table.addHeadRow();
        row.getCell(0).setValue((Object)CommonResource.getString("res_1"));
        row.getCell(1).setValue((Object)CommonResource.getString("res_2"));
    }

    public void setColumns(List columns) {
        for (int i = 0; i < columns.size(); ++i) {
            OutputColumn oc = (OutputColumn)columns.get(i);
            oc.setOriginSeq(i + 1);
            IRow row = this.table.addRow();
            row.getCell(0).setValue((Object)oc.getName());
            row.getCell(1).setValue((Object)oc.getDataType());
        }
    }

    private void initListeners() {
        this.table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                int counts = ColumnsEditor.this.table.getRowCount();
                int index = ColumnsEditor.this.table.getSelectManager().getActiveRowIndex();
                for (int i = 0; i < counts; ++i) {
                    String name = null;
                    if (ColumnsEditor.this.table.getCell(i, 0).getValue() != null) {
                        name = ColumnsEditor.this.table.getCell(i, 0).getValue().toString();
                    }
                    if (i == index || ColumnsEditor.this.table.getCell(index, 0).getValue() == null || !StringUtil.equals((String)name, (String)ColumnsEditor.this.table.getCell(index, 0).getValue().toString())) continue;
                    WindowUtil.msgboxInfo((Object)CommonResource.getString("res_3"), (String)CommonResource.getString("res_4"), (Component)((Object)ColumnsEditor.this));
                    ColumnsEditor.this.table.getCell(index, 0).setValue(null);
                }
            }
        });
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        ColumnsEditor editor = new ColumnsEditor();
        WindowUtil.showSimpleDialog((Component)((Object)editor), null, null, null);
    }

    public List convertToOutColumn() {
        ArrayList<OutputColumn> list = new ArrayList<OutputColumn>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            OutputColumn column = new OutputColumn();
            column.setOriginSeq(i + 1);
            Object objName = this.table.getCell(i, 0).getValue();
            Object objType = this.table.getCell(i, 1).getValue();
            if (objName != null) {
                column.setName(objName.toString());
            }
            if (objType != null) {
                column.setDataType((DataType)objType);
            }
            list.add(column);
        }
        return list;
    }

    public void trim() {
        List list = this.convertToOutColumn();
        for (int i = 0; i < list.size(); ++i) {
            ((OutputColumn)list.get(i)).setOriginSeq(i + 1);
        }
    }

    public List getColumns() {
        return this.convertToOutColumn();
    }

    public static class MiniFieldEditorDialog
    extends FieldEditorDialog {
        public MiniFieldEditorDialog() {
        }

        public MiniFieldEditorDialog(Dialog dialog) {
            super(dialog);
        }

        public MiniFieldEditorDialog(Frame frame) {
            super(frame);
        }

        @Override
        protected void todoInit() {
            super.todoInit();
            this.setSize(360, 140);
            this.txtID.setPreferredSize(new Dimension(210, 19));
            this.cmbType.setPreferredSize(new Dimension(210, 19));
        }

        @Override
        protected void todoAddControls(Container parent, Cell thisCell) {
            Table layout = thisCell.split(3, 1);
            for (int i = 0; i < 2; ++i) {
                layout.rowStyle(i).setHeight(19);
                layout.rowStyle(i).setMarginBottom(3);
            }
            layout.rowStyle(2).setPriY(1);
            parent.add((Component)this.txtID.getLabelContainer(), layout.cell(0, 0));
            parent.add((Component)this.cmbType.getLabelContainer(), layout.cell(1, 0));
        }
    }
}

