/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.query;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.modal.query.Condition;
import com.kingdee.bos.ctrl.data.modal.query.IJoinList;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.data.modal.query.Join;
import com.kingdee.bos.ctrl.data.modal.query.JoinType;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedJoin;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedTable;
import com.kingdee.bos.ctrl.data.wizard.Wizard2Resource;
import com.kingdee.bos.ctrl.data.wizard.framework.IDataWizardModel;
import com.kingdee.bos.ctrl.data.wizard.framework.query.AbstractQueryWizardTabbedUI;
import com.kingdee.bos.ctrl.data.wizard.joineditor.JoinPanel;
import com.kingdee.bos.ctrl.data.wizard.joineditor.ModelField;
import com.kingdee.bos.ctrl.data.wizard.joineditor.ModelLine;
import com.kingdee.bos.ctrl.data.wizard.joineditor.ModelTable;
import com.kingdee.bos.ctrl.data.wizard.util.WizardUtil;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class JoinWizardUI
extends AbstractQueryWizardTabbedUI {
    private JoinPanel _joinPanel;
    private TableChangedHandler _tableChangedHandler;

    public String getTabbedTitle() {
        return Wizard2Resource.getString("res_35");
    }

    @Override
    protected KDPanel createPanel() {
        this._joinPanel = new JoinPanel();
        this._joinPanel.setOpaque(false);
        KDScrollPane scrollPane = new KDScrollPane((Component)this._joinPanel);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        KDPanel panTemp = new KDPanel((LayoutManager)new BorderLayout());
        panTemp.add((Component)scrollPane, (Object)"Center");
        return panTemp;
    }

    @Override
    public void setModel(IDataWizardModel model) {
        super.setModel(model);
        if (this._tableChangedHandler == null) {
            this._tableChangedHandler = new TableChangedHandler();
        }
        model.removePropertyChangedListener(this._tableChangedHandler);
        model.addPropertyChangedListener(this._tableChangedHandler);
    }

    private void updateJoinList() {
        IJoinList joins = this.getModel().getQuery().getJoins();
        joins.clear();
        ArrayList joinLines = this._joinPanel.getLineSet();
        for (int i = 0; i < joinLines.size(); ++i) {
            ModelLine joinLine = (ModelLine)joinLines.get(i);
            if (joinLine == null) continue;
            Join join = new Join();
            join.setLeftTable(joinLine.getFromTable().getId());
            join.setRightTable(joinLine.getToTable().getId());
            switch (joinLine.getType()) {
                case 1: {
                    join.setJoinType(JoinType.INNER);
                    break;
                }
                case 2: {
                    join.setJoinType(JoinType.LEFT);
                    break;
                }
                case 3: {
                    join.setJoinType(JoinType.RIGHT);
                    break;
                }
                default: {
                    join.setJoinType(JoinType.FULL);
                }
            }
            Condition cond = new Condition();
            cond.setExpr(ModelLine.builtFieldRelation(joinLine));
            join.setCondition(cond);
            DesignedJoin extObj = new DesignedJoin();
            extObj.setRelation(joinLine.getRelation());
            extObj.setIndex(joinLine.getIndex());
            extObj.setFromField(joinLine.getFromField().getId());
            extObj.setToField(joinLine.getToField().getId());
            cond.setExtObj((Object)extObj);
            joins.add((Object)join);
        }
    }

    private void updateTableExtObj() {
        ITableList queryTables = this.getModel().getQuery().getTables();
        ArrayList joinTables = this._joinPanel.getTableSet();
        block0: for (int i = 0; i < queryTables.size(); ++i) {
            ITable queryTable = (ITable)queryTables.get(i);
            for (int j = 0; j < joinTables.size(); ++j) {
                ModelTable joinTable = (ModelTable)joinTables.get(j);
                if (!StringUtil.equals((String)joinTable.getId(), (String)queryTable.getName())) continue;
                DesignedTable dt = new DesignedTable();
                Rectangle rect = joinTable.getUi().getBounds();
                dt.setX(rect.x);
                dt.setY(rect.y);
                dt.setWidth(rect.width);
                dt.setHeight(rect.height);
                queryTable.setExtObj((Object)dt);
                continue block0;
            }
        }
    }

    @Override
    public void syncUi2Model() {
        this.updateJoinList();
        this.updateTableExtObj();
    }

    @Override
    protected void doShowModel2Ui() {
        this._joinPanel.removeAllTable();
        ITableList tables = this.getModel().getQuery().getTables();
        if (tables != null) {
            for (int i = 0; i < tables.size(); ++i) {
                ModelTable joinTable;
                ITable queryTable = (ITable)tables.get(i);
                if (!this.buildModelTable(queryTable, joinTable = new ModelTable())) continue;
                if (queryTable.getExtObj() != null) {
                    DesignedTable dt = (DesignedTable)queryTable.getExtObj();
                    Rectangle rec = new Rectangle();
                    rec.x = dt.getX();
                    rec.y = dt.getY();
                    rec.width = dt.getWidth();
                    rec.height = dt.getHeight();
                    this._joinPanel.addTable(joinTable, rec);
                    continue;
                }
                this._joinPanel.addTable(joinTable);
            }
        }
        IJoinList joins = this.getModel().getQuery().getJoins();
        for (int i = 0; i < joins.size(); ++i) {
            ModelLine line = new ModelLine();
            Join join = (Join)joins.get(i);
            for (int j = 0; j < this._joinPanel.getTableSet().size(); ++j) {
                ModelTable joinTable = (ModelTable)this._joinPanel.getTableSet().get(j);
                if (StringUtil.equals((String)joinTable.getId(), (String)join.getLeftTable())) {
                    line.setFromTable(joinTable);
                    continue;
                }
                if (!StringUtil.equals((String)joinTable.getId(), (String)join.getRightTable())) continue;
                line.setToTable(joinTable);
            }
            if (line.getFromTable() == null || line.getToTable() == null) continue;
            if (join.getJoinType() == JoinType.INNER) {
                line.setType(1);
            } else if (join.getJoinType() == JoinType.LEFT) {
                line.setType(2);
            } else if (join.getJoinType() == JoinType.RIGHT) {
                line.setType(3);
            } else if (join.getJoinType() == JoinType.FULL) {
                line.setType(4);
            }
            if (join.getCondition().getExtObj() != null) {
                ModelField joinField;
                int j;
                DesignedJoin dj = (DesignedJoin)join.getCondition().getExtObj();
                for (j = 0; j < line.getFromTable().getFields().size(); ++j) {
                    joinField = (ModelField)line.getFromTable().getFields().get(j);
                    if (!StringUtil.equals((String)joinField.getId(), (String)dj.getFromField())) continue;
                    line.setFromField(joinField);
                }
                for (j = 0; j < line.getToTable().getFields().size(); ++j) {
                    joinField = (ModelField)line.getToTable().getFields().get(j);
                    if (!StringUtil.equals((String)joinField.getId(), (String)dj.getToField())) continue;
                    line.setToField(joinField);
                }
                line.setRelation(dj.getRelation());
                line.setIndex(dj.getIndex());
            }
            this._joinPanel.addLine(line);
        }
    }

    @Override
    public void syncModel2Ui() {
        ITableList queryTables = this.getModel().getQuery().getTables();
        ArrayList joinTables = this._joinPanel.getTableSet();
        for (int i = joinTables.size() - 1; i >= 0; --i) {
            ModelTable joinTable = (ModelTable)joinTables.get(i);
            boolean isExist = false;
            for (int j = 0; j < queryTables.size(); ++j) {
                ITable queryTable = (ITable)queryTables.get(j);
                if (!StringUtil.equals((String)queryTable.getName(), (String)joinTable.getId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            this._joinPanel.removeTable(joinTable);
        }
        ModelTable joinTable = null;
        for (int i = 0; i < queryTables.size(); ++i) {
            ITable queryTable = (ITable)queryTables.get(i);
            boolean isExist = false;
            for (int j = 0; j < joinTables.size(); ++j) {
                joinTable = (ModelTable)joinTables.get(j);
                if (!StringUtil.equals((String)queryTable.getName(), (String)joinTable.getId())) continue;
                isExist = true;
                break;
            }
            if (isExist && !(queryTable instanceof IQuery)) continue;
            if (!isExist) {
                joinTable = new ModelTable();
            }
            if (!this.buildModelTable(queryTable, joinTable)) continue;
            if (!isExist) {
                this._joinPanel.addTable(joinTable);
                continue;
            }
            joinTable.getUi().refreshField();
        }
    }

    private boolean buildModelTable(ITable queryTable, ModelTable joinTable) {
        MetaClass mc = WizardUtil.lookForMetaClass(queryTable, this.getModel());
        if (mc == null) {
            return false;
        }
        ArrayList<ModelField> listTemp = new ArrayList<ModelField>();
        for (MetaField mf : mc.getFields()) {
            ModelField joinField = new ModelField();
            joinField.setId(mf.getName());
            joinField.setAlias(mf.getAlias());
            if (mf.getType() == null) {
                joinField.setType(DataType.STRING);
            } else {
                joinField.setType(mf.getType());
            }
            listTemp.add(joinField);
        }
        joinTable.setFields(listTemp);
        joinTable.setId(queryTable.getName());
        joinTable.setAlias(queryTable.getAlias());
        return true;
    }

    private class TableChangedHandler
    implements PropertyChangeListener {
        private TableChangedHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (JoinWizardUI.this._joinPanel == null) {
                return;
            }
            if (evt.getPropertyName() == "table name") {
                this.changeTableName((String)evt.getOldValue(), (String)evt.getNewValue());
            } else if (evt.getPropertyName() == "table alias") {
                String id = ((ITable)evt.getSource()).getName();
                this.changeTableAlias(id, (String)evt.getOldValue(), (String)evt.getNewValue());
            }
        }

        private void changeTableName(String oldName, String newName) {
            ArrayList joinTables = JoinWizardUI.this._joinPanel.getTableSet();
            for (int i = 0; i < joinTables.size(); ++i) {
                ModelTable joinTable = (ModelTable)joinTables.get(i);
                if (!StringUtil.equals((String)joinTable.getId(), (String)oldName)) continue;
                joinTable.setId(newName);
                joinTable.getUi().refreshTable();
            }
        }

        private void changeTableAlias(String id, String oldAlias, String newAlias) {
            ArrayList joinTables = JoinWizardUI.this._joinPanel.getTableSet();
            for (int i = 0; i < joinTables.size(); ++i) {
                ModelTable joinTable = (ModelTable)joinTables.get(i);
                if (!StringUtil.equals((String)joinTable.getId(), (String)id) || !StringUtil.equals((String)joinTable.getAlias(), (String)oldAlias)) continue;
                joinTable.setAlias(newAlias);
                joinTable.getUi().refreshTable();
            }
        }
    }
}

