/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.framework.connection;

import com.kingdee.bos.ctrl.bizshare.EnumType;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;

public class DataSourceType
extends EnumType {
    public static final DataSourceType DB = new DataSourceType("db", DataSourceType.getMLS("db", "\u6570\u636e\u5e93"));
    public static final DataSourceType BOS = new DataSourceType("bos", DataSourceType.getMLS("bos", "\u91d1\u8776BOS"));
    public static final DataSourceType OLAP = new DataSourceType("olap", DataSourceType.getMLS("olap", "OLAP"));
    public static final DataSourceType KDRS = new DataSourceType("kdrs", DataSourceType.getMLS("kdrs", "\u6570\u636e\u96c6"));
    public static final DataSourceType XML = new DataSourceType("xml", DataSourceType.getMLS("xml", "XML\u683c\u5f0f"));
    public static final DataSourceType CSV = new DataSourceType("csv", DataSourceType.getMLS("csv", "CSV\u683c\u5f0f"));

    private static String getMLS(String key, String defaultValue) {
        String res = CtrlClassUtil.getPackageName(DataSourceType.class) + ".datasourceType";
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }

    private DataSourceType(String name, String alias) {
        super(name, alias);
    }

    public static DataSourceType fromName(String name) {
        if (DB.getName().equals(name)) {
            return DB;
        }
        if (BOS.getName().equals(name)) {
            return BOS;
        }
        if (OLAP.getName().equals(name)) {
            return OLAP;
        }
        if (KDRS.getName().equals(name)) {
            return KDRS;
        }
        return null;
    }

    public static DataSourceType fromQueryType(QueryType qt) {
        String capital = qt.getCapital();
        if (capital.equals("sql")) {
            return DB;
        }
        if (capital.equals("bos")) {
            return BOS;
        }
        return null;
    }
}

