/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.base;

import com.kingdee.bos.ctrl.etl.exception.ETLEOFException;
import com.kingdee.bos.ctrl.etl.exception.ETLFileException;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.util.XMLInterface;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class Row
implements XMLInterface,
Comparable,
Serializable {
    private final List list = new ArrayList();
    public static final long serialVersionUID = -8246477781266195408L;
    private boolean ignore;
    private Date logdate;

    public Row() {
        this.ignore = false;
        this.logdate = null;
    }

    public Row(Row r) {
        this();
        for (int i = 0; i < r.size(); ++i) {
            this.addValue(new Value(r.getValue(i)));
        }
        this.setIgnore(r.isIgnored());
    }

    public Value getValue(int index) {
        return (Value)this.list.get(index);
    }

    public void addValue(Value v) {
        this.list.add(v);
    }

    public void setValue(int idx, Value v) {
        this.list.set(idx, v);
    }

    public void addValue(int idx, Value v) {
        this.list.add(idx, v);
    }

    public boolean removeValue(String valname) {
        int idx = this.searchValueIndex(valname);
        if (idx < 0) {
            return false;
        }
        this.list.remove(idx);
        return true;
    }

    public void removeValue(int idx) {
        this.list.remove(idx);
    }

    public void clear() {
        this.list.clear();
    }

    public void addRow(Row r) {
        if (r == null) {
            return;
        }
        for (int i = 0; i < r.size(); ++i) {
            Value v1 = r.getValue(i);
            this.addValue(v1);
        }
    }

    public void mergeRow(Row r) {
        for (int x = 0; x < r.size(); ++x) {
            Value field = r.getValue(x);
            if (this.searchValue(field.getName()) != null) continue;
            this.addValue(field);
        }
    }

    public int searchValueIndex(String name) {
        if (name == null) {
            return -1;
        }
        for (int i = 0; i < this.size(); ++i) {
            Value v = this.getValue(i);
            if (v.getName().compareToIgnoreCase(name) != 0) continue;
            return i;
        }
        return -1;
    }

    public Value searchValue(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.size(); ++i) {
            Value v = this.getValue(i);
            if (!v.getName().equalsIgnoreCase(name)) continue;
            return v;
        }
        return null;
    }

    public int size() {
        return this.list.size();
    }

    public void print() {
    }

    public String toString() {
        String retval = "[";
        for (int i = 0; i < this.size(); ++i) {
            Value value = this.getValue(i);
            if (i != 0) {
                retval = retval + ", ";
            }
            retval = value != null ? retval + value.getName() + "=" + value.toString(false) : retval + "NULL";
        }
        retval = retval + "]";
        return retval;
    }

    public String toStringMeta() {
        String retval = "[";
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                retval = retval + ", ";
            }
            if (this.getValue(i) != null) {
                Value v = this.getValue(i);
                retval = retval + v.getName() + "(";
                retval = retval + v.getTypeDesc();
                if (v.getLength() > 0) {
                    retval = retval + "(";
                    retval = retval + v.getLength();
                    if (v.getPrecision() > 0) {
                        retval = retval + "," + v.getPrecision();
                    }
                    retval = retval + ")";
                }
                retval = retval + ")";
                continue;
            }
            retval = retval + "NULL";
        }
        retval = retval + "]";
        return retval;
    }

    public void setIgnore() {
        this.ignore = true;
    }

    public void setIgnore(boolean i) {
        this.ignore = i;
    }

    public boolean isIgnored() {
        return this.ignore;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.writeObj(new DataOutputStream(out));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.readObj(new DataInputStream(in));
    }

    private void writeObj(DataOutputStream dos) throws IOException {
        dos.writeInt(this.size());
        for (int i = 0; i < this.size(); ++i) {
            this.getValue(i).writeObj(dos);
        }
    }

    public void write(DataOutputStream dos) throws ETLFileException {
        try {
            this.writeObj(dos);
        }
        catch (Exception e) {
            throw new ETLFileException("Error writing row to output stream", e);
        }
    }

    private void readObj(DataInputStream dis) throws IOException {
        int size = dis.readInt();
        for (int i = 0; i < size; ++i) {
            Value v = new Value();
            v.readObj(dis);
            this.addValue(v);
        }
    }

    public Row(DataInputStream dis) throws ETLFileException {
        try {
            this.readObj(dis);
        }
        catch (EOFException e) {
            throw new ETLEOFException("End of file reached", e);
        }
        catch (Exception e) {
            throw new ETLFileException("Error reading row data from data input stream", e);
        }
    }

    public Row(DataInputStream dis, int size, Row meta) throws ETLFileException {
        try {
            for (int i = 0; i < size; ++i) {
                this.addValue(new Value(meta.getValue(i), dis));
            }
        }
        catch (Exception e) {
            throw new ETLFileException("ROW Error reading row info", e);
        }
    }

    public boolean writeData(DataOutputStream dos) throws ETLFileException {
        for (int i = 0; i < this.size(); ++i) {
            Value v = this.getValue(i);
            v.writeData(dos);
        }
        return true;
    }

    public int compare(Row r, int[] fieldnrs, boolean[] ascending) {
        return this.compare(r, fieldnrs, ascending, null);
    }

    public int compare(Row r, int[] fieldnrs, boolean[] ascending, boolean[] caseInsensitive) {
        int retval = 0;
        int len = fieldnrs.length;
        for (int i = 0; i < len; ++i) {
            Value v1 = this.getValue(fieldnrs[i]);
            Value v2 = r.getValue(fieldnrs[i]);
            retval = caseInsensitive != null ? v1.compare(v2, caseInsensitive[i]) : v1.compare(v2);
            if (!ascending[i]) {
                retval *= -1;
            }
            if (retval == 0) continue;
            return retval;
        }
        return retval;
    }

    public int compare(Row r, int fieldnr, boolean sort_desc) {
        int retval = 0;
        Value v1 = this.getValue(fieldnr);
        Value v2 = r.getValue(fieldnr);
        retval = v1.compare(v2);
        if (sort_desc) {
            retval *= -1;
        }
        return retval;
    }

    public int compare(Row r) {
        return this.compare(r, true);
    }

    public int compare(Row r, boolean caseInsensitive) {
        int retval = 0;
        int len = r.size();
        for (int i = 0; i < len; ++i) {
            Value v2;
            Value v1 = this.getValue(i);
            retval = v1.compare(v2 = r.getValue(i), caseInsensitive);
            if (retval == 0) continue;
            return retval;
        }
        return 0;
    }

    public int compareTo(Object obj) {
        return this.compare((Row)obj);
    }

    public boolean equals(Object r) {
        Row row = (Row)r;
        return this.compare(row) == 0;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < this.size(); ++i) {
            hash ^= this.getValue(i).hashCode();
        }
        return hash;
    }

    public Row Clone() {
        return new Row(this);
    }

    public void setLogdate() {
        this.logdate = new Date();
    }

    public Date getLogdate() {
        return this.logdate;
    }

    public long getLogtime() {
        if (this.logdate == null) {
            return 0L;
        }
        return this.logdate.getTime();
    }

    public boolean isEmpty() {
        boolean empty = true;
        for (int i = 0; i < this.size(); ++i) {
            Value v = this.getValue(i);
            if (v == null || v.isNull()) continue;
            empty = false;
        }
        return empty;
    }

    public String[] getFieldNames() {
        String[] retval = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            retval[i] = this.getValue(i).getName();
        }
        return retval;
    }

    public String[] getFieldNamesAndTypes(int maxlen) {
        String[] retval = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            Value v = this.getValue(i);
            retval[i] = Const.rightPad(v.getName(), maxlen) + "   (" + v.getTypeDesc() + ")";
        }
        return retval;
    }

    public boolean getBoolean(String valuename, boolean def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return v.getBoolean();
    }

    public String getString(String valuename, String def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return v.getString();
    }

    public Date getDate(String valuename, Date def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return v.getDate();
    }

    public double getNumber(String valuename, double def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return v.getNumber();
    }

    public long getInteger(String valuename, long def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return v.getInteger();
    }

    public long getShort(String valuename, int def) {
        Value v = this.searchValue(valuename);
        if (v == null) {
            return def;
        }
        return (int)v.getInteger();
    }

    @Override
    public String getXML() {
        String retval = "<row>";
        retval = retval + XMLHandler.addTagValue("logdate", this.logdate);
        for (int i = 0; i < this.size(); ++i) {
            retval = retval + this.getValue(i).getXML();
        }
        retval = retval + "</row>" + Const.CR;
        return retval;
    }

    public static final void sortRows(List rows, int[] fieldNrs, boolean[] ascDesc) {
        final int[] fieldNumbers = fieldNrs;
        final boolean[] ascending = ascDesc;
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Row one = (Row)o1;
                Row two = (Row)o2;
                return one.compare(two, fieldNumbers, ascending);
            }
        };
        Collections.sort(rows, comparator);
    }
}

