/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.job.JobMeta;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class JobLog {
    private Database db;
    private String tableAudit;
    private String tableError;
    private JobMeta jobmeta;

    public JobLog(JobMeta jobmeta, DatabaseMeta con, String tableAudit, String tableError) {
        this.jobmeta = jobmeta;
        this.db = new Database(con);
        this.tableAudit = tableAudit;
        this.tableError = tableError;
    }

    public List getJobAudit() throws ETLDatabaseException {
        this.db.connect();
        String sql = "select * from " + this.tableAudit + " where jobname='" + this.jobmeta.getName() + "'";
        ArrayList lstJobAudit = this.db.getRows(sql, 0);
        this.db.disconnect();
        return lstJobAudit;
    }

    public List getJobError() throws ETLDatabaseException {
        this.db.connect();
        String sql = "select * from " + this.tableError + " where jobname='" + this.jobmeta.getName() + "'";
        ArrayList lstJobError = this.db.getRows(sql, 0);
        this.db.disconnect();
        return lstJobError;
    }

    public void insertJobLog(Date startDate, Date endDate, Date logDate, boolean isSuccess, String log_string) throws ETLDatabaseException {
        this.db.connect();
        String jobName = this.jobmeta.getName();
        String scheduleName = this.jobmeta.getScheduleName();
        this.insertJobAudit(this.tableAudit, jobName, startDate, endDate, isSuccess, scheduleName);
        if (!isSuccess) {
            this.insertJobErrorLog(this.tableError, jobName, log_string, logDate, scheduleName);
        }
        this.db.disconnect();
    }

    private long insertJobAudit(String logAuditTable, String jobName, Date startDate, Date endDate, boolean isSuccess, String scheduleName) throws ETLDatabaseException {
        long id = this.db.getNextJobAuditID();
        String tablename = logAuditTable;
        Row table = new Row();
        table.addValue(new Value("ID_JobAudit", id));
        table.addValue(new Value("JobName", jobName));
        table.addValue(new Value("ScheduleName", scheduleName));
        table.addValue(new Value("IsSuccess", isSuccess));
        table.addValue(new Value("StartTime", startDate));
        table.addValue(new Value("EndTime", endDate));
        this.db.prepareInsert(table, tablename);
        this.db.setValuesInsert(table);
        this.db.insertRow();
        this.db.closeInsert();
        return id;
    }

    private long insertJobErrorLog(String logErrorTable, String jobName, String description, Date occuredTime, String scheduleName) throws ETLDatabaseException {
        long id = this.db.getNextJobErrorLogID();
        String tablename = logErrorTable;
        Row table = new Row();
        table.addValue(new Value("ID_JobErrorLog", id));
        table.addValue(new Value("JobName", jobName));
        table.addValue(new Value("ScheduleName", scheduleName));
        table.addValue(new Value("Description", description));
        table.addValue(new Value("OccuredTime", occuredTime));
        this.db.prepareInsert(table, tablename);
        this.db.setValuesInsert(table);
        this.db.insertRow();
        this.db.closeInsert();
        return id;
    }
}

