/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job.entry.trans;

import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLJobException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryBase;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryInterface;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.repository.RepositoryDirectory;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Node;

public class JobEntryTrans
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String transname;
    private String filename;
    private RepositoryDirectory directory;
    public String[] arguments;
    public boolean argFromPrevious;
    public boolean setLogfile;
    public String logfile;
    public String logext;
    public boolean addDate;
    public boolean addTime;
    public int loglevel;
    public boolean parallel;
    private String directoryPath;

    public JobEntryTrans(String name) {
        super(name, "");
        this.setType(1);
    }

    public JobEntryTrans() {
        this("");
        this.clear();
    }

    public JobEntryTrans(JobEntryBase jeb) {
        super(jeb);
    }

    public void setFileName(String n) {
        this.filename = n;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setTransname(String transname) {
        this.transname = transname;
    }

    public String getTransname() {
        return this.transname;
    }

    public RepositoryDirectory getDirectory() {
        return this.directory;
    }

    public void setDirectory(RepositoryDirectory directory) {
        this.directory = directory;
    }

    public String getLogFilename() {
        String retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = retval + this.logfile;
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = retval + "." + this.logext;
            }
        }
        return retval;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + super.getXML();
        retval = retval + "      " + XMLHandler.addTagValue("filename", this.filename);
        retval = retval + "      " + XMLHandler.addTagValue("transname", this.transname);
        if (this.directory != null) {
            retval = retval + "      " + XMLHandler.addTagValue("directory", this.directory.getPath());
        } else if (this.directoryPath != null) {
            retval = retval + "      " + XMLHandler.addTagValue("directory", this.directoryPath);
        }
        retval = retval + "      " + XMLHandler.addTagValue("arg_from_previous", this.argFromPrevious);
        retval = retval + "      " + XMLHandler.addTagValue("set_logfile", this.setLogfile);
        retval = retval + "      " + XMLHandler.addTagValue("logfile", this.logfile);
        retval = retval + "      " + XMLHandler.addTagValue("logext", this.logext);
        retval = retval + "      " + XMLHandler.addTagValue("add_date", this.addDate);
        retval = retval + "      " + XMLHandler.addTagValue("add_time", this.addTime);
        retval = retval + "      " + XMLHandler.addTagValue("loglevel", LogWriter.getLogLevelDesc(this.loglevel));
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval = retval + "      " + XMLHandler.addTagValue("argument" + i, this.arguments[i]);
            }
        }
        return retval;
    }

    @Override
    public void loadXML(Node entrynode, List databases, Connection ctxConnection) throws ETLXMLException {
        try {
            super.loadXML(entrynode, databases, ctxConnection);
            this.filename = XMLHandler.getTagValue(entrynode, "filename");
            this.transname = XMLHandler.getTagValue(entrynode, "transname");
            this.directoryPath = XMLHandler.getTagValue(entrynode, "directory");
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "arg_from_previous"));
            this.setLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "set_logfile"));
            this.addDate = "Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "add_date"));
            this.addTime = "Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "add_time"));
            this.logfile = XMLHandler.getTagValue(entrynode, "logfile");
            this.logext = XMLHandler.getTagValue(entrynode, "logext");
            this.loglevel = LogWriter.getLogLevel(XMLHandler.getTagValue(entrynode, "loglevel"));
            int argnr = 0;
            while (XMLHandler.getTagValue(entrynode, "argument" + argnr) != null) {
                ++argnr;
            }
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = XMLHandler.getTagValue(entrynode, "argument" + a);
            }
        }
        catch (ETLException e) {
            throw new ETLXMLException("Unable to load transformation job entry from XML node", e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List databases) throws ETLException {
        try {
            super.loadRep(rep, id_jobentry, databases);
            long id_transformation = rep.getJobEntryAttributeInteger(id_jobentry, "id_transformation");
            Row r = rep.getTransformation(id_transformation);
            if (r != null) {
                this.transname = r.getString("NAME", null);
                long id_directory = r.getInteger("ID_DIRECTORY", 0L);
                this.directory = id_directory > 0L ? rep.getDirectoryTree().findDirectory(id_directory) : rep.getDirectoryTree();
            }
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "file_name");
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.setLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_logfile");
            this.addDate = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.addTime = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_time");
            this.logfile = rep.getJobEntryAttributeString(id_jobentry, "logfile");
            this.logext = rep.getJobEntryAttributeString(id_jobentry, "logext");
            this.loglevel = LogWriter.getLogLevel(rep.getJobEntryAttributeString(id_jobentry, "loglevel"));
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "argument");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "argument");
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load job entry of type transMeta from the repository for id_jobentry=" + id_jobentry, dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws ETLException {
        try {
            super.saveRep(rep, id_job);
            long id_transformation = rep.getTransformationID(this.transname, this.directory.getID());
            rep.saveJobEntryAttribute(id_job, this.getID(), "file_name", this.filename);
            if (id_transformation < 0L && !this.filename.equalsIgnoreCase("")) {
                TransMeta tm = new TransMeta(this.filename, null);
                tm.saveRep(rep, null);
                rep.saveJobEntryAttribute(id_job, this.getID(), "id_transformation", tm.getID());
            }
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "set_logfile", this.setLogfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_date", this.addDate);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_time", this.addTime);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logfile", this.logfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logext", this.logext);
            rep.saveJobEntryAttribute(id_job, this.getID(), "loglevel", LogWriter.getLogLevelDesc(this.loglevel));
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "argument", this.arguments[i]);
                }
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("unable to save job entry of type transMeta to the repository for id_job=" + id_job, dbe);
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.transname = null;
        this.filename = null;
        this.directory = new RepositoryDirectory();
        this.arguments = null;
        this.argFromPrevious = false;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
    }

    @Override
    public Result execute(Result prev_result, int nr, Repository rep, Job parentJob) throws ETLJobException {
        LogWriter log = LogWriter.getInstance();
        Result result = prev_result;
        result.setEntryNr(nr);
        LogWriter logwriter = log;
        if (this.setLogfile) {
            logwriter = LogWriter.getInstance(this.getLogFilename(), true, this.loglevel);
        }
        log.logBasic(this.toString(), "Opening transformation: [" + this.getTransname() + "] in directory [" + this.directory.getPath() + "]");
        try {
            TransMeta transMeta;
            log.logDetailed(this.toString(), "Starting transformation...(file=" + this.getFileName() + ", name=" + this.getName() + "), repinfo=" + this.getDescription());
            if (this.getTransname() != null && this.getTransname().length() > 0 && this.getDirectory() != null) {
                transMeta = new TransMeta(rep, this.getTransname(), this.getDirectory(), this.getCtxConnection());
            } else if (this.getFileName() != null && this.getFileName().length() > 0) {
                transMeta = new TransMeta(this.getFileName(), this.getCtxConnection());
            } else {
                throw new ETLJobException("The transformation to execute is not specified!");
            }
            transMeta.setArguments(this.arguments);
            Trans trans = new Trans(logwriter, transMeta);
            trans.getTransMeta().setSourceRows(prev_result.rows);
            trans.setSourceRows(prev_result.rows);
            if (!trans.execute(this.arguments)) {
                result.setNrErrors(1L);
            } else {
                while (!trans.isFinished() && !parentJob.isStopped()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (parentJob.isStopped()) {
                    trans.stopAll();
                    trans.waitUntilFinished();
                    trans.endProcessing("stop");
                } else {
                    trans.endProcessing("end");
                }
                result = trans.getResult();
                result.setEntryNr(nr);
            }
        }
        catch (ETLException e) {
            log.logError(this.toString(), "Unable to open transformation: " + e.getMessage());
            result.setNrErrors(1L);
        }
        if (this.setLogfile) {
            logwriter.close();
        }
        if (result.getNrErrors() == 0L) {
            result.setResult(true);
        } else {
            result.setResult(false);
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }
}

