/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule.ui;

import com.kingdee.bos.ctrl.etl.schedule.ui.AbstractScheduleType;
import com.kingdee.bos.ctrl.etl.schedule.ui.SelTypeChangeEvent;
import com.kingdee.bos.ctrl.etl.schedule.ui.SelTypeListener;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectScheduleType
extends AbstractScheduleType {
    private static final long serialVersionUID = 1L;
    private Collection listeners = new ArrayList();

    public SelectScheduleType() throws Exception {
        this.initializeUI();
    }

    private void setEnable(boolean enable) {
        this.everyDaykDRadioButton.setEnabled(enable);
        this.everyWeekkDRadioButton.setEnabled(enable);
        this.everyMonthkDRadioButton.setEnabled(enable);
        this.oneTimekDRadioButton.setEnabled(enable);
        this.userDefineKDRadioButton.setEnabled(enable);
    }

    private void initializeUI() {
        this.everyDaykDRadioButton.setSelected(true);
        CommonChangeListener l = new CommonChangeListener();
        this.everyDaykDRadioButton.addChangeListener((ChangeListener)l);
        this.everyMonthkDRadioButton.addChangeListener((ChangeListener)l);
        this.everyWeekkDRadioButton.addChangeListener((ChangeListener)l);
        this.oneTimekDRadioButton.addChangeListener((ChangeListener)l);
        this.userDefineKDRadioButton.addChangeListener((ChangeListener)l);
    }

    public int getScheduleType() {
        if (this.everyDaykDRadioButton.isSelected()) {
            return 1;
        }
        if (this.everyMonthkDRadioButton.isSelected()) {
            return 2;
        }
        if (this.everyWeekkDRadioButton.isSelected()) {
            return 3;
        }
        if (this.oneTimekDRadioButton.isSelected()) {
            return 4;
        }
        if (this.userDefineKDRadioButton.isSelected()) {
            return 5;
        }
        throw new UnsupportedOperationException();
    }

    public void setScheduleType(int value, boolean readOnly) {
        switch (value) {
            case 1: {
                this.everyDaykDRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.everyMonthkDRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.everyWeekkDRadioButton.setSelected(true);
                break;
            }
            case 4: {
                this.oneTimekDRadioButton.setSelected(true);
                break;
            }
            case 5: {
                this.userDefineKDRadioButton.setSelected(true);
            }
        }
        this.setEnable(!readOnly);
    }

    public void addSelTypeChangeListener(SelTypeListener l) {
        this.listeners.add(l);
    }

    public void removeSelTypeChangeListener(SelTypeListener l) {
        this.listeners.remove(l);
    }

    private void fireSelTypeChanged(SelTypeChangeEvent e) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((SelTypeListener)it.next()).selTypeChanged(e);
        }
    }

    private class CommonChangeListener
    implements ChangeListener {
        private CommonChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            KDRadioButton sel = (KDRadioButton)e.getSource();
            if (sel.isSelected()) {
                SelTypeChangeEvent selTypeChangeEvent = new SelTypeChangeEvent(sel);
                SelectScheduleType.this.fireSelTypeChanged(selTypeChangeEvent);
            }
        }
    }
}

