/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation;

import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.base.RowSet;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLTransException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.repository.RepositoryDirectory;
import com.kingdee.bos.ctrl.etl.transformation.TransDependency;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.mappinginput.MappingInput;
import com.kingdee.bos.ctrl.etl.transformation.step.mappingoutput.MappingOutput;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Trans {
    private LogWriter log;
    private TransMeta transMeta;
    private boolean preview;
    private boolean monitored;
    private Date startDate;
    private Date endDate;
    private Date currentDate;
    private Date logDate;
    private Date depDate;
    private ArrayList rowsets;
    private ArrayList steps;
    public int class_nr;
    public static final int TYPE_DISP_1_1 = 1;
    public static final int TYPE_DISP_1_N = 2;
    public static final int TYPE_DISP_N_1 = 3;
    public static final int TYPE_DISP_N_N = 4;
    private String[] preview_steps;
    private int[] preview_sizes;

    public Trans(LogWriter lw, String file, String name, String[] args) {
        this.log = lw;
        this.class_nr = 1;
        this.transMeta = new TransMeta(file, name, args);
        this.preview = false;
    }

    public Trans(LogWriter lw, TransMeta transMeta, String[] prev_steps, int[] prev_sizes) {
        this(lw, (String)null, (String)null, new String[]{"no filename, preview mode"});
        this.transMeta = transMeta;
        this.preview = true;
        this.preview_steps = prev_steps;
        this.preview_sizes = prev_sizes;
        this.log.logBasic(this.toString(), "Transformation is in preview mode...");
        this.log.logDebug(this.toString(), "nr of steps to preview : " + transMeta.stepCount() + ", nr of hops : " + transMeta.transHopCount());
    }

    public Trans(LogWriter lw, TransMeta transMeta) {
        this(lw, (String)null, (String)null, new String[]{"no filename, preloaded transformation"});
        this.transMeta = transMeta;
        this.preview = false;
        this.preview_steps = null;
        this.preview_sizes = null;
        this.log.logBasic(this.toString(), "Transformation is pre-loaded from repository.");
        this.log.logDebug(this.toString(), "nr of steps to run : " + transMeta.stepCount() + ", nr of hops : " + transMeta.transHopCount());
    }

    public String getName() {
        if (this.transMeta == null) {
            return null;
        }
        return this.transMeta.getName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void open(Repository rep, String name, String dirname, String filename) throws ETLException {
        try {
            if (rep != null) {
                RepositoryDirectory repdir = rep.getDirectoryTree().findDirectory(dirname);
                if (repdir == null) throw new ETLException("Unable to load transformation [" + name + "] because directory could not be found: [" + dirname + "]");
                this.transMeta = new TransMeta(rep, name, repdir, null);
                return;
            } else {
                this.transMeta = new TransMeta(filename, null);
            }
            return;
        }
        catch (ETLException e) {
            throw new ETLException("Transformation was unable to open [" + name + "]", e);
        }
    }

    public boolean execute(String[] arguments) {
        int i;
        int nrcopies;
        StepMeta stepMeta;
        int i2;
        this.startDate = null;
        this.transMeta.setArguments(arguments);
        if (this.transMeta.isLogfieldUsed()) {
            this.log.startStringCapture();
            this.log.setString("START" + Const.CR);
        }
        if (this.transMeta.getName() == null) {
            this.log.logBasic(this.toString(), "Dispatching started for filename [" + this.transMeta.getFilename() + "]");
        } else {
            this.log.logBasic(this.toString(), "Dispatching started for transformation [" + this.transMeta.getName() + "]");
        }
        if (this.transMeta.getArguments() != null) {
            this.log.logBasic(this.toString(), "Nr of arguments detected: " + this.transMeta.getArguments().length);
        }
        this.steps = new ArrayList();
        this.rowsets = new ArrayList();
        if (this.isMonitored()) {
            this.transMeta.sortStepsNatural();
            this.transMeta.sortHopsNatural();
        }
        ArrayList hopsteps = this.transMeta.getTransHopSteps(false);
        this.log.logDetailed(this.toString(), "I found " + hopsteps.size() + " different steps to launch.");
        this.log.logDetailed(this.toString(), "Allocating rowsets...");
        for (i2 = 0; i2 < hopsteps.size(); ++i2) {
            stepMeta = (StepMeta)hopsteps.get(i2);
            this.log.logDetailed(this.toString(), " Allocating rowsets for step " + i2 + " --> " + stepMeta.getName());
            int nroutput = this.transMeta.findNextStepCount(stepMeta);
            for (int n = 0; n < nroutput; ++n) {
                int disptype;
                StepMeta nsi = this.transMeta.findNextStep(stepMeta, n);
                int nextcopies = nsi.getCopies();
                int prevcopies = stepMeta.getCopies();
                this.log.logDetailed(this.toString(), "  prevcopies = " + prevcopies + ", nextcopies=" + nextcopies);
                if (prevcopies == 1 && nextcopies == 1) {
                    disptype = 1;
                    nrcopies = 1;
                } else if (prevcopies == 1 && nextcopies > 1) {
                    disptype = 2;
                    nrcopies = nextcopies;
                } else if (prevcopies > 1 && nextcopies == 1) {
                    disptype = 3;
                    nrcopies = prevcopies;
                } else if (prevcopies == nextcopies) {
                    disptype = 4;
                    nrcopies = nextcopies;
                } else {
                    this.log.logError(this.toString(), "Only 1-1, 1-n, n-1 and n-n relationships are allowed!");
                    this.log.logError(this.toString(), "This means you can't have x-y relationships!");
                    return false;
                }
                for (int c = 0; c < nrcopies; ++c) {
                    RowSet rs = new RowSet(this.transMeta.getSizeRowset());
                    switch (disptype) {
                        case 1: {
                            rs.setThreadNameFromToCopy(stepMeta.getName(), 0, nsi.getName(), 0);
                            break;
                        }
                        case 2: {
                            rs.setThreadNameFromToCopy(stepMeta.getName(), 0, nsi.getName(), c);
                            break;
                        }
                        case 3: {
                            rs.setThreadNameFromToCopy(stepMeta.getName(), c, nsi.getName(), 0);
                            break;
                        }
                        case 4: {
                            rs.setThreadNameFromToCopy(stepMeta.getName(), c, nsi.getName(), c);
                        }
                    }
                    this.rowsets.add(rs);
                    this.log.logDetailed(this.toString(), "Transformation allocated new rowset [" + rs.toString() + "]");
                }
            }
            this.log.logDetailed(this.toString(), " Allocated " + this.rowsets.size() + " rowsets for step " + i2 + " --> " + stepMeta.getName() + " ");
        }
        this.log.logDetailed(this.toString(), "Allocating Steps & StepData...");
        for (i2 = 0; i2 < hopsteps.size(); ++i2) {
            stepMeta = (StepMeta)hopsteps.get(i2);
            String stepid = stepMeta.getStepID();
            this.log.logDetailed(this.toString(), " Transformation is about to allocate step [" + stepMeta.getName() + "] of type [" + stepid + "]");
            nrcopies = stepMeta.getCopies();
            this.log.logDebug(this.toString(), "  Step has nrcopies=" + nrcopies);
            for (int c = 0; c < nrcopies; ++c) {
                StepInterface step;
                StepDataInterface data;
                if (this.hasStepStarted(stepMeta.getName(), c)) continue;
                StepMetaDataCombi combi = new StepMetaDataCombi();
                combi.stepname = stepMeta.getName();
                combi.copy = c;
                combi.meta = stepMeta.getStepMetaInterface();
                combi.data = data = combi.meta.getStepData();
                combi.step = step = combi.meta.getStep(stepMeta, data, c, this.transMeta, this);
                this.steps.add(combi);
                this.log.logDetailed(this.toString(), " Transformation has allocated a new step: [" + stepMeta.getName() + "]." + c);
            }
        }
        this.setThreadsOnRowSets();
        try {
            this.beginProcessing();
        }
        catch (ETLTransException kte) {
            this.log.logError(this.toString(), kte.getMessage());
            return false;
        }
        if (this.preview && this.preview_steps != null) {
            for (i2 = 0; i2 < this.steps.size(); ++i2) {
                StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i2);
                BaseStep rt = (BaseStep)((Object)sid.step);
                for (int x = 0; x < this.preview_steps.length; ++x) {
                    if (!this.preview_steps[x].equalsIgnoreCase(rt.getStepname()) || rt.getCopy() != 0) continue;
                    rt.previewSize = this.preview_sizes[x];
                    rt.previewBuffer = new ArrayList();
                }
            }
        }
        boolean ok = true;
        for (i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            if (sid.step.init(sid.meta, sid.data)) {
                sid.data.setStatus(3);
                continue;
            }
            sid.step.setErrors(1L);
            this.log.logError(this.toString(), "Error initializing step [" + sid.step.getStepname() + "]");
            ok = false;
        }
        if (!ok) {
            this.log.logError(this.toString(), "We failed to initialize at least one step.  Execution can not begin!");
            return false;
        }
        for (i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            sid.step.markStart();
            sid.step.start();
        }
        this.log.logDetailed(this.toString(), "Transformation has allocated " + this.steps.size() + " threads and " + this.rowsets.size() + " rowsets.");
        return true;
    }

    public void logSummary(StepInterface si) {
        this.log.logBasic(si.getStepname(), "Finished processing (I=" + si.getLinesInput() + ", O=" + si.getLinesOutput() + ", R=" + si.getLinesRead() + ", W=" + si.getLinesWritten() + ", U=" + si.getLinesUpdated() + ", E=" + si.getErrors());
    }

    public void waitUntilFinished() {
        int ended = 0;
        int errors = 0;
        try {
            while (ended != this.steps.size() && errors == 0) {
                ended = this.getEnded();
                errors = this.getErrors();
                Thread.sleep(100L);
            }
            if (errors == 0) {
                this.log.logBasic(this.toString(), "Transformation ended.");
            } else {
                this.log.logBasic(this.toString(), "Transformation detected " + errors + " steps with errors!");
                this.log.logBasic(this.toString(), "Transformation is killing the other steps!");
                this.killAll();
            }
        }
        catch (Exception e) {
            this.log.logError(this.toString(), "Transformation error: " + e.toString());
        }
    }

    public int getErrors() {
        if (this.steps == null) {
            return 0;
        }
        int errors = 0;
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            if (sid.step.getErrors() == 0L) continue;
            ++errors;
        }
        if (errors > 0) {
            this.log.logError(this.toString(), "Errors detected!");
        }
        return errors;
    }

    public int getEnded() {
        int ended = 0;
        if (this.steps == null) {
            return 0;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            BaseStep thr = (BaseStep)((Object)sid.step);
            if (thr == null || thr.isAlive()) continue;
            ++ended;
        }
        return ended;
    }

    public boolean isFinished() {
        if (this.steps == null) {
            return false;
        }
        int ended = this.getEnded();
        return ended == this.steps.size();
    }

    public void killAll() {
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            BaseStep thr = (BaseStep)((Object)sid.step);
            this.log.logBasic(this.toString(), "Looking at step: " + thr.getStepname());
            while (thr.isAlive()) {
                thr.stopAll();
                try {
                    Thread.sleep(20L);
                }
                catch (Exception e) {
                    this.log.logError(this.toString(), "Transformation error: " + e.toString());
                    return;
                }
            }
        }
    }

    public void printStats(int seconds) {
        this.log.logBasic(this.toString(), " ");
        if (this.steps == null) {
            return;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            BaseStep thr = (BaseStep)((Object)sid.step);
            long proc = thr.getProcessed();
            if (seconds != 0) {
                if (thr.getErrors() == 0L) {
                    this.log.logBasic(this.toString(), "Process '" + thr.getStepname() + "'." + thr.getCopy() + " ended successfully, processed " + proc + " lines. (" + proc / (long)seconds + " lines/s)");
                    continue;
                }
                this.log.logError(this.toString(), "Process '" + thr.getStepname() + "'." + thr.getCopy() + " ended with " + thr.getErrors() + " errors after " + proc + " lines. (" + proc / (long)seconds + " lines/s)");
                continue;
            }
            if (thr.getErrors() == 0L) {
                this.log.logBasic(this.toString(), "Process '" + thr.getStepname() + "'." + thr.getCopy() + " ended successfully, processed " + proc + " lines in " + seconds + " seconds.");
                continue;
            }
            this.log.logError(this.toString(), "Process '" + thr.getStepname() + "'." + thr.getCopy() + " ended with " + thr.getErrors() + " errors after processing " + proc + " lines in " + seconds + " seconds.");
        }
    }

    public long getLastProcessed() {
        if (this.steps == null) {
            return 0L;
        }
        int i = this.steps.size() - 1;
        if (i <= 0) {
            return 0L;
        }
        StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
        BaseStep thr = (BaseStep)((Object)sid.step);
        return thr.getProcessed();
    }

    public RowSet findRowSet(String rowsetname) {
        for (int i = 0; i < this.rowsets.size(); ++i) {
            RowSet rs = (RowSet)this.rowsets.get(i);
            if (!rs.getName().equalsIgnoreCase(rowsetname)) continue;
            return rs;
        }
        return null;
    }

    public RowSet findRowSet(String from, int fromcopy, String to, int tocopy) {
        for (int i = 0; i < this.rowsets.size(); ++i) {
            RowSet rs = (RowSet)this.rowsets.get(i);
            if (!rs.getOriginStepName().equalsIgnoreCase(from) || !rs.getDestinationStepName().equalsIgnoreCase(to) || rs.getOriginStepCopy() != fromcopy || rs.getDestinationStepCopy() != tocopy) continue;
            return rs;
        }
        return null;
    }

    public boolean hasStepStarted(String sname, int copy) {
        for (int i = 0; i < this.steps.size(); ++i) {
            boolean started;
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            boolean bl = started = sid.stepname != null && sid.stepname.equalsIgnoreCase(sname) && sid.copy == copy;
            if (!started) continue;
            return true;
        }
        return false;
    }

    public void stopAll() {
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            BaseStep rt = (BaseStep)((Object)sid.step);
            rt.stopAll();
            StepInterface si = (StepInterface)((Object)rt);
            si.stopRunning();
        }
    }

    public int nrSteps() {
        if (this.steps == null) {
            return 0;
        }
        return this.steps.size();
    }

    public int nrActiveSteps() {
        if (this.steps == null) {
            return 0;
        }
        int nr = 0;
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            if (!sid.step.isAlive()) continue;
            ++nr;
        }
        return nr;
    }

    public BaseStep getRunThread(int i) {
        if (this.steps == null) {
            return null;
        }
        StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
        return (BaseStep)((Object)sid.step);
    }

    public BaseStep getRunThread(String name, int copy) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            BaseStep rt = (BaseStep)((Object)sid.step);
            if (!rt.getStepname().equalsIgnoreCase(name) || rt.getCopy() != copy) continue;
            return rt;
        }
        return null;
    }

    public void setThreadsOnRowSets() {
        for (int i = 0; i < this.rowsets.size(); ++i) {
            RowSet rs = (RowSet)this.rowsets.get(i);
            BaseStep from = this.getRunThread(rs.getOriginStepName(), rs.getOriginStepCopy());
            BaseStep to = this.getRunThread(rs.getDestinationStepName(), rs.getDestinationStepCopy());
            rs.setThreadFromTo(from, to);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beginProcessing() throws ETLTransException {
        try {
            this.currentDate = new Date();
            this.logDate = new Date();
            this.startDate = Const.MIN_DATE;
            this.endDate = this.currentDate;
            Database ldb = null;
            try {
                Date maxdesired;
                DatabaseMeta logcon = this.transMeta.getLogConnection();
                if (logcon != null) {
                    Value last;
                    ldb = new Database(logcon);
                    this.log.logDetailed(this.toString(), "Opening log connection [" + this.transMeta.getLogConnection() + "]");
                    ldb.connect();
                    Row lastr = ldb.getLastLogDate(this.transMeta.getLogTable(), this.transMeta.getName(), false, "end");
                    if (lastr != null && lastr.size() > 0 && (last = lastr.getValue(0)) != null && !last.isNull()) {
                        this.startDate = last.getDate();
                        this.log.logDetailed(this.toString(), "Start date found from previous log entry: " + this.startDate);
                    }
                    if (this.transMeta.getMaxDateConnection() != null && this.transMeta.getMaxDateTable() != null && this.transMeta.getMaxDateTable().length() > 0 && this.transMeta.getMaxDateField() != null && this.transMeta.getMaxDateField().length() > 0) {
                        this.log.logDetailed(this.toString(), "Looking for maxdate connection: [" + this.transMeta.getMaxDateConnection() + "]");
                        DatabaseMeta maxcon = this.transMeta.getMaxDateConnection();
                        if (maxcon == null) throw new ETLTransException("Maximum date connection [" + this.transMeta.getMaxDateConnection() + "] couldn't be found!");
                        Database maxdb = new Database(maxcon);
                        try {
                            this.log.logDetailed(this.toString(), "Opening maximum date connection...");
                            maxdb.connect();
                            String sql = "SELECT MAX(" + this.transMeta.getMaxDateField() + ") FROM " + this.transMeta.getMaxDateTable();
                            Row r1 = maxdb.getOneRow(sql);
                            if (r1 != null) {
                                Value maxvalue = r1.getValue(0);
                                if (maxvalue != null && !maxvalue.isNull() && maxvalue.getDate() != null) {
                                    this.log.logDetailed(this.toString(), "Last date found on the maxDate connection: " + r1);
                                    this.endDate.setTime((long)((double)maxvalue.getDate().getTime() + this.transMeta.getMaxDateOffset() * 1000.0));
                                }
                            } else {
                                this.log.logDetailed(this.toString(), "No last date found on the maxDate connection!");
                            }
                        }
                        catch (ETLException e) {
                            throw new ETLTransException("Error connecting to database [" + this.transMeta.getMaxDateConnection() + "]", e);
                        }
                        finally {
                            maxdb.disconnect();
                        }
                    }
                    if (this.transMeta.dependencyCount() > 0) {
                        Value dep;
                        this.log.logDetailed(this.toString(), "Checking for max dependency date!");
                        this.depDate = Const.MIN_DATE;
                        Date maxdepdate = Const.MIN_DATE;
                        if (lastr != null && lastr.size() > 0 && (dep = lastr.getValue(1)) != null && !dep.isNull()) {
                            maxdepdate = dep.getDate();
                            this.depDate = dep.getDate();
                        }
                        for (int i = 0; i < this.transMeta.dependencyCount(); ++i) {
                            TransDependency td = this.transMeta.getDependency(i);
                            DatabaseMeta depcon = td.getDatabase();
                            if (depcon == null) throw new ETLTransException("Connection [" + td.getDatabase() + "] couldn't be found!");
                            Database depdb = new Database(depcon);
                            try {
                                depdb.connect();
                                String sql = "SELECT MAX(" + td.getFieldname() + ") FROM " + td.getTablename();
                                Row r1 = depdb.getOneRow(sql);
                                if (r1 == null) throw new ETLTransException("Unable to get dependency info from [" + td.getDatabase().getName() + "." + td.getTablename() + "." + td.getFieldname() + "]");
                                Value maxvalue = r1.getValue(0);
                                if (maxvalue == null || maxvalue.isNull() || maxvalue.getDate() == null) throw new ETLTransException("Unable to get dependency info from [" + td.getDatabase().getName() + "." + td.getTablename() + "." + td.getFieldname() + "]");
                                this.log.logDetailed(this.toString(), "found date from table " + td.getTablename() + "." + td.getFieldname() + " = " + maxvalue.toString());
                                if (maxvalue.getDate().getTime() > maxdepdate.getTime()) {
                                    maxdepdate = maxvalue.getDate();
                                }
                            }
                            catch (ETLException e) {
                                throw new ETLTransException("Error in database [" + td.getDatabase() + "]", e);
                            }
                            finally {
                                depdb.disconnect();
                            }
                            this.log.logDetailed(this.toString(), "maxdepdate = " + new Value("maxdepdate", maxdepdate).toString());
                        }
                        if (maxdepdate.getTime() > this.depDate.getTime()) {
                            this.depDate = maxdepdate;
                            this.startDate = Const.MIN_DATE;
                        }
                    } else {
                        this.depDate = this.currentDate;
                    }
                    Value id_batch = new Value("ID_BATCH", 1L);
                    if (this.transMeta.isBatchIdUsed()) {
                        ldb.getNextValue(this.transMeta, this.transMeta.getLogTable(), id_batch);
                        this.transMeta.setBatchId(id_batch.getInteger());
                    }
                }
                if (this.transMeta.getMaxDateDifference() > 0.0 && this.startDate.getTime() > Const.MIN_DATE.getTime() && this.endDate.compareTo(maxdesired = new Date(this.startDate.getTime() + (long)this.transMeta.getMaxDateDifference() * 1000L)) > 0) {
                    this.endDate = maxdesired;
                }
                if (logcon == null || this.transMeta.getLogTable() == null || this.transMeta.getName() == null) return;
                ldb.writeLogRecord(this.transMeta.getLogTable(), this.transMeta.isBatchIdUsed(), this.transMeta.getBatchId(), false, this.transMeta.getName(), "start", 0L, 0L, 0L, 0L, 0L, 0L, this.startDate, this.endDate, this.logDate, this.depDate, null);
                return;
            }
            catch (ETLException e) {
                throw new ETLTransException("Error writing log record to table [" + this.transMeta.getLogTable() + "]", e);
            }
            finally {
                if (ldb != null) {
                    ldb.disconnect();
                }
            }
        }
        catch (ETLException e) {
            throw new ETLTransException("Unable to begin processing transformation", e);
        }
    }

    public Result getResult() {
        if (this.steps == null) {
            return null;
        }
        Result result = new Result();
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            BaseStep rt = (BaseStep)((Object)sid.step);
            result.setNrErrors(result.getNrErrors() + sid.step.getErrors());
            if (this.transMeta.getReadStep() != null && rt.getStepname().equals(this.transMeta.getReadStep().getName())) {
                result.setNrLinesRead(result.getNrLinesRead() + rt.linesRead);
            }
            if (this.transMeta.getInputStep() != null && rt.getStepname().equals(this.transMeta.getInputStep().getName())) {
                result.setNrLinesInput(result.getNrLinesInput() + rt.linesInput);
            }
            if (this.transMeta.getWriteStep() != null && rt.getStepname().equals(this.transMeta.getWriteStep().getName())) {
                result.setNrLinesWritten(result.getNrLinesWritten() + rt.linesWritten);
            }
            if (this.transMeta.getOutputStep() != null && rt.getStepname().equals(this.transMeta.getOutputStep().getName())) {
                result.setNrLinesOutput(result.getNrLinesOutput() + rt.linesOutput);
            }
            if (this.transMeta.getUpdateStep() == null || !rt.getStepname().equals(this.transMeta.getUpdateStep().getName())) continue;
            result.setNrLinesUpdated(result.getNrLinesUpdated() + rt.linesUpdated);
        }
        result.rows = this.transMeta.getResultRows();
        return result;
    }

    public boolean endProcessing(String status) throws ETLException {
        DatabaseMeta logcon;
        if (this.preview) {
            return true;
        }
        Result result = this.getResult();
        this.logDate = new Date();
        String log_string = null;
        if (this.transMeta.isLogfieldUsed()) {
            log_string = this.log.getString();
            log_string = log_string + Const.CR + "END";
            this.log.setString("");
            this.log.endStringCapture();
        }
        if ((logcon = this.transMeta.getLogConnection()) != null) {
            Database ldb = new Database(logcon);
            try {
                ldb.connect();
                ldb.writeLogRecord(this.transMeta.getLogTable(), this.transMeta.isBatchIdUsed(), this.transMeta.getBatchId(), false, this.transMeta.getName(), status, result.getNrLinesRead(), result.getNrLinesWritten(), result.getNrLinesUpdated(), result.getNrLinesInput() + result.getNrFilesRetrieved(), result.getNrLinesOutput(), result.getNrErrors(), this.startDate, this.endDate, this.logDate, this.depDate, log_string);
            }
            catch (Exception e) {
                throw new ETLException("Error writing log record to table [" + this.transMeta.getLogTable() + "]", e);
            }
            finally {
                ldb.disconnect();
            }
        }
        return true;
    }

    public boolean previewComplete() {
        if (this.steps == null) {
            return true;
        }
        for (int i = 0; i < this.nrSteps(); ++i) {
            BaseStep rt = this.getRunThread(i);
            if (rt.previewSize <= 0 || !rt.isAlive() || rt.previewBuffer.size() >= rt.previewSize) continue;
            return false;
        }
        return true;
    }

    public void setSourceRows(List rows) {
        this.transMeta.setSourceRows(rows);
    }

    public BaseStep findRunThread(String name) {
        if (this.steps == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi sid = (StepMetaDataCombi)this.steps.get(i);
            BaseStep rt = (BaseStep)((Object)sid.step);
            if (!rt.getStepname().equalsIgnoreCase(name)) continue;
            return rt;
        }
        return null;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public LogWriter getLog() {
        return this.log;
    }

    public void setLog(LogWriter log) {
        this.log = log;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }

    public boolean isMonitored() {
        return this.monitored;
    }

    public void setMonitored(boolean monitored) {
        this.monitored = monitored;
    }

    public int[] getPreview_sizes() {
        return this.preview_sizes;
    }

    public void setPreview_sizes(int[] preview_sizes) {
        this.preview_sizes = preview_sizes;
    }

    public String[] getPreview_steps() {
        return this.preview_steps;
    }

    public void setPreview_steps(String[] preview_steps) {
        this.preview_steps = preview_steps;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public Date getDepDate() {
        return this.depDate;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public ArrayList getRowsets() {
        return this.rowsets;
    }

    public ArrayList getSteps() {
        return this.steps;
    }

    public String toString() {
        if (this.transMeta == null || this.transMeta.getName() == null) {
            return this.getClass().getName();
        }
        return this.transMeta.getName();
    }

    public ArrayList getPreviewRows(String stepname, int copyNr) {
        BaseStep baseStep = this.getRunThread(stepname, copyNr);
        if (baseStep != null) {
            return baseStep.previewBuffer;
        }
        return null;
    }

    public MappingInput findMappingInput() {
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi smdc = (StepMetaDataCombi)this.steps.get(i);
            StepInterface step = smdc.step;
            if (!step.getStepID().equalsIgnoreCase("MappingInput")) continue;
            return (MappingInput)step;
        }
        return null;
    }

    public MappingOutput findMappingOutput() {
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMetaDataCombi smdc = (StepMetaDataCombi)this.steps.get(i);
            StepInterface step = smdc.step;
            if (!step.getStepID().equalsIgnoreCase("MappingOutput")) continue;
            return (MappingOutput)step;
        }
        return null;
    }

    public class StepMetaDataCombi {
        public String stepname;
        public int copy;
        public StepInterface step;
        public StepMetaInterface meta;
        public StepDataInterface data;
    }
}

