/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.base.RowSet;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepLoaderException;
import com.kingdee.bos.ctrl.etl.transformation.StepLoader;
import com.kingdee.bos.ctrl.etl.transformation.StepPlugin;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.RowListener;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.addsequence.AddSequenceMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.aggregaterows.AggregateRowsMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.calculator.CalculatorMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.combinationlookup.CombinationLookupMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.constant.ConstantMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.databasejoin.DatabaseJoinMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.databaselookup.DatabaseLookupMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.dbproc.DBProcMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.denormaliser.DenormaliserMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.dimensionlookup.DimensionLookupMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.dummytrans.DummyTransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.excelinput.ExcelInputMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.fieldsplitter.FieldSplitterMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.filterrows.FilterRowsMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.flattener.FlattenerMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.groupby.GroupByMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.insertupdate.InsertUpdateMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.joinrows.JoinRowsMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.mapping.MappingMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.mappinginput.MappingInputMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.mappingoutput.MappingOutputMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.mergerows.MergeRowsMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.normaliser.NormaliserMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.nullif.NullIfMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.rowgenerator.RowGeneratorMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.rowsfromresult.RowsFromResultMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.rowstoresult.RowsToResultMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.scriptvalues.ScriptValuesMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.selectvalues.SelectValuesMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.sortrows.SortRowsMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.sql.ExecSQLMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.streamlookup.StreamLookupMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.systemdata.SystemDataMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.tableinput.TableInputMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.tableoutput.TableOutputMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileinput.TextFileInputMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileoutput.TextFileOutputMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.uniquerows.UniqueRowsMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.update.UpdateMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.xmlinput.XMLInputMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.xmloutput.XMLOutputMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class BaseStep
extends Thread {
    public static final Class[] type_classname = new Class[]{null, TableInputMeta.class, TableOutputMeta.class, SelectValuesMeta.class, SortRowsMeta.class, DummyTransMeta.class, InsertUpdateMeta.class, UpdateMeta.class, GroupByMeta.class, RowsToResultMeta.class, ExecSQLMeta.class, MappingMeta.class, MappingInputMeta.class, MappingOutputMeta.class, CalculatorMeta.class, ScriptValuesMeta.class, AddSequenceMeta.class, AggregateRowsMeta.class, DimensionLookupMeta.class, ConstantMeta.class, DatabaseLookupMeta.class, DatabaseJoinMeta.class, DBProcMeta.class, FilterRowsMeta.class, JoinRowsMeta.class, MergeRowsMeta.class, CombinationLookupMeta.class, ExcelInputMeta.class, TextFileInputMeta.class, TextFileOutputMeta.class, FieldSplitterMeta.class, StreamLookupMeta.class, SystemDataMeta.class, RowGeneratorMeta.class, NullIfMeta.class, RowsFromResultMeta.class, UniqueRowsMeta.class, XMLInputMeta.class, XMLOutputMeta.class, FlattenerMeta.class, NormaliserMeta.class, DenormaliserMeta.class};
    public static final String[] type_desc = new String[]{null, "TableInput", "TableOutput", "SelectValues", "SortRows", "Dummy", "InsertUpdate", "Update", "GroupBy", "RowsToResult", "ExecSQL", "Mapping", "MappingInput", "MappingOutput", "Calculator", "ScriptValue", "Sequence", "AggregateRows", "DimensionLookup", "Constant", "DBLookup", "DBJoin", "DBProc", "FilterRows", "JoinRows", "MergeRows", "CombinationLookup", "ExcelInput", "TextFileInput", "TextFileOutput", "FieldSplitter", "StreamLookup", "SystemInfo", "RowGenerator", "NullIf", "RowsFromResult", "Unique", "XMLInput", "XMLOutput", "Flattener", "Normaliser", "Denormaliser"};
    public static final String[] type_long_desc = new String[]{null, "Table input", "Table output", "Select values", "Sort rows", "Dummy (do nothing)", "Insert / Update", "Update", "Group by", "Copy rows to result", "Execute SQL script", "Mapping (sub-transformation)", "Mapping input specification", "Mapping output specification", "Calculator", "Java Script Value", "Add sequence", "Aggregate Rows", "Dimension update/lookup", "Add constants", "Database lookup", "Database join", "Call DB Procedure", "Filter rows", "Join Rows (cartesian product)", "Merge Rows", "Combination update/lookup", "Excel Input", "Text file input", "Text file output", "Split Fields", "Stream lookup", "Get System Info", "Generate Rows", "Null if...", "Get rows from result", "Unique rows", "XML Input", "XML Output", "Row flattener", "Row Normaliser", "Row denormaliser"};
    public static final String[] type_tooltip_desc = new String[]{null, "Read information from a database table.", "Write information to a database table", "Select or remove fields in a row." + Const.CR + "Optionally, set the field meta-data: type, length and precision.", "Sort rows based upon field values (ascending or descending)", "This step type doesn't do anything." + Const.CR + "It's useful however when testing things or in certain situations where you want to split streams.", "Update or insert rows in a database based upon keys.", "Update data in a database table based upon keys", "Builds aggregates in a group by fashion." + Const.CR + "This works only on a sorted input." + Const.CR + "If the input is not sorted, only double consecutive rows are handled correctly.", "Use this step to write rows to the executing job." + Const.CR + "The information will then be passed to the next entry in this job.", "Execute an SQL script, optionally parameterized using input rows", "Run a mapping (sub-transformation), use MappingInput and MappingOutput to specify the fields interface", "Specify the input interface of a mapping", "Specify the output interface of a mapping", "Create new fields by performing simple calculations", "Create java scripts to calculate new fields, alter existing ones or manipulate a row.", "Get the next value from an sequence", "This step type allows you to aggregate rows." + Const.CR + "It can't do groupings.", "Update a slowly changing dimension in a data warehouse" + Const.CR + "Alternatively,look up information in this dimension.", "Add one or more constants to the input rows", "Look up values in a database using field values", "Execute a database query using stream values as parameters", "Get back information by calling a database procedure.", "Filter rows using simple equations", "This output of this step is the cartesian product of the input\tstreams." + Const.CR + "The number of rows is the multiplication of the number of rows in the input streams.", "Merge two streams of rows, sorted on a certain key. The two streams are compared and the equals, changed, deleted and new rows are flagged.", "Update a junk dimension in a data warehouse" + Const.CR + "Alternatively, look up information in this dimension." + Const.CR + "The primary key of a junk dimension are all the fields.", "Read data from a Microsoft Excel Workbook. This works with Excel sheets of Excel 95,97 and 2000.", "Read data from a text file in several formats." + Const.CR + "This data can then be passed on to the next step(s)...", "Write rows to a text file.", "When you want to split a single field into more then one, use this step type.", "Look up values coming from another stream in the transformation.", "Get information from the system like system date, arguments, etc.", "Generate a number of empty or equal rows.", "Sets a field value to null if it is equal to a constant value", "This allows you to read rows from a previous entry in a job.", "Remove double rows and leave only unique occurences." + Const.CR + "This works only on a sorted input." + Const.CR + "If the input is not sorted, only double consecutive rows are handled correctly.", "Read data from an XML file", "Wite data to an XML file", "Flattens consequetive rows based on the order in which they appear in the input stream", "Denormalises rows by looking up key-value pairs and by assigning them to new fields in the output rows." + Const.CR + "This method aggregates and needs the input rows to be sorted on the grouping fields", "De-normalised information can be normalised using this step type."};
    public static final String[] image_filename = new String[]{null, "TIP.png", "TOP.png", "SEL.png", "SRT.png", "DUM.png", "INU.png", "UPD.png", "GRP.png", "TCH.png", "SQL.png", "MAP.png", "MPI.png", "MPO.png", "CLC.png", "SCR.png", "SEQ.png", "AGG.png", "DIM.png", "CST.png", "DLU.png", "DBJ.png", "PRC.png", "FLT.png", "JRW.png", "MRG.png", "CMB.png", "XLI.png", "TFI.png", "TFO.png", "SPL.png", "SLU.png", "SYS.png", "GEN.png", "NUI.png", "FCH.png", "UNQ.png", "XIN.png", "XOU.png", "FLA.png", "NRM.png", "UNP.png"};
    public static final String[] category = new String[]{null, "Input", "Output", "Transform", "Transform", "Transform", "Output", "Output", "Transform", "Extra", "Extra", "Mapping", "Mapping", "Mapping", "Transform", "Transform", "Transform", "Transform", "Data Warehouse", "Transform", "Lookup", "Lookup", "Lookup", "Transform", "Transform", "Transform", "Data Warehouse", "Input", "Input", "Output", "Extra", "Lookup", "Input", "Input", "Extra", "Extra", "Transform", "Input", "Output", "Transform", "Transform", "Transform"};
    public static final String[] category_order = new String[]{"Input", "Output", "Lookup", "Transform", "Data Warehouse", "Extra", "Mapping", "Experimental"};
    private static final int MIN_PRIORITY = 1;
    private static final int LOW_PRIORITY = 3;
    private static final int NORMAL_PRIORITY = 5;
    private static final int HIGH_PRIORITY = 7;
    private static final int MAX_PRIORITY = 10;
    private TransMeta transMeta;
    private Trans trans;
    private StepMeta stepMeta;
    private String stepname;
    protected LogWriter log = LogWriter.getInstance();
    public String debug;
    public ArrayList previewBuffer;
    public int previewSize;
    public long linesRead;
    public long linesWritten;
    public long linesInput;
    public long linesOutput;
    public long linesUpdated;
    public long linesSkipped;
    public long get_sleeps;
    public long put_sleeps;
    private boolean distributed;
    private long errors;
    private StepMeta[] next;
    private StepMeta[] prev;
    private int in_handling;
    private int out_handling;
    protected List inputRowSets;
    protected List outputRowSets;
    public boolean stopped;
    public boolean waiting;
    public boolean init;
    private int stepcopy;
    private Date start_time;
    private Date stop_time;
    public boolean first;
    public boolean terminator;
    public List terminator_rows;
    private List rowListeners;

    public BaseStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        this.stepMeta = stepMeta;
        this.stepcopy += copyNr;
        this.transMeta = transMeta;
        this.trans = trans;
        this.first = true;
        this.stepname = stepMeta.getName();
        this.stopped = false;
        this.init = false;
        this.linesRead = 0L;
        this.linesWritten = 0L;
        this.linesUpdated = 0L;
        this.linesSkipped = 0L;
        this.get_sleeps = 0L;
        this.put_sleeps = 0L;
        this.inputRowSets = null;
        this.outputRowSets = null;
        this.next = null;
        this.terminator = stepMeta.hasTerminator();
        this.terminator_rows = this.terminator ? new ArrayList() : null;
        this.debug = "-";
        this.start_time = null;
        this.stop_time = null;
        this.distributed = stepMeta.distributes;
        if (this.distributed) {
            this.logDetailed("distribution activated");
        } else {
            this.logDetailed("distribution de-activated");
        }
        this.rowListeners = new ArrayList();
        this.dispatch();
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        sdi.setStatus(1);
        return true;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        sdi.setStatus(5);
    }

    public long getProcessed() {
        return this.linesRead;
    }

    public void setCopy(int copy) {
        this.stepcopy = copy;
    }

    public int getCopy() {
        return this.stepcopy;
    }

    public long getErrors() {
        return this.errors;
    }

    public void setErrors(long e) {
        this.errors = e;
    }

    public long getLinesInput() {
        return this.linesInput;
    }

    public long getLinesOutput() {
        return this.linesOutput;
    }

    public long getLinesRead() {
        return this.linesRead;
    }

    public long getLinesWritten() {
        return this.linesWritten;
    }

    public long getLinesUpdated() {
        return this.linesUpdated;
    }

    public String getStepname() {
        return this.stepname;
    }

    public void setStepname(String stepname) {
        this.stepname = stepname;
    }

    public String getStatus() {
        String retval = this.isAlive() ? "running" : (this.isInitialising() ? "init" : (this.isStopped() ? "stopped" : "finished"));
        return retval;
    }

    public StepMeta getStepMeta() {
        return this.stepMeta;
    }

    public void setStepMeta(StepMeta stepMeta) {
        this.stepMeta = stepMeta;
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public Trans getTrans() {
        return this.trans;
    }

    public synchronized void putRow(Row row) {
        block14: {
            block13: {
                int i;
                if (this.previewSize > 0 && this.previewBuffer.size() < this.previewSize) {
                    this.previewBuffer.add(new Row(row));
                }
                for (i = 0; i < this.rowListeners.size(); ++i) {
                    RowListener rowListener = (RowListener)this.rowListeners.get(i);
                    rowListener.rowWrittenEvent(row);
                }
                if (this.terminator && this.terminator_rows != null) {
                    this.terminator_rows.add(new Row(row));
                }
                if (this.outputRowSets.size() == 0) {
                    return;
                }
                for (i = 0; i < this.outputRowSets.size(); ++i) {
                    int sleeptime = this.transMeta.getSleepTimeFull();
                    RowSet rs = (RowSet)this.outputRowSets.get(i);
                    try {
                        rs.setPriorityFrom(this.calcPutPriority(rs));
                    }
                    catch (Exception e) {
                        this.logError("Error occured setting priorityFrom");
                        this.setErrors(1L);
                        this.stopAll();
                        return;
                    }
                    while (rs.isFull() && !this.stopped) {
                        try {
                            BaseStep.sleep(sleeptime);
                        }
                        catch (Exception e) {
                            this.logError("Interupted while trying to put a new row in a buffer: " + e.toString());
                            this.setErrors(1L);
                            this.stopAll();
                            return;
                        }
                        this.put_sleeps += (long)sleeptime;
                        if (sleeptime < 500) {
                            sleeptime = (int)((double)sleeptime * 1.2);
                            continue;
                        }
                        sleeptime = 500;
                    }
                }
                if (this.stopped) {
                    this.logDebug("Stopped while putting a row on the buffer");
                    this.stopAll();
                    return;
                }
                if (!this.distributed) break block13;
                RowSet rs = (RowSet)this.outputRowSets.get(this.out_handling);
                rs.putRow(row);
                ++this.linesWritten;
                if (this.outputRowSets.size() <= 1) break block14;
                ++this.out_handling;
                if (this.out_handling < this.outputRowSets.size()) break block14;
                this.out_handling = 0;
                break block14;
            }
            RowSet rs = (RowSet)this.outputRowSets.get(0);
            rs.putRow(row);
            ++this.linesWritten;
            for (int i = 1; i < this.outputRowSets.size(); ++i) {
                rs = (RowSet)this.outputRowSets.get(i);
                rs.putRow(new Row(row));
            }
        }
    }

    public synchronized void putRowTo(Row row, String to) throws ETLStepException {
        int output_rowset_nr = this.findOutputRowSetNumber(this.stepname, this.getCopy(), to, 0);
        if (output_rowset_nr < 0) {
            throw new ETLStepException("Unable to find rowset for target step [" + to + "]");
        }
        this.putRowTo(row, output_rowset_nr);
    }

    public synchronized void putRowTo(Row row, int output_rowset_nr) {
        if (this.previewSize > 0 && this.previewBuffer.size() < this.previewSize) {
            this.previewBuffer.add(new Row(row));
        }
        for (int i = 0; i < this.rowListeners.size(); ++i) {
            RowListener rowListener = (RowListener)this.rowListeners.get(i);
            rowListener.rowWrittenEvent(row);
        }
        if (this.terminator && this.terminator_rows != null) {
            this.terminator_rows.add(new Row(row));
        }
        if (this.outputRowSets.size() == 0) {
            return;
        }
        RowSet rs = (RowSet)this.outputRowSets.get(output_rowset_nr);
        int sleeptime = this.transMeta.getSleepTimeFull();
        while (rs.isFull() && !this.stopped) {
            try {
                BaseStep.sleep(sleeptime);
            }
            catch (Exception e) {
                this.logError("Interupted while trying to put a new row in a buffer: " + e.toString());
                this.setErrors(1L);
                this.stopAll();
                return;
            }
            this.put_sleeps += (long)sleeptime;
            if (sleeptime < 500) {
                sleeptime = (int)((double)sleeptime * 1.2);
                continue;
            }
            sleeptime = 500;
        }
        if (this.stopped) {
            this.logDebug("Stopped while putting a row on the buffer");
            this.stopAll();
            return;
        }
        rs.putRow(row);
        ++this.linesWritten;
    }

    private synchronized RowSet currentInputStream() {
        return (RowSet)this.inputRowSets.get(this.in_handling);
    }

    private synchronized void nextInputStream() {
        int streams = this.inputRowSets.size();
        if (streams == 0) {
            return;
        }
        ++this.in_handling;
        if (this.in_handling >= this.inputRowSets.size()) {
            this.in_handling = 0;
        }
    }

    public synchronized Row getRow() {
        RowSet in = this.currentInputStream();
        int switches = 0;
        int sleeptime = this.transMeta.getSleepTimeEmpty();
        while (in.isEmpty() && !this.stopped) {
            if (in.isEmpty() && in.isDone()) {
                this.inputRowSets.remove(this.in_handling);
                if (this.inputRowSets.size() == 0) {
                    return null;
                }
            }
            this.nextInputStream();
            in = this.currentInputStream();
            if (++switches < this.inputRowSets.size()) continue;
            switches = 0;
            try {
                BaseStep.sleep(0L, sleeptime);
            }
            catch (Exception e) {
                this.logError("Sleep interupted! Stopping: " + e.toString());
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            sleeptime = sleeptime < 5000 ? (int)((double)sleeptime * 1.2) : 5000;
            this.get_sleeps += (long)sleeptime;
        }
        if (this.stopped) {
            this.logDebug("Stopped looking for more rows.");
            this.stopAll();
            return null;
        }
        in.setPriorityTo(this.calcGetPriority(in));
        Row row = in.getRow();
        ++this.linesRead;
        for (int i = 0; i < this.rowListeners.size(); ++i) {
            RowListener rowListener = (RowListener)this.rowListeners.get(i);
            rowListener.rowReadEvent(row);
        }
        this.nextInputStream();
        return row;
    }

    public synchronized Row getRowFrom(String from) {
        int index = this.findInputRowSetNumber(from, 0, this.stepname, 0);
        if (index < 0) {
            return null;
        }
        return this.getRowFrom(index);
    }

    public synchronized Row getRowFrom(int input_rowset_nr) {
        int sleeptime = this.transMeta.getSleepTimeEmpty();
        RowSet in = (RowSet)this.inputRowSets.get(input_rowset_nr);
        while (in.isEmpty() && !in.isDone() && !this.stopped) {
            try {
                BaseStep.sleep(0L, sleeptime);
            }
            catch (Exception e) {
                this.logError("Sleep interupted while looking for more rows from step [" + in.getOriginStepName() + "] --> " + e.toString());
                this.setErrors(1L);
                this.stopAll();
                return null;
            }
            this.get_sleeps += (long)sleeptime;
        }
        if (this.stopped) {
            this.logError("Interupted while looking for more rows from step [" + in.getOriginStepName() + "]");
            this.stopAll();
            return null;
        }
        if (in.isEmpty() && in.isDone()) {
            this.inputRowSets.remove(input_rowset_nr);
            return null;
        }
        Row row = in.getRow();
        ++this.linesRead;
        for (int i = 0; i < this.rowListeners.size(); ++i) {
            RowListener rowListener = (RowListener)this.rowListeners.get(i);
            rowListener.rowWrittenEvent(row);
        }
        return row;
    }

    private synchronized int findInputRowSetNumber(String from, int fromcopy, String to, int tocopy) {
        for (int i = 0; i < this.inputRowSets.size(); ++i) {
            RowSet rs = (RowSet)this.inputRowSets.get(i);
            if (!rs.getOriginStepName().equalsIgnoreCase(from) || !rs.getDestinationStepName().equalsIgnoreCase(to) || rs.getOriginStepCopy() != fromcopy || rs.getDestinationStepCopy() != tocopy) continue;
            return i;
        }
        return -1;
    }

    private synchronized int findOutputRowSetNumber(String from, int fromcopy, String to, int tocopy) {
        for (int i = 0; i < this.outputRowSets.size(); ++i) {
            RowSet rs = (RowSet)this.outputRowSets.get(i);
            if (!rs.getOriginStepName().equalsIgnoreCase(from) || !rs.getDestinationStepName().equalsIgnoreCase(to) || rs.getOriginStepCopy() != fromcopy || rs.getDestinationStepCopy() != tocopy) continue;
            return i;
        }
        return -1;
    }

    public void setOutputDone() {
        this.logDebug("Signaling 'output done' to " + this.outputRowSets.size() + " output rowsets.");
        for (int i = 0; i < this.outputRowSets.size(); ++i) {
            RowSet rs = (RowSet)this.outputRowSets.get(i);
            rs.setDone();
        }
    }

    public void dispatch() {
        RowSet rs;
        int c;
        int nrcopies;
        int disptype;
        int nextcopies;
        int prevcopies;
        int i;
        if (this.transMeta == null) {
            return;
        }
        StepMeta stepMeta = this.transMeta.findStep(this.stepname);
        this.logDetailed("Starting allocation of buffers & new threads...");
        int nrinput = this.transMeta.findPrevStepCount(stepMeta, true);
        int nroutput = this.transMeta.findNextStepCount(stepMeta);
        this.inputRowSets = new ArrayList();
        this.outputRowSets = new ArrayList();
        this.prev = new StepMeta[nrinput];
        this.next = new StepMeta[nroutput];
        this.in_handling = 0;
        this.logDetailed("Step info: nrinput=" + nrinput + " nroutput=" + nroutput);
        for (i = 0; i < nrinput; ++i) {
            this.prev[i] = this.transMeta.findPrevStep(stepMeta, i, true);
            this.logDetailed("Got previous step from [" + this.stepname + "] #" + i + " --> " + this.prev[i].getName());
            prevcopies = this.prev[i].getCopies();
            nextcopies = stepMeta.getCopies();
            this.logDetailed("input rel is  " + prevcopies + ":" + nextcopies);
            if (prevcopies == 1 && nextcopies == 1) {
                disptype = 1;
                nrcopies = 1;
            } else if (prevcopies == 1 && nextcopies > 1) {
                disptype = 2;
                nrcopies = 1;
            } else if (prevcopies > 1 && nextcopies == 1) {
                disptype = 3;
                nrcopies = prevcopies;
            } else if (prevcopies == nextcopies) {
                disptype = 4;
                nrcopies = 1;
            } else {
                this.log.logError(this.toString(), "Only 1-1, 1-n, n-1 and n-n relationships are allowed!");
                this.log.logError(this.toString(), "This means you can't have x-y relationships!");
                this.setErrors(1L);
                this.stopAll();
                return;
            }
            for (c = 0; c < nrcopies; ++c) {
                rs = null;
                switch (disptype) {
                    case 1: {
                        rs = this.trans.findRowSet(this.prev[i].getName(), 0, this.stepname, 0);
                        break;
                    }
                    case 2: {
                        rs = this.trans.findRowSet(this.prev[i].getName(), 0, this.stepname, this.getCopy());
                        break;
                    }
                    case 3: {
                        rs = this.trans.findRowSet(this.prev[i].getName(), c, this.stepname, 0);
                        break;
                    }
                    case 4: {
                        rs = this.trans.findRowSet(this.prev[i].getName(), this.getCopy(), this.stepname, this.getCopy());
                    }
                }
                if (rs == null) {
                    this.logError("Unable to find input rowset!");
                    this.setErrors(1L);
                    this.stopAll();
                    return;
                }
                this.inputRowSets.add(rs);
                this.logDetailed("Found input rowset [" + rs.getName() + "]");
            }
        }
        for (i = 0; i < nroutput; ++i) {
            this.next[i] = this.transMeta.findNextStep(stepMeta, i);
            prevcopies = stepMeta.getCopies();
            nextcopies = this.next[i].getCopies();
            this.logDetailed("output rel. is  " + prevcopies + ":" + nextcopies);
            if (prevcopies == 1 && nextcopies == 1) {
                disptype = 1;
                nrcopies = 1;
            } else if (prevcopies == 1 && nextcopies > 1) {
                disptype = 2;
                nrcopies = nextcopies;
            } else if (prevcopies > 1 && nextcopies == 1) {
                disptype = 3;
                nrcopies = 1;
            } else if (prevcopies == nextcopies) {
                disptype = 4;
                nrcopies = 1;
            } else {
                this.log.logError(this.toString(), "Only 1-1, 1-n, n-1 and n-n relationships are allowed!");
                this.log.logError(this.toString(), "This means you can't have x-y relationships!");
                this.setErrors(1L);
                this.stopAll();
                return;
            }
            for (c = 0; c < nrcopies; ++c) {
                rs = null;
                switch (disptype) {
                    case 1: {
                        rs = this.trans.findRowSet(this.stepname, 0, this.next[i].getName(), 0);
                        break;
                    }
                    case 2: {
                        rs = this.trans.findRowSet(this.stepname, 0, this.next[i].getName(), c);
                        break;
                    }
                    case 3: {
                        rs = this.trans.findRowSet(this.stepname, this.getCopy(), this.next[i].getName(), 0);
                        break;
                    }
                    case 4: {
                        rs = this.trans.findRowSet(this.stepname, this.getCopy(), this.next[i].getName(), this.getCopy());
                    }
                }
                if (rs == null) {
                    this.logError("Unable to find output rowset!");
                    this.setErrors(1L);
                    this.stopAll();
                    return;
                }
                this.outputRowSets.add(rs);
                this.logDetailed("Found output rowset [" + rs.getName() + "]");
            }
        }
        this.logDetailed("Finished dispatching");
    }

    public void logMinimal(String s) {
        this.log.println(2, this.stepname + "." + this.stepcopy, s);
    }

    public void logBasic(String s) {
        this.log.println(3, this.stepname + "." + this.stepcopy, s);
    }

    public void logError(String s) {
        this.log.println(1, this.stepname + "." + this.stepcopy, s);
    }

    public void logDetailed(String s) {
        this.log.println(4, this.stepname + "." + this.stepcopy, s);
    }

    public void logDebug(String s) {
        this.log.println(5, this.stepname + "." + this.stepcopy, s);
    }

    public void logRowlevel(String s) {
        this.log.println(6, this.stepname + "." + this.stepcopy, s);
    }

    public int getNextClassNr() {
        int ret = this.trans.class_nr++;
        return ret;
    }

    public boolean outputIsDone() {
        int nrstopped = 0;
        for (int i = 0; i < this.outputRowSets.size(); ++i) {
            RowSet rs = (RowSet)this.outputRowSets.get(i);
            if (!rs.isDone()) continue;
            ++nrstopped;
        }
        return nrstopped >= this.outputRowSets.size();
    }

    public void stopAll() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isInitialising() {
        return this.init;
    }

    public void markStart() {
        Calendar cal = Calendar.getInstance();
        this.start_time = cal.getTime();
    }

    public void markStop() {
        Calendar cal = Calendar.getInstance();
        this.stop_time = cal.getTime();
    }

    public long getRuntime() {
        long lapsed;
        if (this.start_time != null && this.stop_time == null) {
            Calendar cal = Calendar.getInstance();
            long now = cal.getTimeInMillis();
            long st = this.start_time.getTime();
            lapsed = now - st;
        } else {
            lapsed = this.start_time != null && this.stop_time != null ? this.stop_time.getTime() - this.start_time.getTime() : 0L;
        }
        return lapsed;
    }

    public Row buildLog(String sname, int copynr, long lines_read, long lines_written, long lines_updated, long lines_skipped, long errors, Value start_date, Value end_date) {
        Row r = new Row();
        r.addValue(new Value("stepname", sname));
        r.addValue(new Value("copy", (double)copynr));
        r.addValue(new Value("lines_read", (double)lines_read));
        r.addValue(new Value("lines_written", (double)lines_written));
        r.addValue(new Value("lines_updated", (double)lines_updated));
        r.addValue(new Value("lines_skipped", (double)lines_skipped));
        r.addValue(new Value("errors", (double)errors));
        r.addValue(start_date);
        r.addValue(end_date);
        return r;
    }

    public static final Row getLogFields(String comm) {
        Row r = new Row();
        Value sname = new Value("stepname", "");
        sname.setLength(256);
        r.addValue(sname);
        r.addValue(new Value("copy", 0.0));
        r.addValue(new Value("lines_read", 0.0));
        r.addValue(new Value("lines_written", 0.0));
        r.addValue(new Value("lines_updated", 0.0));
        r.addValue(new Value("lines_skipped", 0.0));
        r.addValue(new Value("errors", 0.0));
        r.addValue(new Value("start_date", Const.MIN_DATE));
        r.addValue(new Value("end_date", Const.MAX_DATE));
        for (int i = 0; i < r.size(); ++i) {
            r.getValue(i).setOrigin(comm);
        }
        return r;
    }

    @Override
    public String toString() {
        return this.stepname + "." + this.getCopy();
    }

    private int calcPutPriority(RowSet rs) {
        if ((double)rs.size() > (double)this.transMeta.getSizeRowset() * 0.95) {
            return 1;
        }
        if ((double)rs.size() > (double)this.transMeta.getSizeRowset() * 0.75) {
            return 3;
        }
        if ((double)rs.size() > (double)this.transMeta.getSizeRowset() * 0.5) {
            return 5;
        }
        if ((double)rs.size() > (double)this.transMeta.getSizeRowset() * 0.25) {
            return 7;
        }
        return 10;
    }

    private int calcGetPriority(RowSet rs) {
        if ((double)rs.size() > (double)this.transMeta.getSizeRowset() * 0.95) {
            return 10;
        }
        if ((double)rs.size() > (double)this.transMeta.getSizeRowset() * 0.75) {
            return 7;
        }
        if ((double)rs.size() > (double)this.transMeta.getSizeRowset() * 0.5) {
            return 5;
        }
        if ((double)rs.size() > (double)this.transMeta.getSizeRowset() * 0.25) {
            return 3;
        }
        return 1;
    }

    public int rowsetOutputSize() {
        int size = 0;
        for (int i = 0; i < this.outputRowSets.size(); ++i) {
            size += ((RowSet)this.outputRowSets.get(i)).size();
        }
        return size;
    }

    public int rowsetInputSize() {
        int size = 0;
        for (int i = 0; i < this.inputRowSets.size(); ++i) {
            size += ((RowSet)this.inputRowSets.get(i)).size();
        }
        return size;
    }

    public static final StepMetaInterface getStepInfo(StepPlugin stepplugin, StepLoader steploader) throws ETLStepLoaderException {
        return steploader.getStepClass(stepplugin);
    }

    public static final String getIconFilename(int steptype) {
        return image_filename[steptype];
    }

    public void stopRunning() {
    }

    public void logSummary() {
        this.logBasic("Finished processing (I=" + this.linesInput + ", O=" + this.linesOutput + ", R=" + this.linesRead + ", W=" + this.linesWritten + ", U=" + this.linesUpdated + ", E=" + this.getErrors());
    }

    public String getStepID() {
        if (this.stepMeta != null) {
            return this.stepMeta.getStepID();
        }
        return null;
    }

    public List getInputRowSets() {
        return this.inputRowSets;
    }

    public void setInputRowSets(List inputRowSets) {
        this.inputRowSets = inputRowSets;
    }

    public List getOutputRowSets() {
        return this.outputRowSets;
    }

    public void setOutputRowSets(List outputRowSets) {
        this.outputRowSets = outputRowSets;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    public void addRowListener(RowListener rowListener) {
        this.rowListeners.add(rowListener);
    }

    public void removeRowListener(RowListener rowListener) {
        this.rowListeners.remove(rowListener);
    }

    public List getRowListeners() {
        return this.rowListeners;
    }
}

