/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.dimensionlookup;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.dimensionlookup.DimensionLookupData;
import com.kingdee.bos.ctrl.etl.transformation.step.dimensionlookup.DimensionLookupMeta;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Calendar;
import java.util.Date;

public class DimensionLookup
extends BaseStep
implements StepInterface {
    private DimensionLookupMeta meta;
    private DimensionLookupData data;

    public DimensionLookup(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void lookupValues(Row row) throws ETLException {
        Value technicalKey;
        Value val_version;
        Row lu = new Row();
        Value val_date = null;
        Value val_datfrom = null;
        Value val_datto = null;
        this.debug = "Start of lookupValues()";
        if (this.first) {
            int i;
            this.debug = "init of lookupValues()";
            this.first = false;
            if (this.getCopy() == 0) {
                this.data.db.checkDimZero(this.meta.getTableName(), this.meta.getKeyField(), this.meta.getVersionField(), this.meta.isAutoIncrement());
            }
            this.debug = "first: setDimLookup()";
            this.data.db.setDimLookup(this.meta.getTableName(), this.meta.getKeyLookup(), this.meta.getKeyField(), this.meta.getVersionField(), this.meta.getFieldLookup(), this.meta.getFieldStream(), this.meta.getDateFrom(), this.meta.getDateTo());
            this.debug = "first: lookup key nrs";
            this.data.keynrs = new int[this.meta.getKeyStream().length];
            for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                this.data.keynrs[i] = row.searchValueIndex(this.meta.getKeyStream()[i]);
                if (this.data.keynrs[i] >= 0) continue;
                throw new ETLStepException("Key field [" + this.meta.getKeyStream()[i] + "] couldn't be found!");
            }
            this.debug = "first: lookup value nrs";
            if (this.meta.isUpdate()) {
                this.data.fieldnrs = new int[this.meta.getFieldStream().length];
                for (i = 0; this.meta.getFieldStream() != null && i < this.meta.getFieldStream().length; ++i) {
                    this.data.fieldnrs[i] = row.searchValueIndex(this.meta.getFieldStream()[i]);
                }
            }
            this.data.datefieldnr = this.meta.getDateField() != null && this.meta.getDateField().length() > 0 ? row.searchValueIndex(this.meta.getDateField()) : -1;
            this.debug = "first: notfound field";
            this.meta.setNotFound(new Value(this.meta.getKeyField(), (double)this.meta.getDatabaseMeta().getNotFoundTK(this.meta.isAutoIncrement())));
            if (this.meta.getKeyRename() != null && this.meta.getKeyRename().length() > 0) {
                this.meta.getNotFound().setName(this.meta.getKeyRename());
            }
            if (this.meta.getDateField() != null && this.data.datefieldnr >= 0) {
                this.data.val_datnow = row.getValue(this.data.datefieldnr);
            } else {
                Calendar cal = Calendar.getInstance();
                this.data.val_datnow = new Value("MIN", new Date(cal.getTimeInMillis()));
            }
            this.debug = "first: end";
        }
        if (this.meta.getDateField() != null && this.data.datefieldnr >= 0) {
            this.data.val_datnow = row.getValue(this.data.datefieldnr);
        }
        for (int i = 0; i < this.meta.getKeyStream().length; ++i) {
            try {
                lu.addValue(row.getValue(this.data.keynrs[i]));
                continue;
            }
            catch (Exception e) {
                throw new ETLStepException("Error detected getting key #" + i + ", pos=" + this.data.keynrs[i] + "/" + row.size() + " from row: " + row.toString());
            }
        }
        val_date = this.data.datefieldnr >= 0 ? row.getValue(this.data.datefieldnr) : this.data.val_datnow;
        this.logDebug("lookup row : " + lu.toString() + " val_date=" + val_date.toString());
        this.debug = "setDimValues()";
        this.data.db.setDimValues(lu, val_date);
        this.debug = "getLookup()";
        Row add = this.data.db.getLookup();
        if (!this.meta.isUpdate()) {
            this.debug = "lookup";
            if (add == null) {
                this.debug = "lookup: nothing found";
                add = new Row();
                add.addValue(this.meta.getNotFound());
                for (int i = 0; i < this.meta.getFieldStream().length; ++i) {
                    this.debug = "lookup: fieldstream #" + i;
                    if (this.meta.getFieldStream()[i] == null) continue;
                    this.debug = "lookup: new value #" + i;
                    Value v = this.meta.getFieldStream()[i] != null ? new Value(this.meta.getFieldStream()[i], this.meta.getFieldUpdate()[i]) : new Value(this.meta.getFieldLookup()[i], this.meta.getFieldUpdate()[i]);
                    v.setNull();
                    add.addValue(v);
                }
            } else {
                add.removeValue(1);
                if (this.meta.getKeyRename() != null && this.meta.getKeyRename().length() > 0) {
                    add.getValue(0).setName(this.meta.getKeyRename());
                }
            }
        } else if (add == null) {
            this.debug = "insert";
            this.logRowlevel("No dimension entry found: INSERT (lookup= " + lu + ")");
            val_datfrom = new Value("MIN", this.meta.getMinDate());
            val_datto = new Value("MAX", this.meta.getMaxDate());
            val_version = new Value(this.meta.getVersionField(), 1L);
            boolean autoinc = false;
            if (this.meta.getDatabaseMeta().supportsAutoinc() && this.meta.isAutoIncrement()) {
                autoinc = true;
                technicalKey = new Value(this.meta.getKeyField(), 0L);
            } else if (this.meta.getDatabaseMeta().supportsSequences() && this.meta.getSequenceName() != null && this.meta.getSequenceName().length() > 0) {
                technicalKey = this.data.db.getNextSequenceValue(this.meta.getSequenceName(), this.meta.getKeyField());
                if (technicalKey != null) {
                    this.logRowlevel("Found next sequence value: " + technicalKey.toString());
                }
            } else {
                technicalKey = new Value(this.meta.getKeyField(), 0L);
                this.data.db.getNextValue(this.getTransMeta(), this.meta.getTableName(), technicalKey);
            }
            this.debug = "insert row";
            this.data.db.dimInsert(row, this.meta.getTableName(), true, autoinc ? null : this.meta.getKeyField(), autoinc, technicalKey, this.meta.getVersionField(), val_version, this.meta.getDateFrom(), val_datfrom, this.meta.getDateTo(), val_datto, this.meta.getFieldLookup(), this.data.fieldnrs, this.meta.getKeyStream(), this.meta.getKeyLookup(), this.data.keynrs);
            ++this.linesOutput;
            add = new Row();
            if (this.meta.getKeyRename() != null && this.meta.getKeyRename().length() > 0) {
                technicalKey.setName(this.meta.getKeyRename());
            }
            add.addValue(technicalKey);
            this.logRowlevel("added dimension entry with key=" + add.toString());
        } else {
            this.logRowlevel("Dimension entry found : " + add);
            this.debug = "update";
            technicalKey = add.getValue(0);
            val_version = add.getValue(1);
            val_datfrom = new Value("MIN", this.meta.getMinDate());
            val_datto = new Value("MAX", this.meta.getMaxDate());
            boolean insert = false;
            boolean identical = true;
            boolean punch = false;
            for (int i = 0; i < this.meta.getFieldStream().length; ++i) {
                Value v2;
                Value v1 = row.getValue(this.data.fieldnrs[i]);
                int cmp = v1.compare(v2 = add.getValue(i + 2));
                if (cmp != 0) {
                    identical = false;
                }
                if (cmp != 0 && this.meta.getFieldUpdate()[i] == 0) {
                    insert = true;
                }
                if (cmp != 0 && this.meta.getFieldUpdate()[i] == 2) {
                    punch = true;
                }
                this.logRowlevel("Comparing " + v1 + " and " + v2 + " (cmp=" + cmp + ") --> identical=" + identical + ", insert=" + insert + ", punch=" + punch);
            }
            if (!insert) {
                if (!identical) {
                    this.logRowlevel("UPDATE row with values: " + row);
                    this.debug = "update row";
                    this.data.db.dimUpdate(row, this.meta.getTableName(), this.meta.getFieldLookup(), this.data.fieldnrs, this.meta.getKeyField(), technicalKey);
                    ++this.linesUpdated;
                } else {
                    this.logRowlevel("SKIP line: identical!");
                    ++this.linesSkipped;
                }
            } else {
                this.logRowlevel("INSERT new version: val_key=" + technicalKey.toString());
                val_datfrom = this.data.val_datnow;
                val_datto = new Value("MAX", this.meta.getMaxDate());
                boolean autoinc = false;
                if (this.meta.getDatabaseMeta().supportsAutoinc() && this.meta.isAutoIncrement()) {
                    autoinc = true;
                    technicalKey = new Value(this.meta.getKeyField(), 0.0);
                } else if (this.meta.getDatabaseMeta().supportsSequences() && this.meta.getSequenceName() != null && this.meta.getSequenceName().length() > 0) {
                    technicalKey = this.data.db.getNextSequenceValue(this.meta.getSequenceName(), this.meta.getKeyField());
                    if (technicalKey != null) {
                        this.logRowlevel("Found next sequence value: " + technicalKey.toString());
                    }
                } else {
                    technicalKey = new Value(this.meta.getKeyField(), 0L);
                    this.data.db.getNextValue(this.getTransMeta(), this.meta.getTableName(), technicalKey);
                }
                this.data.db.dimInsert(row, this.meta.getTableName(), false, this.meta.getKeyField(), autoinc, technicalKey, this.meta.getVersionField(), val_version, this.meta.getDateFrom(), val_datfrom, this.meta.getDateTo(), val_datto, this.meta.getFieldLookup(), this.data.fieldnrs, this.meta.getKeyStream(), this.meta.getKeyLookup(), this.data.keynrs);
                ++this.linesOutput;
            }
            if (punch) {
                this.data.db.dimPunchThrough(row, this.meta.getTableName(), this.meta.getFieldUpdate(), this.meta.getFieldLookup(), this.data.fieldnrs, this.meta.getKeyStream(), this.meta.getKeyLookup(), this.data.keynrs);
                ++this.linesUpdated;
            }
            add = new Row();
            if (this.meta.getKeyRename() != null && this.meta.getKeyRename().length() > 0) {
                technicalKey.setName(this.meta.getKeyRename());
            }
            add.addValue(technicalKey);
            this.logRowlevel("Technical key = " + technicalKey);
        }
        this.debug = "add values to row";
        this.logRowlevel("Values to add to row: " + add);
        for (int i = 0; i < add.size(); ++i) {
            row.addValue(add.getValue(i));
        }
        this.debug = "get date from date field, datefieldnr=" + this.data.datefieldnr;
        Value date = this.data.datefieldnr >= 0 ? row.getValue(this.data.datefieldnr) : new Value("date", new Date());
        this.debug = "check min date (min_date==null? " + (this.data.min_date == null) + ", date==null? " + (date == null) + "), datefieldnr=" + this.data.datefieldnr;
        if (this.data.min_date.compare(date) > 0) {
            this.data.min_date.setValue(date.getDate());
        }
        this.debug = "check max date";
        if (this.data.max_date.compare(date) < 0) {
            this.data.max_date.setValue(date.getDate());
        }
        this.debug = "end of lookupValues()";
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (DimensionLookupMeta)smi;
        this.data = (DimensionLookupData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        try {
            this.lookupValues(r);
            this.putRow(r);
            if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
                this.logBasic("linenr " + this.linesRead);
            }
        }
        catch (ETLException e) {
            this.logError("Because of an error, this step can't continue: " + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DimensionLookupMeta)smi;
        this.data = (DimensionLookupData)sdi;
        if (super.init(smi, sdi)) {
            this.data.min_date = new Value("start_date", this.meta.getMinDate());
            this.data.max_date = new Value("end_date", this.meta.getMaxDate());
            this.data.db = new Database(this.meta.getDatabaseMeta());
            try {
                this.data.db.connect();
                this.logBasic("Connected to database...");
                this.data.db.setCommit(this.meta.getCommitSize());
                return true;
            }
            catch (ETLException ke) {
                this.logError("An error occurred, processing will be stopped: " + ke.getMessage());
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DimensionLookupMeta)smi;
        this.data = (DimensionLookupData)sdi;
        this.data.db.disconnect();
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

