/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.fieldsplitter;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.fieldsplitter.FieldSplitterData;
import com.kingdee.bos.ctrl.etl.transformation.step.fieldsplitter.FieldSplitterMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.textfileinput.TextFileInput;
import com.kingdee.bos.ctrl.etl.value.Value;

public class FieldSplitter
extends BaseStep
implements StepInterface {
    private FieldSplitterMeta meta;
    private FieldSplitterData data;

    public FieldSplitter(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized boolean splitField(Row r) {
        boolean insert;
        if (this.first) {
            this.data.fieldnr = r.searchValueIndex(this.meta.getSplitField());
            if (this.data.fieldnr < 0) {
                this.logError("Couldn't find field to split [" + this.meta.getSplitField() + "] in input stream!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        Value v = r.getValue(this.data.fieldnr);
        r.removeValue(this.data.fieldnr);
        boolean bl = insert = this.data.fieldnr < r.size();
        if (!v.isString()) {
            this.logError("Can only split string fields.  [" + this.meta.getSplitField() + "] is not a string!");
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        boolean use_ids = this.meta.getFieldID().length > 0 && this.meta.getFieldID()[0] != null && this.meta.getFieldID()[0].length() > 0;
        Value value = null;
        if (use_ids) {
            int i;
            this.logDebug("Using IDs!!");
            String[] pol = new String[this.meta.getField().length];
            int prev = 0;
            for (i = 0; prev < v.getString().length() && i < pol.length; prev += pol[i].length() + this.meta.getDelimiter().length(), ++i) {
                pol[i] = FieldSplitter.polNext(v.getString(), this.meta.getDelimiter(), prev);
                this.logDebug("pol=" + pol[i] + ", prev=" + prev);
            }
            for (i = 0; i < this.meta.getField().length; ++i) {
                String split = null;
                for (int p = 0; p < pol.length && split == null; ++p) {
                    if (pol[p] == null || pol[p].indexOf(this.meta.getFieldID()[i]) < 0) continue;
                    split = pol[p];
                }
                if (split != null && this.meta.removeID()[i]) {
                    StringBuffer sb = new StringBuffer(split);
                    int idx = sb.indexOf(this.meta.getFieldID()[i]);
                    sb.delete(idx, idx + this.meta.getFieldID()[i].length());
                    split = sb.toString();
                }
                if (split == null) {
                    split = "";
                }
                this.logDebug("Split=" + split);
                try {
                    value = TextFileInput.convertValue(split, this.meta.getField()[i], this.meta.getFieldType()[i], this.meta.getFieldFormat()[i], this.meta.getFieldLength()[i], this.meta.getFieldPrecision()[i], this.meta.getFieldGroup()[i], this.meta.getFieldDecimal()[i], this.meta.getFieldCurrency()[i], this.meta.getFieldDefault()[i], 3, this.data.df, this.data.dfs, this.data.daf, this.data.dafs);
                }
                catch (Exception e) {
                    this.logError("Error converting value [" + split + "], when splitting field [" + this.meta.getSplitField() + "]!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                if (insert) {
                    r.addValue(this.data.fieldnr + i, value);
                    continue;
                }
                r.addValue(value);
            }
        } else {
            this.logDebug("Using position of value!!");
            int prev = 0;
            for (int i = 0; i < this.meta.getField().length; ++i) {
                String pol = FieldSplitter.polNext(v.getString(), this.meta.getDelimiter(), prev);
                this.logDebug("pol=" + pol + ", prev=" + prev);
                prev += (pol == null ? 0 : pol.length()) + this.meta.getDelimiter().length();
                try {
                    value = TextFileInput.convertValue(pol, this.meta.getField()[i], this.meta.getFieldType()[i], this.meta.getFieldFormat()[i], this.meta.getFieldLength()[i], this.meta.getFieldPrecision()[i], this.meta.getFieldGroup()[i], this.meta.getFieldDecimal()[i], this.meta.getFieldCurrency()[i], this.meta.getFieldDefault()[i], 3, this.data.df, this.data.dfs, this.data.daf, this.data.dafs);
                }
                catch (Exception e) {
                    this.logError("Error converting value [" + pol + "], when splitting field [" + this.meta.getSplitField() + "]!");
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                if (insert) {
                    r.addValue(this.data.fieldnr + i, value);
                    continue;
                }
                r.addValue(value);
            }
        }
        return true;
    }

    private static final String polNext(String str, String del, int start) {
        if (start >= str.length()) {
            return "";
        }
        int next = str.indexOf(del, start);
        String retval = next == start ? "" : (next > start ? str.substring(start, next) : str.substring(start));
        return retval;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (FieldSplitterMeta)smi;
        this.data = (FieldSplitterData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        boolean noerr = this.splitField(r);
        if (!noerr) {
            this.setOutputDone();
            return false;
        }
        this.putRow(r);
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FieldSplitterMeta)smi;
        this.data = (FieldSplitterData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

