/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.rowgenerator;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.rowgenerator.RowGeneratorData;
import com.kingdee.bos.ctrl.etl.transformation.step.rowgenerator.RowGeneratorMeta;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class RowGenerator
extends BaseStep
implements StepInterface {
    private RowGeneratorMeta meta = (RowGeneratorMeta)this.getStepMeta().getStepMetaInterface();
    private RowGeneratorData data;

    public RowGenerator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (RowGeneratorData)stepDataInterface;
    }

    public static final Row buildRow(RowGeneratorMeta meta, RowGeneratorData data, List remarks) {
        Row r = new Row();
        for (int i = 0; i < meta.getFieldName().length; ++i) {
            int valtype = Value.getType(meta.getFieldType()[i]);
            if (meta.getFieldName()[i] == null) continue;
            Value value = new Value(meta.getFieldName()[i], valtype);
            String stringValue = meta.getValue()[i];
            switch (value.getType()) {
                case 1: {
                    String message;
                    try {
                        if (meta.getFieldFormat()[i] != null || meta.getDecimal()[i] != null || meta.getGroup()[i] != null || meta.getCurrency()[i] != null) {
                            if (meta.getFieldFormat()[i] != null && meta.getFieldFormat()[i].length() >= 1) {
                                data.df.applyPattern(meta.getFieldFormat()[i]);
                            }
                            if (meta.getDecimal()[i] != null && meta.getDecimal()[i].length() >= 1) {
                                data.dfs.setDecimalSeparator(meta.getDecimal()[i].charAt(0));
                            }
                            if (meta.getGroup()[i] != null && meta.getGroup()[i].length() >= 1) {
                                data.dfs.setGroupingSeparator(meta.getGroup()[i].charAt(0));
                            }
                            if (meta.getCurrency()[i] != null && meta.getCurrency()[i].length() >= 1) {
                                data.dfs.setCurrencySymbol(meta.getCurrency()[i]);
                            }
                            data.df.setDecimalFormatSymbols(data.dfs);
                        }
                        value.setValue(data.nf.parse(stringValue).doubleValue());
                    }
                    catch (Exception e) {
                        message = "Couldn't parse number field [" + value.getName() + "] with value [" + stringValue + "] -->" + e.toString();
                        remarks.add(new CheckResult(4, message, null));
                    }
                    break;
                }
                case 2: {
                    value.setValue(stringValue);
                    break;
                }
                case 3: {
                    String message;
                    try {
                        if (meta.getFieldFormat()[i] != null) {
                            data.daf.applyPattern(meta.getFieldFormat()[i]);
                            data.daf.setDateFormatSymbols(data.dafs);
                        }
                        value.setValue(data.daf.parse(stringValue));
                    }
                    catch (Exception e) {
                        message = "Couldn't parse date field [" + value.getName() + "] with value [" + stringValue + "] -->" + e.toString();
                        remarks.add(new CheckResult(4, message, null));
                    }
                    break;
                }
                case 5: {
                    String message;
                    try {
                        value.setValue(Long.parseLong(stringValue));
                    }
                    catch (Exception e) {
                        message = "Couldn't parse Integer field [" + value.getName() + "] with value [" + stringValue + "] -->" + e.toString();
                        remarks.add(new CheckResult(4, message, null));
                    }
                    break;
                }
                case 6: {
                    String message;
                    try {
                        value.setValue(new BigDecimal(stringValue));
                    }
                    catch (Exception e) {
                        message = "Couldn't parse BigNumber field [" + value.getName() + "] with value [" + stringValue + "] -->" + e.toString();
                        remarks.add(new CheckResult(4, message, null));
                    }
                    break;
                }
                case 4: {
                    value.setValue("Y".equalsIgnoreCase(stringValue) || "TRUE".equalsIgnoreCase(stringValue));
                    break;
                }
                default: {
                    String message = "Please specify the value type of field [" + value.getName() + "] with value [" + stringValue + "] -->";
                    remarks.add(new CheckResult(4, message, null));
                }
            }
            r.addValue(value);
        }
        return r;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (RowGeneratorMeta)smi;
        this.data = (RowGeneratorData)sdi;
        Row r = null;
        boolean retval = true;
        if (this.linesWritten >= this.meta.getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        r = new Row(this.data.constants);
        this.putRow(r);
        this.log.logRowlevel(this.toString(), "Wrote row #" + this.linesWritten + " : " + r);
        if (this.linesWritten > 0L && this.linesWritten % 5000L == 0L) {
            this.logBasic("Linenr " + this.linesWritten);
        }
        return retval;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RowGeneratorMeta)smi;
        this.data = (RowGeneratorData)sdi;
        if (super.init(smi, sdi)) {
            ArrayList remarks = new ArrayList();
            this.data.constants = RowGenerator.buildRow(this.meta, this.data, remarks);
            if (remarks.size() == 0) {
                return true;
            }
            for (int i = 0; i < remarks.size(); ++i) {
                CheckResult cr = (CheckResult)remarks.get(i);
                this.log.logError(this.getStepname(), cr.getText());
            }
        }
        return false;
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

