/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.sortrows;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.sortrows.SortRows;
import com.kingdee.bos.ctrl.etl.transformation.step.sortrows.SortRowsData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.io.File;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.w3c.dom.Node;

public class SortRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] fieldName;
    private boolean[] ascending;
    private String directory;
    private String prefix;

    public boolean[] getAscending() {
        return this.ascending;
    }

    public void setAscending(boolean[] ascending) {
        this.ascending = ascending;
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.ascending = new boolean[nrfields];
    }

    @Override
    public Object clone() {
        SortRowsMeta retval = (SortRowsMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.ascending[i] = this.ascending[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            this.directory = XMLHandler.getTagValue(stepnode, "directory");
            this.prefix = XMLHandler.getTagValue(stepnode, "prefix");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.fieldName[i] = XMLHandler.getTagValue(fnode, "name");
                String asc = XMLHandler.getTagValue(fnode, "ascending");
                this.ascending[i] = asc.equalsIgnoreCase("Y");
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.directory = "%%java.io.tmpdir%%";
        this.prefix = "out";
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
        }
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "      " + XMLHandler.addTagValue("directory", this.directory);
        retval = retval + "      " + XMLHandler.addTagValue("prefix", this.prefix);
        retval = retval + "    <fields>" + Const.CR;
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval = retval + "      <field>" + Const.CR;
            retval = retval + "        " + XMLHandler.addTagValue("name", this.fieldName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("ascending", this.ascending[i]);
            retval = retval + "        </field>" + Const.CR;
        }
        retval = retval + "      </fields>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            this.directory = rep.getStepAttributeString(id_step, "directory");
            this.prefix = rep.getStepAttributeString(id_step, "prefix");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.ascending[i] = rep.getStepAttributeBoolean(id_step, i, "field_ascending");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "directory", this.directory);
            rep.saveStepAttribute(id_transformation, id_step, "prefix", this.prefix);
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_ascending", this.ascending[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepMeta);
            remarks.add(cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.searchValueIndex(this.fieldName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.fieldName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = "Sort keys that were not found in input stream:" + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            } else if (this.fieldName.length > 0) {
                cr = new CheckResult(1, "All sort keys are found in the input stream.", stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(4, "No sort keys are entered.", stepMeta);
                remarks.add(cr);
            }
            File f = new File(FilenameUtils.normalize((String)Const.replEnv(this.directory)));
            if (f.exists()) {
                if (f.isDirectory()) {
                    cr = new CheckResult(1, "[" + this.directory + "] exists and is a directory", stepMeta);
                    remarks.add(cr);
                } else {
                    cr = new CheckResult(4, "[" + this.directory + "] exists but is not a directory", stepMeta);
                    remarks.add(cr);
                }
            } else {
                cr = new CheckResult(4, "Directory [" + this.directory + "] doesn't exist!", stepMeta);
                remarks.add(cr);
            }
        } else {
            cr = new CheckResult(4, "Couldn't find fields from previous steps, check the hops...!", stepMeta);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SortRows(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SortRowsData();
    }
}

