/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.xmlinput;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLValueException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.xmlinput.XMLInputData;
import com.kingdee.bos.ctrl.etl.transformation.step.xmlinput.XMLInputField;
import com.kingdee.bos.ctrl.etl.transformation.step.xmlinput.XMLInputFieldPosition;
import com.kingdee.bos.ctrl.etl.transformation.step.xmlinput.XMLInputMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import org.w3c.dom.Node;

public class XMLInput
extends BaseStep
implements StepInterface {
    private XMLInputMeta meta;
    private XMLInputData data;

    public XMLInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.debug = "start of processRow()";
        Row row = this.getRowFromXML();
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        this.logRowlevel("Read row: " + row.toString());
        this.putRow(row);
        if (this.meta.getRowLimit() > 0L && this.data.rownr >= this.meta.getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        this.debug = "end of processRow()";
        return true;
    }

    private Row getRowFromXML() throws ETLValueException {
        this.debug = "start of getRowFromXML()";
        if (this.data.itemPosition >= this.data.itemCount) {
            this.data.filename = null;
        }
        if (this.data.filename == null && !this.openNextFile()) {
            return null;
        }
        this.debug = "getRowFromXML: buildEmptyRow()";
        Row row = this.buildEmptyRow();
        this.debug = "getRowFromXML: getSubNodeByNr";
        Node itemNode = XMLHandler.getSubNodeByNr(this.data.section, this.data.itemElement, this.data.itemPosition);
        ++this.data.itemPosition;
        this.debug = "getRowFromXML: read from the selected node";
        for (int i = 0; i < this.meta.getInputFields().length; ++i) {
            Node node = itemNode;
            XMLInputField xmlInputField = this.meta.getInputFields()[i];
            this.debug = "getRowFromXML: read from the selected node: field #" + i + " : " + xmlInputField.getName() + " - " + xmlInputField.getFieldPositionsCode();
            String value = null;
            for (int p = 0; value == null && node != null && p < xmlInputField.getFieldPosition().length; ++p) {
                XMLInputFieldPosition pos = xmlInputField.getFieldPosition()[p];
                this.debug = "getRowFromXML: read from the selected node: field #" + i + " : position #" + p + ": " + pos.toString();
                if (pos.getType() == 1) {
                    Node subNode;
                    if (pos.getElementNr() <= 1) {
                        subNode = XMLHandler.getSubNode(node, pos.getName());
                        if (subNode != null) {
                            if (p == xmlInputField.getFieldPosition().length - 1) {
                                value = XMLHandler.getNodeValue(subNode);
                            }
                        } else {
                            this.logDebug("Unable to find position '" + pos.toString() + "' in node " + Const.CR + node);
                        }
                        node = subNode;
                        continue;
                    }
                    subNode = XMLHandler.getSubNodeByNr(node, pos.getName(), pos.getElementNr() - 1);
                    if (subNode != null) {
                        if (p == xmlInputField.getFieldPosition().length - 1) {
                            value = XMLHandler.getNodeValue(subNode);
                        }
                    } else {
                        this.logDebug("Unable to find position '" + pos.toString() + "' in node " + Const.CR + node);
                    }
                    node = subNode;
                    continue;
                }
                value = XMLHandler.getTagAttribute(node, pos.getName());
            }
            Value v = row.getValue(i);
            if (value != null) {
                v.setValue(value);
            } else {
                v.setNull();
            }
            switch (xmlInputField.getTrimType()) {
                case 1: {
                    v.ltrim();
                    break;
                }
                case 2: {
                    v.rtrim();
                    break;
                }
                case 3: {
                    v.trim();
                    break;
                }
            }
            switch (xmlInputField.getType()) {
                case 2: {
                    break;
                }
                case 1: {
                    if (xmlInputField.getFormat() != null && xmlInputField.getFormat().length() > 0) {
                        if (xmlInputField.getDecimalSymbol() != null && xmlInputField.getDecimalSymbol().length() > 0) {
                            if (xmlInputField.getGroupSymbol() != null && xmlInputField.getGroupSymbol().length() > 0) {
                                if (xmlInputField.getCurrencySymbol() != null && xmlInputField.getCurrencySymbol().length() > 0) {
                                    v.str2num(xmlInputField.getFormat(), xmlInputField.getGroupSymbol(), xmlInputField.getGroupSymbol(), xmlInputField.getCurrencySymbol());
                                } else {
                                    v.str2num(xmlInputField.getFormat(), xmlInputField.getGroupSymbol(), xmlInputField.getGroupSymbol());
                                }
                            } else {
                                v.str2num(xmlInputField.getFormat(), xmlInputField.getGroupSymbol());
                            }
                        } else {
                            v.str2num(xmlInputField.getFormat());
                        }
                    } else {
                        v.str2num();
                    }
                    v.setLength(xmlInputField.getLength(), xmlInputField.getPrecision());
                    break;
                }
                case 5: {
                    v.setValue(v.getInteger());
                    v.setLength(xmlInputField.getLength(), xmlInputField.getPrecision());
                    break;
                }
                case 6: {
                    v.setValue(v.getBigNumber());
                    v.setLength(xmlInputField.getLength(), xmlInputField.getPrecision());
                    break;
                }
                case 3: {
                    if (xmlInputField.getFormat() != null && xmlInputField.getFormat().length() > 0) {
                        v.str2dat(xmlInputField.getFormat());
                        break;
                    }
                    v.setValue(v.getDate());
                    break;
                }
                case 4: {
                    v.setValue(v.getBoolean());
                    break;
                }
            }
            if (!this.meta.getInputFields()[i].isRepeated() || !v.isNull() || this.data.previousRow == null) continue;
            Value previous = this.data.previousRow.getValue(i);
            v.setValue(previous);
        }
        if (this.meta.includeFilename() && this.meta.getFilenameField() != null && this.meta.getFilenameField().length() > 0) {
            Value fn = new Value(this.meta.getFilenameField(), this.data.filename);
            row.addValue(fn);
        }
        if (this.meta.includeRowNumber() && this.meta.getRowNumberField() != null && this.meta.getRowNumberField().length() > 0) {
            Value fn = new Value(this.meta.getRowNumberField(), this.data.rownr);
            row.addValue(fn);
        }
        this.data.previousRow = new Row(row);
        ++this.data.rownr;
        this.debug = "end of getRowFromXML()";
        return row;
    }

    private Row buildEmptyRow() {
        Row row = new Row();
        XMLInputField[] fields = this.meta.getInputFields();
        for (int i = 0; i < fields.length; ++i) {
            XMLInputField field = fields[i];
            Value value = new Value(field.getName(), field.getType());
            value.setLength(field.getLength(), field.getPrecision());
            value.setNull();
            row.addValue(value);
        }
        return row;
    }

    private boolean openNextFile() {
        try {
            if (this.data.filenr >= this.data.files.length) {
                this.logDetailed("Finished processing files.");
                return false;
            }
            this.data.last_file = this.data.filenr == this.data.files.length - 1;
            this.data.filename = this.data.files[this.data.filenr];
            this.logBasic("Opening file: " + this.data.filename);
            ++this.data.filenr;
            this.data.document = XMLHandler.loadXMLFile(this.data.filename);
            this.data.section = this.data.document;
            for (int i = 0; i < this.meta.getInputPosition().length - 1; ++i) {
                this.data.section = XMLHandler.getSubNode(this.data.section, this.meta.getInputPosition()[i]);
            }
            this.data.itemElement = this.meta.getInputPosition()[this.meta.getInputPosition().length - 1];
            this.data.itemCount = XMLHandler.countNodes(this.data.section, this.data.itemElement);
            this.data.itemPosition = 0;
        }
        catch (Exception e) {
            this.logError("Couldn't open file #" + this.data.filenr + " : " + this.data.filename + " --> " + e.toString());
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLInputMeta)smi;
        this.data = (XMLInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.files = this.meta.getFiles();
            if (this.data.files == null || this.data.files.length == 0) {
                this.logError("No file(s) specified! Stop processing.");
                return false;
            }
            this.data.rownr = 1L;
            return true;
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLInputMeta)smi;
        this.data = (XMLInputData)sdi;
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

