/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.value;

import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.ValueInterface;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ValueString
implements ValueInterface,
Cloneable {
    private String string;
    private int length;

    public ValueString() {
        this.string = null;
        this.length = -1;
    }

    public ValueString(String string) {
        this.string = string;
        this.length = -1;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getTypeDesc() {
        return "String";
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public double getNumber() {
        return Const.toDouble(this.string, 0.0);
    }

    @Override
    public Date getDate() {
        if (this.string != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
            try {
                return df.parse(this.string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean getBoolean() {
        return "Y".equalsIgnoreCase(this.string) || "TRUE".equalsIgnoreCase(this.string) || "YES".equalsIgnoreCase(this.string) || "1".equalsIgnoreCase(this.string);
    }

    @Override
    public long getInteger() {
        return Const.toLong(this.string, 0L);
    }

    @Override
    public void setString(String string) {
        this.string = string;
    }

    @Override
    public void setNumber(double number) {
        this.string = "" + number;
    }

    @Override
    public void setDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        this.string = df.format(date);
    }

    @Override
    public void setBoolean(boolean bool) {
        this.string = bool ? "Y" : "N";
    }

    @Override
    public void setInteger(long number) {
        this.string = "" + number;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getPrecision() {
        return -1;
    }

    @Override
    public void setLength(int length, int precision) {
        this.length = length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public void setPrecision(int precision) {
    }

    @Override
    public Object clone() {
        try {
            ValueString retval = (ValueString)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public BigDecimal getBigNumber() {
        if (this.string == null) {
            return null;
        }
        return new BigDecimal(this.string);
    }

    @Override
    public void setBigNumber(BigDecimal number) {
        this.string = number.toString();
    }
}

