/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.pkcs;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1Encodable;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1EncodableVector;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1OctetString;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Set;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1TaggedObject;
import com.kingdee.bos.ctrl.cipher.asn1.DERInteger;
import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.DERSequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERTaggedObject;
import com.kingdee.bos.ctrl.cipher.asn1.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;

public class PrivateKeyInfo
extends ASN1Encodable {
    private DERObject privKey;
    private AlgorithmIdentifier algId;
    private ASN1Set attributes;

    public static PrivateKeyInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PrivateKeyInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static PrivateKeyInfo getInstance(Object obj) {
        if (obj instanceof PrivateKeyInfo) {
            return (PrivateKeyInfo)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new PrivateKeyInfo((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("unknown object in factory: " + obj.getClass().getName());
    }

    public PrivateKeyInfo(AlgorithmIdentifier algId, DERObject privateKey) {
        this(algId, privateKey, null);
    }

    public PrivateKeyInfo(AlgorithmIdentifier algId, DERObject privateKey, ASN1Set attributes) {
        this.privKey = privateKey;
        this.algId = algId;
        this.attributes = attributes;
    }

    public PrivateKeyInfo(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        BigInteger version = ((DERInteger)e.nextElement()).getValue();
        if (version.intValue() != 0) {
            throw new IllegalArgumentException("wrong version for private key info");
        }
        this.algId = new AlgorithmIdentifier((ASN1Sequence)e.nextElement());
        try {
            ASN1InputStream aIn = new ASN1InputStream(((ASN1OctetString)e.nextElement()).getOctets());
            this.privKey = aIn.readObject();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Error recoverying private key from sequence");
        }
        if (e.hasMoreElements()) {
            this.attributes = ASN1Set.getInstance((ASN1TaggedObject)e.nextElement(), false);
        }
    }

    public AlgorithmIdentifier getAlgorithmId() {
        return this.algId;
    }

    public DERObject getPrivateKey() {
        return this.privKey;
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    @Override
    public DERObject toASN1Object() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new DERInteger(0));
        v.add(this.algId);
        v.add(new DEROctetString(this.privKey));
        if (this.attributes != null) {
            v.add(new DERTaggedObject(false, 0, this.attributes));
        }
        return new DERSequence(v);
    }
}

