/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1Encodable;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1OutputStream;
import com.kingdee.bos.ctrl.cipher.asn1.DERIA5String;
import com.kingdee.bos.ctrl.cipher.asn1.DERObject;
import com.kingdee.bos.ctrl.cipher.asn1.misc.CAST5CBCParameters;
import com.kingdee.bos.ctrl.cipher.asn1.misc.IDEACBCPar;
import com.kingdee.bos.ctrl.cipher.asn1.misc.NetscapeCertType;
import com.kingdee.bos.ctrl.cipher.asn1.misc.NetscapeRevocationURL;
import com.kingdee.bos.ctrl.cipher.asn1.misc.VerisignCzagExtension;
import com.kingdee.bos.ctrl.cipher.util.encoders.Base64;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTestResult;
import com.kingdee.bos.ctrl.cipher.util.test.Test;
import com.kingdee.bos.ctrl.cipher.util.test.TestResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class MiscTest
implements Test {
    private boolean isSameAs(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i != a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public TestResult perform() {
        byte[] testIv = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        ASN1Encodable[] values = new ASN1Encodable[]{new CAST5CBCParameters(testIv, 128), new NetscapeCertType(32), new VerisignCzagExtension(new DERIA5String("hello")), new IDEACBCPar(testIv), new NetscapeRevocationURL(new DERIA5String("http://test"))};
        byte[] data = Base64.decode("MA4ECAECAwQFBgcIAgIAgAMCBSAWBWhlbGxvMAoECAECAwQFBgcIFgtodHRwOi8vdGVzdA==");
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            for (int i = 0; i != values.length; ++i) {
                aOut.writeObject(values[i]);
            }
            DERObject[] readValues = new DERObject[values.length];
            if (!this.isSameAs(bOut.toByteArray(), data)) {
                return new SimpleTestResult(false, this.getName() + ": Failed data check");
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            for (int i = 0; i != values.length; ++i) {
                DERObject o = aIn.readObject();
                if (!values[i].equals(o)) {
                    return new SimpleTestResult(false, this.getName() + ": Failed equality test for " + o);
                }
                if (o.hashCode() == values[i].hashCode()) continue;
                return new SimpleTestResult(false, this.getName() + ": Failed hashCode test for " + o);
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + e.toString(), e);
        }
    }

    @Override
    public String getName() {
        return "Misc";
    }

    public static void main(String[] args) {
        MiscTest test = new MiscTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

