/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.asn1.test;

import com.kingdee.bos.ctrl.cipher.asn1.ASN1InputStream;
import com.kingdee.bos.ctrl.cipher.asn1.ASN1Sequence;
import com.kingdee.bos.ctrl.cipher.asn1.DERObjectIdentifier;
import com.kingdee.bos.ctrl.cipher.asn1.DEROctetString;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.NamingAuthority;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.ProcurationSyntax;
import com.kingdee.bos.ctrl.cipher.asn1.isismtt.x509.ProfessionInfo;
import com.kingdee.bos.ctrl.cipher.asn1.test.ASN1UnitTest;
import com.kingdee.bos.ctrl.cipher.asn1.x500.DirectoryString;
import java.io.IOException;

public class ProfessionInfoUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "ProfessionInfo";
    }

    @Override
    public void performTest() throws Exception {
        NamingAuthority auth = new NamingAuthority(new DERObjectIdentifier("1.2.3"), "url", new DirectoryString("fred"));
        DirectoryString[] professionItems = new DirectoryString[]{new DirectoryString("substitution")};
        DERObjectIdentifier[] professionOids = new DERObjectIdentifier[]{new DERObjectIdentifier("1.2.3")};
        String registrationNumber = "12345";
        DEROctetString addProfInfo = new DEROctetString(new byte[20]);
        ProfessionInfo info = new ProfessionInfo(auth, professionItems, professionOids, registrationNumber, addProfInfo);
        this.checkConstruction(info, auth, professionItems, professionOids, registrationNumber, addProfInfo);
        info = new ProfessionInfo(null, professionItems, professionOids, registrationNumber, addProfInfo);
        this.checkConstruction(info, null, professionItems, professionOids, registrationNumber, addProfInfo);
        info = new ProfessionInfo(auth, professionItems, null, registrationNumber, addProfInfo);
        this.checkConstruction(info, auth, professionItems, null, registrationNumber, addProfInfo);
        info = new ProfessionInfo(auth, professionItems, professionOids, null, addProfInfo);
        this.checkConstruction(info, auth, professionItems, professionOids, null, addProfInfo);
        info = new ProfessionInfo(auth, professionItems, professionOids, registrationNumber, null);
        this.checkConstruction(info, auth, professionItems, professionOids, registrationNumber, null);
        info = ProfessionInfo.getInstance(null);
        if (info != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            ProcurationSyntax.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(ProfessionInfo profInfo, NamingAuthority auth, DirectoryString[] professionItems, DERObjectIdentifier[] professionOids, String registrationNumber, DEROctetString addProfInfo) throws IOException {
        this.checkValues(profInfo, auth, professionItems, professionOids, registrationNumber, addProfInfo);
        profInfo = ProfessionInfo.getInstance(profInfo);
        this.checkValues(profInfo, auth, professionItems, professionOids, registrationNumber, addProfInfo);
        ASN1InputStream aIn = new ASN1InputStream(profInfo.toASN1Object().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        profInfo = ProfessionInfo.getInstance(seq);
        this.checkValues(profInfo, auth, professionItems, professionOids, registrationNumber, addProfInfo);
    }

    private void checkValues(ProfessionInfo profInfo, NamingAuthority auth, DirectoryString[] professionItems, DERObjectIdentifier[] professionOids, String registrationNumber, DEROctetString addProfInfo) {
        this.checkOptionalField("auth", auth, profInfo.getNamingAuthority());
        this.checkMandatoryField("professionItems", professionItems[0], profInfo.getProfessionItems()[0]);
        if (professionOids != null) {
            this.checkOptionalField("professionOids", professionOids[0], profInfo.getProfessionOIDs()[0]);
        }
        this.checkOptionalField("registrationNumber", registrationNumber, profInfo.getRegistrationNumber());
        this.checkOptionalField("addProfessionInfo", addProfInfo, profInfo.getAddProfessionInfo());
    }

    public static void main(String[] args) {
        ProfessionInfoUnitTest.runTest(new ProfessionInfoUnitTest());
    }
}

