/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.InvalidCipherTextException;
import com.kingdee.bos.ctrl.cipher.crypto.engines.AESEngine;
import com.kingdee.bos.ctrl.cipher.crypto.engines.DESEngine;
import com.kingdee.bos.ctrl.cipher.crypto.modes.CCMBlockCipher;
import com.kingdee.bos.ctrl.cipher.crypto.params.AEADParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.CCMParameters;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.crypto.params.ParametersWithIV;
import com.kingdee.bos.ctrl.cipher.util.Strings;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;

public class CCMTest
extends SimpleTest {
    private byte[] K1 = Hex.decode("404142434445464748494a4b4c4d4e4f");
    private byte[] N1 = Hex.decode("10111213141516");
    private byte[] A1 = Hex.decode("0001020304050607");
    private byte[] P1 = Hex.decode("20212223");
    private byte[] C1 = Hex.decode("7162015b4dac255d");
    private byte[] T1 = Hex.decode("6084341b");
    private byte[] K2 = Hex.decode("404142434445464748494a4b4c4d4e4f");
    private byte[] N2 = Hex.decode("1011121314151617");
    private byte[] A2 = Hex.decode("000102030405060708090a0b0c0d0e0f");
    private byte[] P2 = Hex.decode("202122232425262728292a2b2c2d2e2f");
    private byte[] C2 = Hex.decode("d2a1f0e051ea5f62081a7792073d593d1fc64fbfaccd");
    private byte[] T2 = Hex.decode("7f479ffca464");
    private byte[] K3 = Hex.decode("404142434445464748494a4b4c4d4e4f");
    private byte[] N3 = Hex.decode("101112131415161718191a1b");
    private byte[] A3 = Hex.decode("000102030405060708090a0b0c0d0e0f10111213");
    private byte[] P3 = Hex.decode("202122232425262728292a2b2c2d2e2f3031323334353637");
    private byte[] C3 = Hex.decode("e3b201a9f5b71a7a9b1ceaeccd97e70b6176aad9a4428aa5484392fbc1b09951");
    private byte[] T3 = Hex.decode("67c99240c7d51048");
    private byte[] K4 = Hex.decode("404142434445464748494a4b4c4d4e4f");
    private byte[] N4 = Hex.decode("101112131415161718191a1b1c");
    private byte[] A4 = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f505152535455565758595a5b5c5d5e5f606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeafb0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff");
    private byte[] P4 = Hex.decode("202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f");
    private byte[] C4 = Hex.decode("69915dad1e84c6376a68c2967e4dab615ae0fd1faec44cc484828529463ccf72b4ac6bec93e8598e7f0dadbcea5b");
    private byte[] T4 = Hex.decode("f4dd5d0ee404617225ffe34fce91");
    private byte[] C5 = Hex.decode("49b17d8d3ea4e6174a48e2b65e6d8b417ac0dd3f8ee46ce4a4a2a509661cef52528c1cd9805333a5cfd482fa3f095a3c2fdd1cc47771c5e55fddd60b5c8d6d3fa5c8dd79d08b16242b6642106e7c0c28bd1064b31e6d7c9800c8397dbc3fa8071e6a38278b386c18d65d39c6ad1ef9501a5c8f68d38eb6474799f3cc898b4b9b97e87f9c95ce5c51bc9d758f17119586663a5684e0a0daf6520ec572b87473eb141d10471e4799ded9e607655402eca5176bbf792ef39dd135ac8d710da8e9e854fd3b95c681023f36b5ebe2fb213d0b62dd6e9e3cfe190b792ccb20c53423b2dca128f861a61d306910e1af418839467e466f0ec361d2539eedd99d4724f1b51c07beb40e875a87491ec8b27cd1");
    private byte[] T5 = Hex.decode("5c768856796b627b13ec8641581b");

    @Override
    public void performTest() throws Exception {
        CCMBlockCipher ccm = new CCMBlockCipher(new AESEngine());
        this.checkVectors(0, ccm, this.K1, 32, this.N1, this.A1, this.P1, this.T1, this.C1);
        this.checkVectors(1, ccm, this.K2, 48, this.N2, this.A2, this.P2, this.T2, this.C2);
        this.checkVectors(2, ccm, this.K3, 64, this.N3, this.A3, this.P3, this.T3, this.C3);
        this.ivParamTest(0, ccm, this.K1, this.N1);
        byte[] a4 = new byte[65536];
        for (int i = 0; i < a4.length; i += this.A4.length) {
            System.arraycopy(this.A4, 0, a4, i, this.A4.length);
        }
        this.checkVectors(3, ccm, this.K4, 112, this.N4, a4, this.P4, this.T4, this.C4);
        this.checkVectors(4, ccm, this.K4, 112, this.N4, this.A4, this.A4, this.T5, this.C5);
        try {
            ccm.init(false, new CCMParameters(new KeyParameter(this.K1), 32, this.N2, this.A2));
            ccm.processPacket(this.C2, 0, this.C2.length);
            this.fail("invalid cipher text not picked up");
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            // empty catch block
        }
        try {
            ccm = new CCMBlockCipher(new DESEngine());
            this.fail("incorrect block size not picked up");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ccm.init(false, new KeyParameter(this.K1));
            this.fail("illegal argument not picked up");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkVectors(int count, CCMBlockCipher ccm, byte[] k, int macSize, byte[] n, byte[] a, byte[] p, byte[] t, byte[] c) throws InvalidCipherTextException {
        ccm.init(true, new AEADParameters(new KeyParameter(k), macSize, n, a));
        byte[] enc = new byte[c.length];
        int len = ccm.processBytes(p, 0, p.length, enc, 0);
        len += ccm.doFinal(enc, len);
        if (!this.areEqual(c, enc)) {
            this.fail("encrypted stream fails to match in test " + count);
        }
        ccm.init(false, new AEADParameters(new KeyParameter(k), macSize, n, a));
        byte[] tmp = new byte[enc.length];
        len = ccm.processBytes(enc, 0, enc.length, tmp, 0);
        len += ccm.doFinal(tmp, len);
        byte[] dec = new byte[len];
        System.arraycopy(tmp, 0, dec, 0, len);
        if (!this.areEqual(p, dec)) {
            this.fail("decrypted stream fails to match in test " + count);
        }
        if (!this.areEqual(t, ccm.getMac())) {
            this.fail("MAC fails to match in test " + count);
        }
    }

    private void ivParamTest(int count, CCMBlockCipher ccm, byte[] k, byte[] n) throws InvalidCipherTextException {
        byte[] p = Strings.toByteArray("hello world!!");
        ccm.init(true, new ParametersWithIV(new KeyParameter(k), n));
        byte[] enc = new byte[p.length + 8];
        int len = ccm.processBytes(p, 0, p.length, enc, 0);
        len += ccm.doFinal(enc, len);
        ccm.init(false, new ParametersWithIV(new KeyParameter(k), n));
        byte[] tmp = new byte[enc.length];
        len = ccm.processBytes(enc, 0, enc.length, tmp, 0);
        len += ccm.doFinal(tmp, len);
        byte[] dec = new byte[len];
        System.arraycopy(tmp, 0, dec, 0, len);
        if (!this.areEqual(p, dec)) {
            this.fail("decrypted stream fails to match in test " + count);
        }
    }

    @Override
    public String getName() {
        return "CCM";
    }

    public static void main(String[] args) {
        CCMTest.runTest(new CCMTest());
    }
}

