/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.cipher.crypto.test;

import com.kingdee.bos.ctrl.cipher.crypto.CipherParameters;
import com.kingdee.bos.ctrl.cipher.crypto.StreamCipher;
import com.kingdee.bos.ctrl.cipher.crypto.engines.HC128Engine;
import com.kingdee.bos.ctrl.cipher.crypto.engines.HC256Engine;
import com.kingdee.bos.ctrl.cipher.crypto.params.KeyParameter;
import com.kingdee.bos.ctrl.cipher.crypto.params.ParametersWithIV;
import com.kingdee.bos.ctrl.cipher.util.Arrays;
import com.kingdee.bos.ctrl.cipher.util.encoders.Hex;
import com.kingdee.bos.ctrl.cipher.util.test.SimpleTest;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class HCFamilyVecTest
extends SimpleTest {
    private static final String TEST_DATA_HOME = "bc.test.data.home";

    @Override
    public String getName() {
        return "HC-128 and HC-256";
    }

    @Override
    public void performTest() throws Exception {
        this.runTests(new HC128Engine(), "hc-128/ecrypt_HC-128.txt");
        this.runTests(new HC256Engine(), "hc-256/ecrypt_HC-256_128K_128IV.txt");
        this.runTests(new HC256Engine(), "hc-256/ecrypt_HC-256_256K_128IV.txt");
        this.runTests(new HC256Engine(), "hc-256/ecrypt_HC-256_128K_256IV.txt");
        this.runTests(new HC256Engine(), "hc-256/ecrypt_HC-256_256K_256IV.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTests(StreamCipher hc, String fileName) throws IOException {
        FileReader resource = null;
        PeekableLineReader r = null;
        try {
            resource = new FileReader(HCFamilyVecTest.getDataHome() + "/" + fileName);
            r = new PeekableLineReader(resource);
            this.runAllVectors(hc, fileName, r);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{r, resource});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{r, resource});
    }

    private void runAllVectors(StreamCipher hc, String fileName, PeekableLineReader r) throws IOException {
        String line;
        while ((line = r.readLine()) != null) {
            if (!(line = line.trim()).startsWith("Set ")) continue;
            this.runVector(hc, fileName, r, this.dellChar(line, ':'));
        }
    }

    private String dellChar(String s, char c) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i != s.length(); ++i) {
            if (s.charAt(i) == c) continue;
            b.append(s.charAt(i));
        }
        return b.toString();
    }

    private void runVector(StreamCipher hc, String fileName, PeekableLineReader r, String vectorName) throws IOException {
        String hexKey = HCFamilyVecTest.readBlock(r);
        String hexIV = HCFamilyVecTest.readBlock(r);
        CipherParameters cp = new KeyParameter(Hex.decode(hexKey));
        cp = new ParametersWithIV(cp, Hex.decode(hexIV));
        hc.init(true, cp);
        byte[] input = new byte[64];
        byte[] output = new byte[64];
        byte[] digest = new byte[64];
        int pos = 0;
        while (true) {
            String line1 = r.peekLine().trim();
            int equalsPos = line1.indexOf(61);
            String lead = line1.substring(0, equalsPos - 1);
            String hexData = HCFamilyVecTest.readBlock(r);
            byte[] data = Hex.decode(hexData);
            if (lead.equals("xor-digest")) {
                if (Arrays.areEqual(data, digest)) break;
                this.fail("Failed in " + fileName + " for test vector: " + vectorName + " at " + lead);
                break;
            }
            int posA = lead.indexOf(91);
            int posB = lead.indexOf("..");
            int posC = lead.indexOf(93);
            int start = Integer.parseInt(lead.substring(posA + 1, posB));
            int end = Integer.parseInt(lead.substring(posB + 2, posC));
            if (start % 64 != 0 || end - start != 63) {
                throw new IllegalStateException(vectorName + ": " + lead + " not on 64 byte boundaries");
            }
            while (pos < end) {
                hc.processBytes(input, 0, input.length, output, 0);
                HCFamilyVecTest.xor(digest, output);
                pos += 64;
            }
            if (Arrays.areEqual(data, output)) continue;
            this.fail("Failed in " + fileName + " for test vector: " + vectorName + " at " + lead);
        }
    }

    private static String readBlock(PeekableLineReader r) throws IOException {
        String peek;
        String first = r.readLine().trim();
        String result = first.substring(first.lastIndexOf(32) + 1);
        while ((peek = r.peekLine().trim()).length() >= 1 && peek.indexOf(61) < 0) {
            result = result + r.readLine().trim();
        }
        return result;
    }

    private static void xor(byte[] digest, byte[] block) {
        for (int i = 0; i < digest.length; ++i) {
            int n = i;
            digest[n] = (byte)(digest[n] ^ block[i]);
        }
    }

    private static String getDataHome() {
        String dataHome = System.getProperty(TEST_DATA_HOME);
        if (dataHome == null) {
            throw new IllegalStateException("bc.test.data.home property not set");
        }
        return dataHome + "/hc-256";
    }

    public static void main(String[] args) {
        HCFamilyVecTest.runTest(new HCFamilyVecTest());
    }

    private static class PeekableLineReader
    extends BufferedReader {
        private String peek = super.readLine();

        public PeekableLineReader(Reader r) throws IOException {
            super(r);
        }

        public String peekLine() {
            return this.peek;
        }

        @Override
        public String readLine() throws IOException {
            String tmp = this.peek;
            this.peek = super.readLine();
            return tmp;
        }
    }
}

