/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.immit;

import com.kingdee.bos.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.immit.AbstractHyperLinkAssembler;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.dlg.FormulaWizardPopupForF7;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;

public class EasUIHyperLinkAssembler
extends AbstractHyperLinkAssembler {
    public static final String UI_TYPE = "UI_TYPE";
    public static final String UI_ID_LIST = "ID_LIST";
    public static final String UI_READ_ONLY = "UI_READ_ONLY";
    public static final String UI_CLASS_NAME = "UI_CLASS_NAME";
    private KDWorkButton delBtn;
    private KDWorkButton insertBtn;
    private KDWorkButton delParamBtn;
    private KDWorkButton insertParamBtn;
    private KDLabel reportLbl;
    private KDLabel paramLbl;
    private KDTable reportTable;
    private KDTable paramTable;
    private final String EDIT_UI = "\u7f16\u8f91\u754c\u9762";
    private final String LIST_UI = "\u5e8f\u65f6\u7c3f";
    private List lastAssembled;
    private Color locked = new Color(220, 220, 220);
    public static final String PREFIX = "EAS_UI:";

    public EasUIHyperLinkAssembler(KDExt ext) {
        super(ext);
        this.initComps();
        this.initListeners();
    }

    private void initComps() {
        this.delBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Delete.gif"));
        this.insertBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Insert.gif"));
        this.delParamBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Delete.gif"));
        this.insertParamBtn = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_Insert.gif"));
        this.reportLbl = new KDLabel();
        this.paramLbl = new KDLabel();
        this.reportTable = new KDTable();
        this.paramTable = new KDTable();
        this.paramTable.getScriptManager().setScriptDisabled(true);
        this.reportLbl.setText("\u57fa\u672c\u8bbe\u7f6e");
        this.paramLbl.setText("\u5355\u636e\u6761\u76ee\u8bbe\u7f6e");
        this.initTables();
        this.setCustomInsets(new Insets(5, 5, 5, 5));
        TableLayout2 layout = new TableLayout2(4, 3);
        this.setLayout((LayoutManager)layout);
        layout.setRatableWidth(0, 1);
        layout.setFixedWidth(1, 22);
        layout.setFixedWidth(2, 22);
        layout.setFixedHeight(0, 22);
        layout.setRatableHeight(1, 1);
        layout.setFixedHeight(2, 22);
        layout.setRatableHeight(3, 1);
        layout.setRowSpacing(0, 5);
        layout.setRowSpacing(1, 10);
        layout.setRowSpacing(2, 5);
        layout.setColSpacing(1, 4);
        this.add((Component)this.reportLbl, TableLayout2.param((int)0, (int)0));
        this.add((Component)this.delBtn, TableLayout2.param((int)0, (int)2));
        this.add((Component)this.insertBtn, TableLayout2.param((int)0, (int)1));
        this.add((Component)this.delParamBtn, TableLayout2.param((int)2, (int)2));
        this.add((Component)this.insertParamBtn, TableLayout2.param((int)2, (int)1));
        this.add((Component)this.reportTable, TableLayout2.param((int)1, (int)0, (int)1, (int)2));
        this.add((Component)this.paramLbl, TableLayout2.param((int)2, (int)0));
        this.add((Component)this.paramTable, TableLayout2.param((int)3, (int)0, (int)3, (int)2));
    }

    private void initTables() {
        int i;
        KDPromptBox f7FormulaWizard = new KDPromptBox();
        f7FormulaWizard.setHistoryRecordEnabled(false);
        f7FormulaWizard.setIcon(ResourceManager.getImageIcon("func_new.png").getImage());
        f7FormulaWizard.setSelector((KDPromptSelector)new FormulaWizardPopupForF7(this.ext, f7FormulaWizard));
        f7FormulaWizard.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                KDPromptBox f7 = (KDPromptBox)e.getSource();
                FormulaWizardPopupForF7 popup = (FormulaWizardPopupForF7)f7.getSelector();
                popup.setEditingData(f7.getText());
                popup.setImpresario((KDDialog)SwingUtilities.getWindowAncestor((Component)((Object)EasUIHyperLinkAssembler.this)));
            }
        });
        this.reportTable.getSelectManager().setSelectMode(2);
        int colCount = 6;
        for (i = 0; i < colCount; ++i) {
            this.reportTable.addColumn(i);
        }
        this.reportTable.getColumn(0).setWidth(40);
        this.reportTable.getColumn(1).setWidth(355);
        this.reportTable.getColumn(2).setWidth(60);
        this.reportTable.getColumn(3).setWidth(40);
        this.reportTable.getColumn(4).setWidth(80);
        this.reportTable.getColumn(5).setWidth(250);
        this.reportTable.getColumn(4).getStyleAttributes().setHided(true);
        this.reportTable.getColumn(5).getStyleAttributes().setHided(true);
        this.reportTable.addHeadRow();
        this.reportTable.getHeadRow(0).getCell(0).setValue((Object)"\u9ed8\u8ba4");
        this.reportTable.getHeadRow(0).getCell(1).setValue((Object)"\u5f15\u7528\u540d\u79f0");
        this.reportTable.getHeadRow(0).getCell(2).setValue((Object)"\u5355\u636e\u7c7b\u578b");
        this.reportTable.getHeadRow(0).getCell(3).setValue((Object)"\u53ea\u8bfb");
        this.reportTable.getHeadRow(0).getCell(4).setValue((Object)"\u81ea\u52a8\u68c0\u6d4bUI");
        this.reportTable.getHeadRow(0).getCell(5).setValue((Object)"\u5355\u636eUI\u7c7b\u8def\u5f84");
        this.reportTable.getIndexColumn().getStyleAttributes().setHided(true);
        KDTableHelper.setEnterKeyJumpOrientation((KDTable)this.reportTable, (int)0);
        this.paramTable.getSelectManager().setSelectMode(2);
        colCount = 1;
        for (i = 0; i < colCount; ++i) {
            this.paramTable.addColumn(i);
        }
        this.paramTable.getColumn(0).setWidth(495);
        this.paramTable.addHeadRow();
        this.paramTable.getHeadRow(0).getCell(0).setValue((Object)"\u5355\u636e\u6761\u76ee\u6e05\u5355");
        this.paramTable.getIndexColumn().getStyleAttributes().setHided(true);
        ActionMap am = this.paramTable.getActionMap();
        am.remove("Copy");
        am.remove("Paste");
        am.remove("Cut");
        am.remove("Delete");
        am = this.reportTable.getActionMap();
        am.remove("Copy");
        am.remove("Paste");
        am.remove("Cut");
        am.remove("Delete");
        this.reportTable.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.reportTable.getColumn(3).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.reportTable.getColumn(4).setEditor((ICellEditor)new KDTDefaultCellEditor((JCheckBox)new KDCheckBox()));
        this.paramTable.getColumn(0).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)f7FormulaWizard));
        this.reportTable.getColumn(2).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)new KDComboBox((Object[])new String[]{"\u7f16\u8f91\u754c\u9762", "\u5e8f\u65f6\u7c3f"})));
    }

    private List getCurrentTransitionIDList() {
        IRow row = this.reportTable.getRow(this.reportTable.getSelectManager().getActiveRowIndex());
        if (row == null) {
            return null;
        }
        HashMap map = (HashMap)row.getUserObject();
        if (map == null) {
            map = new HashMap();
            row.setUserObject(map);
            map.put(UI_ID_LIST, new ArrayList());
        }
        return (List)map.get(UI_ID_LIST);
    }

    private void initListeners() {
        this.delParamBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectIndex = EasUIHyperLinkAssembler.this.paramTable.getSelectManager().getActiveRowIndex();
                IRow rowRemoved = EasUIHyperLinkAssembler.this.paramTable.getRow(selectIndex);
                if (rowRemoved == null) {
                    return;
                }
                EasUIHyperLinkAssembler.this.paramTable.removeRow(selectIndex);
                EasUIHyperLinkAssembler.this.getCurrentTransitionIDList().remove(rowRemoved.getCell(0).getValue());
            }
        });
        this.insertParamBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rindex = EasUIHyperLinkAssembler.this.reportTable.getSelectManager().getActiveRowIndex();
                if (rindex < 0) {
                    return;
                }
                int index = EasUIHyperLinkAssembler.this.paramTable.getSelectManager().getActiveRowIndex();
                IRow rowAdded = index < 0 ? EasUIHyperLinkAssembler.this.paramTable.addRow() : EasUIHyperLinkAssembler.this.paramTable.addRow(index);
                EasUIHyperLinkAssembler.this.paramTable.getEditManager().editCellAt(rowAdded.getRowIndex(), 0);
            }
        });
        this.delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow rowRemoved = EasUIHyperLinkAssembler.this.reportTable.removeRow(EasUIHyperLinkAssembler.this.reportTable.getSelectManager().getActiveRowIndex());
                if (rowRemoved != null && Boolean.TRUE.equals(rowRemoved.getCell(0).getValue()) && EasUIHyperLinkAssembler.this.reportTable.getRowCount() != 0) {
                    IRow firstRow = EasUIHyperLinkAssembler.this.reportTable.getRow(0);
                    firstRow.getCell(0).setValue((Object)Boolean.TRUE);
                }
                EasUIHyperLinkAssembler.this.syncParams();
            }
        });
        this.insertBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index;
                boolean firstRow = false;
                if (EasUIHyperLinkAssembler.this.reportTable.getRowCount() == 0) {
                    firstRow = true;
                }
                IRow rowAdded = (index = EasUIHyperLinkAssembler.this.reportTable.getSelectManager().getActiveRowIndex()) < 0 ? EasUIHyperLinkAssembler.this.reportTable.addRow() : EasUIHyperLinkAssembler.this.reportTable.addRow(index);
                if (firstRow) {
                    rowAdded.getCell(0).setValue((Object)Boolean.TRUE);
                } else {
                    rowAdded.getCell(0).setValue((Object)Boolean.FALSE);
                }
                rowAdded.getCell(2).setValue((Object)"\u7f16\u8f91\u754c\u9762");
                rowAdded.getCell(3).setValue((Object)Boolean.TRUE);
                rowAdded.getCell(4).setValue((Object)Boolean.TRUE);
                EasUIHyperLinkAssembler.this.lockCell(rowAdded.getCell(5));
                EasUIHyperLinkAssembler.this.reportTable.getEditManager().editCellAt(rowAdded.getRowIndex(), 1);
                EasUIHyperLinkAssembler.this.syncParams();
            }
        });
        this.reportTable.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                EasUIHyperLinkAssembler.this.syncParams();
            }
        });
        this.reportTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                if (e.getColIndex() == 0 && Boolean.TRUE == e.getOldValue()) {
                    e.setCancel(true);
                }
            }

            public void editStopping(KDTEditEvent e) {
                int col = e.getColIndex();
                if (col == 0) {
                    if (!e.getValue().equals(e.getOldValue())) {
                        int size = EasUIHyperLinkAssembler.this.reportTable.getRowCount();
                        for (int i = 0; i < size; ++i) {
                            if (e.getRowIndex() == i) continue;
                            IRow otherRow = EasUIHyperLinkAssembler.this.reportTable.getRow(i);
                            otherRow.getCell(0).setValue((Object)Boolean.FALSE);
                        }
                    }
                } else if (col == 2) {
                    IRow row = EasUIHyperLinkAssembler.this.reportTable.getRow(EasUIHyperLinkAssembler.this.reportTable.getSelectManager().getActiveRowIndex());
                    if ("\u7f16\u8f91\u754c\u9762".equals(e.getValue())) {
                        EasUIHyperLinkAssembler.this.unlockCell(row.getCell(3));
                    } else {
                        ICell cell = row.getCell(3);
                        EasUIHyperLinkAssembler.this.lockCell(cell);
                        cell.setValue((Object)Boolean.TRUE);
                    }
                } else if (col == 4) {
                    IRow row = EasUIHyperLinkAssembler.this.reportTable.getRow(EasUIHyperLinkAssembler.this.reportTable.getSelectManager().getActiveRowIndex());
                    if (e.getValue() == Boolean.FALSE) {
                        EasUIHyperLinkAssembler.this.unlockCell(row.getCell(5));
                    } else {
                        ICell cell = row.getCell(5);
                        cell.setValue(null);
                        EasUIHyperLinkAssembler.this.lockCell(cell);
                    }
                }
            }

            public void editStopped(KDTEditEvent e) {
                if (e.getColIndex() == 3) {
                    EasUIHyperLinkAssembler.this.syncParams();
                }
            }
        });
        this.paramTable.getEditManager().addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editCanceled(KDTEditEvent e) {
                if (e.getOldValue() == null) {
                    EasUIHyperLinkAssembler.this.paramTable.removeRow(e.getRowIndex());
                }
            }

            public void editStopping(KDTEditEvent e) {
                if (e.getColIndex() == 0) {
                    Object oldValue = e.getOldValue();
                    Object value = e.getValue();
                    List list = EasUIHyperLinkAssembler.this.getCurrentTransitionIDList();
                    list.remove(oldValue);
                    if (e.getValue() != null) {
                        list.add(value);
                    }
                    if (value == null && oldValue == null) {
                        e.setCancel(true);
                        EasUIHyperLinkAssembler.this.paramTable.getEditManager().editingCanceled();
                        return;
                    }
                }
            }
        });
    }

    private void lockCell(ICell cell) {
        StyleAttributes sa = cell.getStyleAttributes();
        sa.setBackground(this.locked);
        sa.setLocked(true);
    }

    private void unlockCell(ICell cell) {
        StyleAttributes sa = cell.getStyleAttributes();
        sa.setBackground(null);
        sa.setLocked(false);
    }

    private void syncParams() {
        this.paramTable.removeRows();
        int index = this.reportTable.getSelectManager().getActiveRowIndex();
        if (index < 0) {
            return;
        }
        IRow row = this.reportTable.getRow(index);
        Map map = (Map)row.getUserObject();
        if (map == null) {
            return;
        }
        this.refreshParamTable((List)map.get(UI_ID_LIST));
        if (this.paramTable.getRowCount() > 0) {
            this.paramTable.getSelectManager().select(0, 0);
        }
    }

    private void refreshParamTable(List idList) {
        this.paramTable.removeRows();
        if (idList == null) {
            return;
        }
        Iterator iterator = idList.iterator();
        while (iterator.hasNext()) {
            this.paramTable.addRow().getCell(0).setValue(iterator.next());
        }
    }

    private void showMsgBox(String msg) {
        MessageUtil.msgboxInfo((Component)((Object)this), msg);
    }

    @Override
    public void setAssembledTargets(List params) {
        this.lastAssembled = null;
        this.reportTable.removeRows();
        this.paramTable.removeRows();
        if (params == null) {
            return;
        }
        int size = params.size();
        for (int i = 0; i < size; ++i) {
            HashMap map = (HashMap)params.get(i);
            map = (HashMap)map.clone();
            IRow rowAdded = this.reportTable.addRow();
            rowAdded.getCell(0).setValue((Object)Boolean.valueOf((String)map.get("DEFAULT_SUGGESTION")));
            rowAdded.getCell(1).setValue((Object)((String)map.get("DISPLAY_NAME")));
            if ("editui".equals(map.get(UI_TYPE))) {
                rowAdded.getCell(2).setValue((Object)"\u7f16\u8f91\u754c\u9762");
            } else {
                rowAdded.getCell(2).setValue((Object)"\u5e8f\u65f6\u7c3f");
                this.lockCell(rowAdded.getCell(3));
            }
            rowAdded.getCell(3).setValue((Object)Boolean.valueOf((String)map.get(UI_READ_ONLY)));
            Object clsName = map.get(UI_CLASS_NAME);
            if (clsName == null) {
                rowAdded.getCell(4).setValue((Object)Boolean.TRUE);
                this.lockCell(rowAdded.getCell(5));
            } else {
                rowAdded.getCell(4).setValue((Object)Boolean.FALSE);
                rowAdded.getCell(5).setValue(clsName);
            }
            CommonCalculableProps[] idlist = (CommonCalculableProps[])map.get(UI_ID_LIST);
            if (idlist != null) {
                ArrayList<String> list = new ArrayList<String>();
                int length = idlist.length;
                for (int m = 0; m < length; ++m) {
                    list.add(this.getFormula(idlist[m]));
                }
                map.put(UI_ID_LIST, list);
            }
            rowAdded.setUserObject((Object)map);
        }
        this.reportTable.getSelectManager().select(0, 0);
    }

    @Override
    public List getAssembledTargets() {
        this.lastAssembled = null;
        int count = this.reportTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            List items;
            IRow curRow;
            HashMap<String, String> map;
            if (this.lastAssembled == null) {
                this.lastAssembled = new ArrayList();
            }
            if ((map = (HashMap<String, String>)(curRow = this.reportTable.getRow(i)).getUserObject()) != null && (items = (List)map.get(UI_ID_LIST)) != null && items.size() > 0) {
                CommonCalculableProps[] idlist = new CommonCalculableProps[items.size()];
                int size = items.size();
                for (int j = 0; j < size; ++j) {
                    idlist[j] = this.getCommonCalculableProps((String)items.get(j));
                }
                map.put(UI_ID_LIST, (String)idlist);
            }
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put("ASSEMBLER_NAME", EasUIHyperLinkAssembler.class.getName());
            map.put("HYPERLINK_PREFIX", PREFIX);
            Object o = curRow.getCell(0).getValue();
            if (Boolean.TRUE.equals(o)) {
                map.put("DEFAULT_SUGGESTION", o.toString());
            } else {
                map.remove("DEFAULT_SUGGESTION");
            }
            map.put("DISPLAY_NAME", (String)curRow.getCell(1).getValue());
            Object uiType = curRow.getCell(2).getValue();
            if ("\u7f16\u8f91\u754c\u9762" == uiType) {
                map.put(UI_TYPE, "editui");
            } else {
                map.put(UI_TYPE, "listui");
            }
            map.put(UI_READ_ONLY, curRow.getCell(3).getValue().toString());
            if (Boolean.TRUE != curRow.getCell(4).getValue()) {
                map.put(UI_CLASS_NAME, (String)curRow.getCell(5).getValue());
            } else {
                map.remove(UI_CLASS_NAME);
            }
            this.lastAssembled.add(map);
        }
        return this.lastAssembled;
    }

    @Override
    public Map getSuggestedDefaultTarget() {
        Map map = null;
        int size = this.lastAssembled.size();
        for (int i = 0; i < size; ++i) {
            Map curMap = (Map)this.lastAssembled.get(i);
            if (curMap.get("DEFAULT_SUGGESTION") == null) continue;
            map = curMap;
            break;
        }
        return map;
    }

    @Override
    public boolean checkValid() {
        HashSet<Object> allAlias = new HashSet<Object>();
        int count = this.reportTable.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow curRow = this.reportTable.getRow(i);
            Object value = curRow.getCell(1).getValue();
            if (value == null) {
                this.showMsgBox("\u7b2c" + (i + 1) + "\u884c\u7684\u5f15\u7528\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
                return false;
            }
            if (!allAlias.add(value)) {
                this.showMsgBox("\u7b2c" + (i + 1) + "\u884c\u7684\u5f15\u7528\u540d\u79f0 [" + value + "] \u4e0e\u5176\u4ed6\u884c\u91cd\u590d\uff01");
                return false;
            }
            Map ids = (Map)curRow.getUserObject();
            if (ids == null || this.getCurrentTransitionIDList().size() == 0) {
                this.showMsgBox("\u8054\u67e5\u76ee\u6807 [" + curRow.getCell(1).getValue() + "] \u6ca1\u6709\u914d\u7f6e\u4efb\u4f55\u5355\u636eID\uff01");
                return false;
            }
            if (curRow.getCell(2).getValue() == "\u7f16\u8f91\u754c\u9762" && ((List)ids.get(UI_ID_LIST)).size() != 1) {
                this.showMsgBox("\u8054\u67e5\u76ee\u6807 [" + curRow.getCell(1).getValue() + "] \u88ab\u8bbe\u7f6e\u4e3a\u7f16\u8f91\u754c\u9762\uff0c\u53ef\u4e14\u4ec5\u53ef\u8bbe\u7f6e\u4e00\u4e2a\u5355\u636eID\uff01");
                return false;
            }
            List items = (List)ids.get(UI_ID_LIST);
            int size = items.size();
            for (int j = 0; j < size; ++j) {
                String formula = (String)items.get(j);
                if (this.getCommonCalculableProps(formula) != null) continue;
                this.showMsgBox("\u516c\u5f0f\" " + formula + " \"\u4e0d\u80fd\u88ab\u6b63\u786e\u89e3\u6790\uff01");
                return false;
            }
            if (curRow.getCell(4).getValue() != Boolean.FALSE || curRow.getCell(5).getValue() != null) continue;
            this.showMsgBox("\u8054\u67e5\u76ee\u6807 [" + curRow.getCell(1).getValue() + "] \u88ab\u8bbe\u7f6e\u4e3a\u7981\u6b62\u81ea\u52a8\u68c0\u6d4b\u5355\u636eUI\uff0c\u5fc5\u987b\u8bbe\u7f6e\u4e00\u4e2a\u5355\u636e\u7c7b\u540d\uff01");
            return false;
        }
        return true;
    }

    @Override
    public String getHyperLinkPrefix() {
        return PREFIX;
    }

    @Override
    public String getDisplayName() {
        return "EAS\u5355\u636e";
    }
}

