/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.rd.celltree;

import com.kingdee.bos.ctrl.ext.rd.celltree.ICellTreeRenderModel;
import com.kingdee.bos.ctrl.ext.rd.celltree.LevelModel;
import com.kingdee.bos.ctrl.ext.rd.celltree.TreeCellUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kds.impl.SpreadCellTextRender;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class CellTreeSpreadCellTextRender
extends SpreadCellTextRender {
    public static final int CellWidth = 14;
    private ICellTreeRenderModel _model = null;
    private Stroke stroke = new BasicStroke(1.0f);
    private Stroke dashStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f}, 0.0f);

    @Override
    public void draw(Graphics g, Shape clip, Object object, Style style, Object extObject) {
        Shape old = g.getClip();
        Rectangle r = this.reSetClip((Rectangle2D)clip);
        if (r != null) {
            if (this._model.hasNode()) {
                super.draw(g, r, object, style, extObject);
                Graphics2D g2d = (Graphics2D)g;
                if (this._model.isRowCellDisplay()) {
                    this.drawRowNode(g2d, clip);
                } else if (this._model.isColCellDisplay()) {
                    this.drawColNode(g2d, clip);
                }
            } else {
                super.draw(g, clip, object, style, extObject);
            }
        } else {
            super.draw(g, clip, object, style, extObject);
        }
        g.setClip(old);
    }

    private void drawColNode(Graphics2D g2d, Shape clip) {
        int i;
        Color c = g2d.getColor();
        g2d.setColor(Color.BLACK);
        Rectangle r = clip.getBounds();
        int basePos = r.x + 11 * this._model.getLevel();
        if (this._model.getNodeType() == 2) {
            if (this._model.isFront()) {
                int x1 = basePos + 2;
                int y1 = r.y + (r.height - 14) / 2 + 2;
                int width = 11;
                TreeCellUtil.drawRectangle(g2d, x1, y1, width, width);
                g2d.drawLine(x1 + 2, y1 + width / 2, x1 + width - 3, y1 + width / 2);
                g2d.drawLine(x1 + width / 2, y1 + 2, x1 + width / 2, y1 + width - 3);
            } else {
                TreeCellUtil.drawRectangle(g2d, basePos + 2, r.y + (r.height - 14) / 2 + 2, 11, 11);
                g2d.drawLine(basePos + 4, r.y + (r.height - 14) / 2 + 2 + 5, basePos + 14 - 4, r.y + (r.height - 14) / 2 + 5 + 2);
                g2d.drawLine(basePos + 2 + 5, r.y + (r.height - 14) / 2 + 4, basePos + 2 + 5, r.y + (r.height - 14) / 2 + 14 - 4);
            }
        } else if (this._model.getNodeType() == 1) {
            if (this._model.isFront()) {
                TreeCellUtil.drawRectangle(g2d, basePos + 2, r.y + (r.height - 14) / 2 + 2, 11, 11);
                g2d.drawLine(basePos + 4, r.y + (r.height - 14) / 2 + 2 + 5, basePos + 14 - 4, r.y + (r.height - 14) / 2 + 5 + 2);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(basePos + 2 + 5, r.y + (r.height - 14) / 2 + 14 - 2, basePos + 2 + 5, r.y + r.height);
                g2d.setStroke(this.stroke);
            } else {
                TreeCellUtil.drawRectangle(g2d, basePos + 2, r.y + (r.height - 14) / 2 + 2, 11, 11);
                g2d.drawLine(basePos + 4, r.y + (r.height - 14) / 2 + 2 + 5, basePos + 14 - 4, r.y + (r.height - 14) / 2 + 5 + 2);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(basePos + 2 + 5, r.y, basePos + 2 + 5, r.y + (r.height - 14) / 2 + 2);
                g2d.setStroke(this.stroke);
            }
        }
        LevelModel levelModel = this._model.getLevelModel();
        int size = levelModel.getSize();
        if (this._model.isFront()) {
            for (i = 0; i < size; ++i) {
                int pos;
                if (levelModel.getType(i) == LevelModel.LINE) {
                    g2d.setStroke(this.dashStroke);
                    pos = r.x + i * 11 + 7;
                    g2d.drawLine(pos, r.y, pos, r.y + r.height);
                    g2d.setStroke(this.stroke);
                    continue;
                }
                if (levelModel.getType(i) != LevelModel.END) continue;
                pos = r.x + i * 11 + 7;
                g2d.drawLine(pos, r.y + r.height / 2, pos + 3, r.y + r.height / 2);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(pos, r.y, pos, r.y + r.height / 2);
                g2d.setStroke(this.stroke);
            }
        } else {
            for (i = 0; i < size; ++i) {
                if (levelModel.getType(i) == LevelModel.LINE) {
                    g2d.setStroke(this.dashStroke);
                    basePos = r.x + i * 11 + 7;
                    g2d.drawLine(basePos, r.y - 2, basePos, r.y + r.height + 2);
                    g2d.setStroke(this.stroke);
                    continue;
                }
                if (levelModel.getType(i) != LevelModel.END) continue;
                int pos = r.x + i * 11 + 7;
                g2d.drawLine(pos, r.y + r.height / 2, pos + 3, r.y + r.height / 2);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(pos, r.y + r.height / 2, pos, r.y + r.height);
                g2d.setStroke(this.stroke);
            }
        }
        g2d.setColor(c);
    }

    private void drawRowNode(Graphics2D g2d, Shape clip) {
        int y;
        int x;
        Rectangle r = clip.getBounds();
        int basePos = r.y + 11 * this._model.getLevel();
        if (this._model.getNodeType() == 2) {
            if (this._model.isFront()) {
                x = r.x + 2 + (r.width - 14) / 2;
                y = basePos + 2;
                TreeCellUtil.drawRectangle(g2d, x, y, 11, 11);
                g2d.drawLine(x + 2, y + 5, x + 8, y + 5);
                g2d.drawLine(x + 5, y + 2, x + 5, y + 8);
            } else {
                x = r.x + 2 + (r.width - 14) / 2;
                y = basePos + 2;
                TreeCellUtil.drawRectangle(g2d, x, y, 11, 11);
                g2d.drawLine(x + 2, y + 5, x + 8, y + 5);
                g2d.drawLine(x + 5, y + 2, x + 5, y + 8);
            }
        } else if (this._model.getNodeType() == 1) {
            if (this._model.isFront()) {
                x = r.x + 2 + (r.width - 14) / 2;
                y = basePos + 2;
                TreeCellUtil.drawRectangle(g2d, x, y, 11, 11);
                g2d.drawLine(x + 2, y + 5, x + 8, y + 5);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(x + 14 - 3, y + 5, r.x + r.width, y + 5);
                g2d.setStroke(this.stroke);
            } else {
                x = r.x + 2 + (r.width - 14) / 2;
                y = basePos + 2;
                TreeCellUtil.drawRectangle(g2d, x, y, 11, 11);
                g2d.drawLine(x + 2, y + 5, x + 8, y + 5);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(r.x, y + 5, x - 1, y + 5);
                g2d.setStroke(this.stroke);
            }
        }
        LevelModel levelModel = this._model.getLevelModel();
        int size = levelModel.getSize();
        if (this._model.isFront()) {
            for (int i = 0; i < size; ++i) {
                int pos;
                if (levelModel.getType(i) == LevelModel.LINE) {
                    pos = r.y + i * 11 + 7;
                    g2d.setStroke(this.dashStroke);
                    g2d.drawLine(r.x, pos, r.x + r.width, pos);
                    g2d.setStroke(this.stroke);
                    continue;
                }
                if (levelModel.getType(i) != LevelModel.END) continue;
                pos = r.y + i * 11 + 7;
                g2d.drawLine(r.x + r.width / 2, pos, r.x + r.width / 2, pos + 4);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(r.x, pos, r.x + r.width / 2, pos);
                g2d.setStroke(this.stroke);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                int pos;
                if (levelModel.getType(i) == LevelModel.LINE) {
                    pos = r.y + i * 11 + 7;
                    g2d.setStroke(this.dashStroke);
                    g2d.drawLine(r.x - 2, pos, r.x + r.width + 2, pos);
                    g2d.setStroke(this.stroke);
                    continue;
                }
                if (levelModel.getType(i) != LevelModel.END) continue;
                pos = r.y + i * 11 + 7;
                g2d.drawLine(r.x + r.width / 2, pos, r.x + r.width / 2, pos + 5);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(r.x + r.width / 2, pos, r.x + r.width, pos);
                g2d.setStroke(this.stroke);
            }
        }
    }

    public void setDrawModel(ICellTreeRenderModel model) {
        this._model = model;
    }

    private Rectangle reSetClip(Rectangle2D r) {
        if (!this._model.isRowXorColumnCellTreeDisplay()) {
            return null;
        }
        int width = 11;
        if (this._model.isColCellDisplay()) {
            int level = this._model.getLevel();
            int x = (int)(r.getX() + (double)(width * level) + 14.0 + 2.0);
            int w = (int)(r.getWidth() - (double)x + r.getX());
            return new Rectangle(x, (int)r.getY(), w, (int)r.getHeight());
        }
        if (this._model.isRowCellDisplay()) {
            int level = this._model.getLevel();
            int y = (int)(r.getY() + (double)(width * level) + 2.0 + 14.0);
            int h = (int)(r.getHeight() - (double)y + r.getY());
            return new Rectangle((int)r.getX(), y, (int)r.getWidth(), h);
        }
        return null;
    }

    public boolean isRowXorColumnCellTreeDisplay() {
        return this._model.isRowXorColumnCellTreeDisplay();
    }
}

